/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.propertytester;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.jboss.tools.openshift.common.core.utils.ProjectUtils;
import org.jboss.tools.openshift.egit.core.EGitUtils;

public class ProjectPropertyTester
extends PropertyTester {
    private static final String PROPERTY_IF_SHARED_IS_EGIT = "ifSharedIsEGit";
    private static final String PROPERTY_IS_INTERNAL_RSE = "isInternalRSE";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (PROPERTY_IF_SHARED_IS_EGIT.equals(property)) {
            return this.isIfSharedIsEGit(receiver, args, expectedValue);
        }
        if (PROPERTY_IS_INTERNAL_RSE.equals(property)) {
            return this.isInternalRSE(receiver, args, expectedValue);
        }
        return false;
    }

    private boolean isIfSharedIsEGit(Object receiver, Object[] args, Object expectedValue) {
        if (!(receiver instanceof IProject) || !(expectedValue instanceof Boolean)) {
            return false;
        }
        IProject project = (IProject)receiver;
        Boolean expectedBoolean = (Boolean)expectedValue;
        if (EGitUtils.isShared((IProject)project)) {
            return expectedBoolean.equals(EGitUtils.isSharedWithGit((IProject)project));
        }
        return true;
    }

    private boolean isInternalRSE(Object receiver, Object[] args, Object expectedValue) {
        if (!(receiver instanceof IProject) || !(expectedValue instanceof Boolean)) {
            return false;
        }
        return ((Boolean)expectedValue).equals(ProjectUtils.isInternalRSE((String)((IProject)receiver).getName()));
    }
}

