/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.command;

import com.openshift.client.IApplication;
import com.openshift.internal.client.utils.StringUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.tools.openshift.express.internal.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.express.internal.ui.ExpressUIActivator;
import org.jboss.tools.openshift.express.internal.ui.job.LoadApplicationJob;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;

public abstract class AbstractApplicationHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IApplication application = (IApplication)UIUtils.getFirstElement((ISelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event), IApplication.class);
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (application != null) {
            return this.execute(application, shell);
        }
        IServer server = (IServer)UIUtils.getFirstElement((ISelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event), IServer.class);
        if (server == null) {
            return ExpressUIActivator.createCancelStatus(NLS.bind((String)"Could not {0}: server adapter not found.", (Object)this.getOperationName()));
        }
        return this.execute(server, shell);
    }

    protected IStatus execute(IServer server, Shell shell) {
        String applicationName = OpenShiftServerUtils.getApplicationName((IServerAttributes)server);
        if (StringUtils.isEmpty((String)applicationName)) {
            return ExpressUIActivator.createCancelStatus(NLS.bind((String)"Could not {0} application: application for server adapter {1} not found.", (Object)this.getOperationName(), (Object)server.getName()));
        }
        return this.execute(new LoadApplicationJob(server), shell);
    }

    protected abstract IStatus execute(IApplication var1, Shell var2);

    protected abstract IStatus execute(LoadApplicationJob var1, Shell var2);

    protected abstract String getOperationName();
}

