/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.refactoring;

import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public abstract class SeamProjectChange
extends Change {
    protected IProject project;
    public static final String[] PROJECT_NAME_PROPERTIES = new String[]{"seam.parent.project", "seam.ear.project", "seam.ejb.project", "seam.test.project"};
    public static final String[] FOLDER_PROPERTIES = new String[]{"model.sources", "action.sources", "test.sources", "seam.project.web.root.folder"};
    protected HashMap<String, String> preferences = new HashMap();

    public SeamProjectChange(IProject project) {
        this.project = project;
    }

    public abstract boolean isRelevant();

    public Object getModifiedElement() {
        return this.project;
    }

    public String getName() {
        return "Update Seam Project Properties for " + this.project.getName();
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    protected IEclipsePreferences getSeamPreferences() {
        ProjectScope projectScope = new ProjectScope(this.project);
        return projectScope.getNode("org.jboss.tools.seam.core");
    }

    public HashMap<String, String> getPreferencesForTest() {
        return this.preferences;
    }
}

