/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.jboss.tools.common.model.project.ext.event.Change;
import org.jboss.tools.seam.core.ISeamComponentDeclaration;
import org.jboss.tools.seam.core.ISeamContextVariable;
import org.jboss.tools.seam.core.ISeamElement;
import org.jboss.tools.seam.core.ScopeType;
import org.jboss.tools.seam.internal.core.AbstractSeamDeclaration;
import org.jboss.tools.seam.internal.core.SeamComponent;

public abstract class SeamComponentDeclaration
extends AbstractSeamDeclaration
implements ISeamComponentDeclaration {
    public static final String PATH_OF_SCOPE = "scope";
    protected Set<SeamComponent> components = new HashSet<SeamComponent>();

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    public ScopeType getScope() {
        return ScopeType.UNSPECIFIED;
    }

    public Set<SeamComponent> getComponents() {
        return this.components;
    }

    public void bindToComponent(SeamComponent c) {
        this.components.add(c);
    }

    public void unbindFromComponent(SeamComponent c) {
        this.components.remove(c);
    }

    @Override
    public List<Change> merge(ISeamElement s) {
        List changes = super.merge(s);
        SeamComponentDeclaration d = (SeamComponentDeclaration)s;
        this.source = d.source;
        if (!this.stringsEqual(this.name, d.name)) {
            changes = Change.addChange(changes, (Change)new Change((Object)this, "name", (Object)this.name, (Object)d.name));
            this.name = d.name;
        }
        if (this.id != d.id) {
            this.id = d.id;
        }
        this.attributes = d.attributes;
        return changes;
    }

    public Set<ISeamContextVariable> getDeclaredVariables() {
        return null;
    }

    @Override
    public SeamComponentDeclaration clone() throws CloneNotSupportedException {
        SeamComponentDeclaration c = (SeamComponentDeclaration)super.clone();
        c.components = new HashSet<SeamComponent>();
        return c;
    }

    @Override
    public String getXMLName() {
        return "component";
    }
}

