/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.portlet.ui;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.tools.portlet.core.PortletCoreActivator;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletUIActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.jboss.tools.portlet.ui";
    private static PortletUIActivator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static PortletUIActivator getDefault() {
        return plugin;
    }

    public static IFile getPortletXmlFile(IProject project) {
        try {
            if (project == null || !project.hasNature("org.eclipse.wst.common.modulecore.ModuleCoreNature")) {
                return null;
            }
        }
        catch (CoreException e) {
            PortletUIActivator.log(e);
            return null;
        }
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        IVirtualFile portletVirtualFile = component.getRootFolder().getFile("WEB-INF/portlet.xml");
        if (!portletVirtualFile.getUnderlyingFile().exists()) {
            return null;
        }
        IFile portletFile = portletVirtualFile.getUnderlyingFile();
        return portletFile;
    }

    public static void log(Exception e, String message) {
        Status status = new Status(4, PLUGIN_ID, message, (Throwable)e);
        PortletCoreActivator.getDefault().getLog().log((IStatus)status);
    }

    public static void log(Throwable e) {
        Status status = new Status(4, PLUGIN_ID, e.getLocalizedMessage(), e);
        PortletCoreActivator.getDefault().getLog().log((IStatus)status);
    }

    public static boolean isPortletProject(IDataModel model) {
        String projectName = model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        if (projectName != null && !"".equals(projectName.trim())) {
            IProject project = ProjectUtilities.getProject((String)projectName);
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                return facetedProject != null && facetedProject.hasProjectFacet(PortletUIActivator.getPortletFacet());
            }
            catch (CoreException e) {
                PortletUIActivator.log(e);
            }
        }
        return false;
    }

    private static IPath getJBossConfigPath(IDataModel model) {
        String projectName = model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        if (projectName != null && !"".equals(projectName.trim())) {
            IProject project = ProjectUtilities.getProject((String)projectName);
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                return PortletUIActivator.getJBossConfigPath((IFacetedProjectBase)facetedProject);
            }
            catch (CoreException e) {
                PortletUIActivator.log(e);
            }
        }
        return null;
    }

    public static IPath getJBossConfigPath(IFacetedProjectBase facetedProject) {
        if (facetedProject != null) {
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime = facetedProject.getPrimaryRuntime();
            if (facetRuntime == null) {
                return null;
            }
            IRuntime runtime = PortletCoreActivator.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)facetRuntime);
            if (runtime == null) {
                return null;
            }
            IJBossServerRuntime jbossRuntime = (IJBossServerRuntime)runtime.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
            if (jbossRuntime == null) {
                return null;
            }
            IPath jbossLocation = runtime.getLocation();
            IPath configPath = jbossLocation.append("server").append(jbossRuntime.getJBossConfiguration());
            return configPath;
        }
        return null;
    }

    public static boolean isJBossPortalRuntime(IDataModel model) {
        IPath configPath = PortletUIActivator.getJBossConfigPath(model);
        if (configPath == null) {
            return false;
        }
        IPath portalPath = configPath.append("deploy/jboss-portal.sar");
        File portalFile = portalPath.toFile();
        if (portalFile != null && portalFile.exists()) {
            return true;
        }
        portalPath = configPath.append("deploy/jboss-portal-ha.sar");
        portalFile = portalPath.toFile();
        return portalFile != null && portalFile.exists();
    }

    public static boolean isGateIn(IDataModel model) {
        IPath configPath = PortletUIActivator.getJBossConfigPath(model);
        if (configPath == null) {
            return false;
        }
        IPath portalPath = configPath.append("deploy/gatein.ear");
        File portalFile = portalPath.toFile();
        return portalFile != null && portalFile.exists();
    }

    private static IProjectFacet getPortletFacet() {
        try {
            return ProjectFacetsManager.getProjectFacet((String)"jboss.portlet");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static Set<String> getPortletNames(IFile portletFile) {
        HashSet<String> portletNames = new HashSet<String>();
        if (portletFile == null || !portletFile.exists()) {
            return portletNames;
        }
        IDOMModel domModel = null;
        try {
            domModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForRead(portletFile);
            IDOMDocument document = domModel.getDocument();
            NodeList portlets = document.getElementsByTagName("portlet-name");
            if (portlets == null || portlets.getLength() == 0) {
                HashSet<String> hashSet = portletNames;
                return hashSet;
            }
            try {
                int i = 0;
                while (i < portlets.getLength()) {
                    IStructuredDocumentRegion structuredDocumentRegion;
                    String value;
                    Node child;
                    Node node = portlets.item(i);
                    NodeList children = node.getChildNodes();
                    if (children != null && children.getLength() == 1 && (child = children.item(0)) != null && 3 == child.getNodeType() && (value = (structuredDocumentRegion = ((IDOMNode)child).getFirstStructuredDocumentRegion()).getFullText()) != null) {
                        portletNames.add(value.trim());
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                PortletCoreActivator.log((Throwable)e);
            }
        }
        finally {
            if (domModel != null) {
                domModel.releaseFromRead();
            }
        }
        return portletNames;
    }
}

