/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.jdt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.core.CreateTypeHierarchyOperation;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JavaMethodParameter;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JavaMethodSignature;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.RangeUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.SourceType;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJavaMethodParameter;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJavaMethodSignature;

public final class JdtUtils {
    private JdtUtils() {
    }

    public static ICompilationUnit getCompilationUnit(IResource resource) {
        IJavaElement element = JavaCore.create((IResource)resource);
        if (element instanceof ICompilationUnit) {
            return (ICompilationUnit)element;
        }
        return null;
    }

    public static ICompilationUnit getCompilationUnit(IJavaElement element) {
        if (element instanceof IMember) {
            return ((IMember)element).getCompilationUnit();
        }
        if (element instanceof IAnnotation && element.getParent() instanceof IMember) {
            return ((IMember)element.getParent()).getCompilationUnit();
        }
        if (element instanceof ICompilationUnit) {
            return (ICompilationUnit)element;
        }
        return null;
    }

    public static boolean isArchive(IJavaElement javaElement) {
        return javaElement.getElementType() == 3 && ((IPackageFragmentRoot)javaElement).isArchive();
    }

    public static boolean isAbstractType(IType type) throws JavaModelException {
        if (type == null) {
            return true;
        }
        return Flags.isAbstract((int)type.getFlags());
    }

    public static IType resolveTopLevelType(ICompilationUnit compilationUnit) throws JavaModelException {
        if (compilationUnit != null && compilationUnit.exists() && compilationUnit.getTypes() != null && compilationUnit.getTypes().length > 0) {
            if (compilationUnit.getTypes()[0].getDeclaringType() != null) {
                return compilationUnit.getTypes()[0].getDeclaringType();
            }
            return compilationUnit.getTypes()[0];
        }
        return null;
    }

    public static boolean isTopLevelType(IType type) {
        return type.equals(type.getTypeRoot().findPrimaryType());
    }

    public static boolean isWorkingCopy(IJavaElement element) {
        ICompilationUnit compilationUnit = JdtUtils.getCompilationUnit(element);
        if (compilationUnit != null) {
            return compilationUnit.isWorkingCopy();
        }
        return false;
    }

    public static IJavaElement getElementAt(ICompilationUnit compilationUnit, int location) throws JavaModelException {
        if (compilationUnit == null) {
            return null;
        }
        IJavaElement element = compilationUnit.getElementAt(location);
        if (element instanceof IAnnotatable) {
            IAnnotation[] iAnnotationArray = ((IAnnotatable)element).getAnnotations();
            int n = iAnnotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotation annotation = iAnnotationArray[n2];
                int length = annotation.getSourceRange().getLength();
                int offset = annotation.getSourceRange().getOffset();
                if (offset <= location && location < offset + length) {
                    return annotation;
                }
                ++n2;
            }
        }
        return element;
    }

    public static IJavaElement getElementAt(ICompilationUnit compilationUnit, int location, int type) throws JavaModelException {
        IJavaElement element = JdtUtils.getElementAt(compilationUnit, location);
        if (element != null && element.exists()) {
            return element.getAncestor(type);
        }
        return null;
    }

    public static CompilationUnit parse(ICompilationUnit compilationUnit, IProgressMonitor progressMonitor) throws JavaModelException {
        if (compilationUnit == null || !compilationUnit.exists()) {
            return null;
        }
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setKind(8);
        parser.setSource(compilationUnit);
        parser.setResolveBindings(true);
        parser.setEnvironment(null, null, null, true);
        parser.setBindingsRecovery(true);
        CompilationUnit ast = (CompilationUnit)parser.createAST(progressMonitor);
        return ast;
    }

    public static CompilationUnit parse(IJavaElement javaElement, IProgressMonitor progressMonitor) throws JavaModelException {
        if (javaElement instanceof IMember) {
            return JdtUtils.parse(((IMember)javaElement).getCompilationUnit(), progressMonitor);
        }
        if (javaElement instanceof IAnnotation) {
            return JdtUtils.parse(((IAnnotation)javaElement).getAncestor(5), progressMonitor);
        }
        if (javaElement instanceof ICompilationUnit) {
            return JdtUtils.parse((ICompilationUnit)javaElement, progressMonitor);
        }
        return null;
    }

    public static Annotation resolveAnnotation(IMember member, CompilationUnit ast, String annotationName) throws JavaModelException {
        if (member.isBinary()) {
            IAnnotatable javaElement = (IAnnotatable)member;
            IAnnotation javaAnnotation = javaElement.getAnnotation(annotationName);
            if (javaAnnotation != null && javaAnnotation.exists()) {
                return new Annotation(javaAnnotation, javaAnnotation.getElementName(), JdtUtils.resolveAnnotationElements(javaAnnotation));
            }
            return null;
        }
        if (ast == null) {
            return null;
        }
        ASTNode memberNode = JdtUtils.findDeclaringNode(member, ast);
        List<?> memberModifiers = JdtUtils.getNodeModifiers(memberNode);
        return JdtUtils.findAnnotation(memberModifiers, annotationName);
    }

    public static Map<String, Annotation> resolveAllAnnotations(IMember member, CompilationUnit ast) throws JavaModelException {
        if (member.isBinary()) {
            IAnnotatable javaElement = (IAnnotatable)member;
            HashMap<String, Annotation> annotations = new HashMap<String, Annotation>();
            IAnnotation[] iAnnotationArray = javaElement.getAnnotations();
            int n = iAnnotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotation javaAnnotation = iAnnotationArray[n2];
                if (javaAnnotation.exists()) {
                    Annotation annotation = new Annotation(javaAnnotation, javaAnnotation.getElementName(), JdtUtils.resolveAnnotationElements(javaAnnotation));
                    annotations.put(annotation.getFullyQualifiedName(), annotation);
                }
                ++n2;
            }
            return annotations;
        }
        ASTNode memberNode = JdtUtils.findDeclaringNode(member, ast);
        List<?> memberModifiers = JdtUtils.getNodeModifiers(memberNode);
        return JdtUtils.findAllAnnotations(memberModifiers);
    }

    public static Annotation resolveAnnotation(IAnnotation javaAnnotation, CompilationUnit ast) throws JavaModelException {
        if (javaAnnotation.getParent() instanceof IMember) {
            return JdtUtils.resolveAnnotation((IMember)javaAnnotation.getParent(), ast, javaAnnotation.getElementName());
        }
        return null;
    }

    public static Annotation resolveAnnotationAt(int location, ICompilationUnit compilationUnit) throws JavaModelException {
        CompilationUnit ast = JdtUtils.parse(compilationUnit, (IProgressMonitor)new NullProgressMonitor());
        if (ast != null) {
            return JdtUtils.findAnnotation(NodeFinder.perform((ASTNode)ast, (int)location, (int)1), location);
        }
        return null;
    }

    private static List<?> getNodeModifiers(ASTNode node) {
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case 55: {
                return (List)node.getStructuralProperty((StructuralPropertyDescriptor)TypeDeclaration.MODIFIERS2_PROPERTY);
            }
            case 81: {
                return (List)node.getStructuralProperty((StructuralPropertyDescriptor)AnnotationTypeDeclaration.MODIFIERS2_PROPERTY);
            }
            case 31: {
                return (List)node.getStructuralProperty((StructuralPropertyDescriptor)MethodDeclaration.MODIFIERS2_PROPERTY);
            }
            case 23: {
                return (List)node.getStructuralProperty((StructuralPropertyDescriptor)FieldDeclaration.MODIFIERS2_PROPERTY);
            }
        }
        return null;
    }

    private static ASTNode findDeclaringNode(IMember member, CompilationUnit ast) throws JavaModelException {
        switch (member.getElementType()) {
            case 7: {
                ASTNode typeNode;
                IType type = (IType)member;
                if (!type.isResolved() || (typeNode = ast.findDeclaringNode(type.getKey())) == null) break;
                return typeNode;
            }
            case 9: {
                ASTNode methodNode;
                IMethod method = (IMethod)member;
                if (!method.isResolved() || (methodNode = ast.findDeclaringNode(method.getKey())) == null) break;
                return methodNode;
            }
            case 8: {
                ASTNode fieldNode;
                ASTNode variableDeclarationFragment;
                IField field = (IField)member;
                if (!field.isResolved() || (variableDeclarationFragment = ast.findDeclaringNode(field.getKey())) == null || (fieldNode = variableDeclarationFragment.getParent()) == null) break;
                return fieldNode;
            }
        }
        NodeFinder finder = new NodeFinder((ASTNode)ast, member.getSourceRange().getOffset(), member.getSourceRange().getLength());
        return finder.getCoveredNode();
    }

    private static Annotation findAnnotation(ASTNode node, int location) throws JavaModelException {
        if (node == null) {
            return null;
        }
        if (!(node instanceof org.eclipse.jdt.core.dom.Annotation)) {
            return JdtUtils.findAnnotation(node.getParent(), location);
        }
        IAnnotationBinding annotationBinding = ((org.eclipse.jdt.core.dom.Annotation)node).resolveAnnotationBinding();
        if (annotationBinding.getJavaElement() != null && annotationBinding.getJavaElement().getElementType() == 16) {
            return JdtUtils.toAnnotation(annotationBinding, (IAnnotation)annotationBinding.getJavaElement());
        }
        if (node.getParent().getNodeType() == 44) {
            SingleVariableDeclaration variableDeclaration = (SingleVariableDeclaration)node.getParent();
            IVariableBinding variableDeclarationBinding = variableDeclaration.resolveBinding();
            IAnnotationBinding[] annotationBindings = variableDeclarationBinding.getAnnotations();
            IMethod parentMethod = (IMethod)variableDeclarationBinding.getDeclaringMethod().getJavaElement();
            ILocalVariable localVariable = JdtUtils.getLocalVariable(variableDeclarationBinding, parentMethod);
            if (localVariable != null) {
                IAnnotation[] variableAnnotations = localVariable.getAnnotations();
                int j = 0;
                while (j < annotationBindings.length) {
                    IAnnotation javaAnnotation = variableAnnotations[j];
                    if (RangeUtils.matches(javaAnnotation.getSourceRange(), location)) {
                        IAnnotationBinding javaAnnotationBinding = annotationBindings[j];
                        return JdtUtils.toAnnotation(javaAnnotationBinding, javaAnnotation);
                    }
                    ++j;
                }
            }
        }
        return null;
    }

    private static Annotation findAnnotation(List<?> modifiers, String annotationName) {
        if (modifiers == null) {
            return null;
        }
        for (Object modifier : modifiers) {
            Annotation annotation;
            IAnnotationBinding annotationBinding;
            if (!(modifier instanceof org.eclipse.jdt.core.dom.Annotation) || (annotationBinding = ((org.eclipse.jdt.core.dom.Annotation)modifier).resolveAnnotationBinding()) == null) continue;
            String qualifiedName = annotationBinding.getAnnotationType().getQualifiedName();
            String name = annotationBinding.getAnnotationType().getName();
            if (!annotationName.equals(qualifiedName) && !annotationName.equals(name) || (annotation = JdtUtils.toAnnotation(annotationBinding, (IAnnotation)annotationBinding.getJavaElement())) == null) continue;
            return annotation;
        }
        return null;
    }

    private static Map<String, Annotation> findAllAnnotations(List<?> modifiers) {
        HashMap<String, Annotation> annotations = new HashMap<String, Annotation>();
        if (modifiers == null) {
            return annotations;
        }
        for (Object modifier : modifiers) {
            IAnnotationBinding annotationBinding;
            if (!(modifier instanceof org.eclipse.jdt.core.dom.Annotation) || (annotationBinding = ((org.eclipse.jdt.core.dom.Annotation)modifier).resolveAnnotationBinding()) == null) continue;
            String qualifiedName = annotationBinding.getAnnotationType().getQualifiedName();
            Annotation annotation = JdtUtils.toAnnotation(annotationBinding, (IAnnotation)annotationBinding.getJavaElement());
            if (annotation == null) continue;
            annotations.put(qualifiedName, annotation);
        }
        return annotations;
    }

    private static ILocalVariable getLocalVariable(IVariableBinding variableDeclarationBinding, IMethod parentMethod) throws JavaModelException {
        int i = -1;
        String[] stringArray = parentMethod.getParameterNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String paramName = stringArray[n2];
            ++i;
            if (paramName.equals(variableDeclarationBinding.getName())) break;
            ++n2;
        }
        if (i >= 0) {
            return parentMethod.getParameters()[i];
        }
        return null;
    }

    private static Annotation toAnnotation(IAnnotationBinding annotationBinding, IAnnotation javaAnnotation) {
        if (javaAnnotation == null) {
            return null;
        }
        String annotationName = annotationBinding.getAnnotationType().getQualifiedName();
        Map<String, List<String>> annotationElements = JdtUtils.resolveAnnotationElements(annotationBinding);
        return new Annotation(javaAnnotation, annotationName, annotationElements);
    }

    private static Map<String, List<String>> resolveAnnotationElements(IAnnotationBinding annotationBinding) {
        HashMap<String, List<String>> annotationElements = new HashMap<String, List<String>>();
        try {
            IMemberValuePairBinding[] iMemberValuePairBindingArray = annotationBinding.getAllMemberValuePairs();
            int n = iMemberValuePairBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePairBinding binding = iMemberValuePairBindingArray[n2];
                ArrayList<String> values = new ArrayList<String>();
                if (binding.getValue() != null) {
                    if (binding.getValue() instanceof Object[]) {
                        Object[] objectArray = (Object[])binding.getValue();
                        int n3 = objectArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Object v = objectArray[n4];
                            values.add(JdtUtils.toString(v));
                            ++n4;
                        }
                    } else {
                        values.add(JdtUtils.toString(binding.getValue()));
                    }
                }
                annotationElements.put(binding.getName(), values);
                ++n2;
            }
        }
        catch (RuntimeException runtimeException) {}
        return annotationElements;
    }

    public static String toString(Object value) {
        if (value instanceof ITypeBinding) {
            return ((ITypeBinding)value).getQualifiedName();
        }
        if (value instanceof IVariableBinding) {
            return ((IVariableBinding)value).getName();
        }
        if (value instanceof IAnnotationBinding) {
            return ((IAnnotationBinding)value).getName();
        }
        return value.toString();
    }

    public static ISourceRange resolveMemberPairValueRange(IAnnotation annotation, String memberName, CompilationUnit ast) throws JavaModelException {
        ASTNode node;
        IType ancestor = (IType)annotation.getAncestor(7);
        if (ancestor != null && ancestor.exists() && (node = JdtUtils.findMemberValuePair(annotation, memberName, ast)) != null) {
            return new SourceRange(node.getStartPosition(), node.getLength());
        }
        return null;
    }

    public static ASTNode findMemberValuePair(IAnnotation annotation, String memberName, CompilationUnit ast) throws JavaModelException {
        if (annotation != null && ast != null) {
            ASTNode node = NodeFinder.perform((ASTNode)ast, (ISourceRange)annotation.getSourceRange());
            if (node instanceof NormalAnnotation) {
                List allMemberValuePairs = (List)node.getStructuralProperty((StructuralPropertyDescriptor)NormalAnnotation.VALUES_PROPERTY);
                for (MemberValuePair memberValuePair : allMemberValuePairs) {
                    if (!memberValuePair.getName().getFullyQualifiedName().equals(memberName)) continue;
                    return memberValuePair;
                }
            } else if (node instanceof SingleMemberAnnotation) {
                return ((SingleMemberAnnotation)node).getValue();
            }
        }
        return null;
    }

    private static Map<String, List<String>> resolveAnnotationElements(IAnnotation annotation) throws JavaModelException {
        HashMap<String, List<String>> annotationElements = new HashMap<String, List<String>>();
        IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
        int n = iMemberValuePairArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemberValuePair element = iMemberValuePairArray[n2];
            ArrayList<String> values = new ArrayList<String>();
            if (element.getValue() instanceof Collection) {
                for (Object v : (Collection)element.getValue()) {
                    values.add(v.toString());
                }
            } else {
                values.add(element.getValue().toString());
            }
            annotationElements.put(element.getMemberName(), values);
            ++n2;
        }
        return annotationElements;
    }

    public static IType resolveType(String qName, IJavaProject javaProject, IProgressMonitor progressMonitor) throws CoreException {
        if (qName == null) {
            return null;
        }
        IType findType = javaProject.findType(qName);
        if (findType == null) {
            Logger.debug("Unable to find type with fully qualified name '" + qName + "' in Java Project '" + javaProject.getProject().getName() + "'");
        }
        return findType;
    }

    public static IType resolveType(ICompilationUnit compilationUnit, String handleIdentifier) throws JavaModelException {
        IType[] allTypes;
        IType[] iTypeArray = allTypes = compilationUnit.getAllTypes();
        int n = allTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            if (type.getHandleIdentifier().equals(handleIdentifier)) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    public static ITypeHierarchy resolveTypeHierarchy(IType baseType, IJavaElement scope, boolean includeLibraries, IProgressMonitor progressMonitor) throws CoreException {
        IJavaSearchScope searchScope;
        CreateTypeHierarchyOperation operation;
        ITypeHierarchy hierarchy;
        int appLibs = 0;
        if (includeLibraries) {
            appLibs = 2;
        }
        if ((hierarchy = (operation = new CreateTypeHierarchyOperation(baseType, null, searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{scope}, (int)(1 | appLibs | 8)), true)).getResult()) != null && hierarchy.exists()) {
            hierarchy.refresh(progressMonitor);
            return hierarchy;
        }
        Logger.warn("No type hierarchy found for " + baseType.getFullyQualifiedName());
        return null;
    }

    public static List<IType> findSubtypes(IJavaElement scope, IType superType, IProgressMonitor progressMonitor) throws CoreException, JavaModelException {
        ArrayList<IType> types = new ArrayList<IType>();
        if (superType != null) {
            IType[] allSubtypes;
            ITypeHierarchy hierarchy = JdtUtils.resolveTypeHierarchy(superType, scope, false, progressMonitor);
            IType[] iTypeArray = allSubtypes = hierarchy.getAllSubtypes(superType);
            int n = allSubtypes.length;
            int n2 = 0;
            while (n2 < n) {
                IType subtype = iTypeArray[n2];
                if (subtype.isStructureKnown() && subtype.getJavaProject().equals(scope.getJavaProject()) && hierarchy.getAllSubtypes(subtype).length == 0) {
                    types.add(subtype);
                }
                ++n2;
            }
        }
        return types;
    }

    public static List<IType> findSubtypes(IType type) throws CoreException {
        ArrayList<IType> arrayList;
        long start = System.currentTimeMillis();
        try {
            ArrayList<IType> types = new ArrayList<IType>();
            ITypeHierarchy returnTypeHierarchy = JdtUtils.resolveTypeHierarchy(type, (IJavaElement)type.getJavaProject(), false, (IProgressMonitor)new NullProgressMonitor());
            types.addAll(Arrays.asList(returnTypeHierarchy.getAllSubtypes(type)));
            types.add(type);
            arrayList = types;
        }
        catch (Throwable throwable) {
            Logger.tracePerf("Found subtypes of {} in {}ms", type.getFullyQualifiedName(), System.currentTimeMillis() - start);
            throw throwable;
        }
        Logger.tracePerf("Found subtypes of {} in {}ms", type.getFullyQualifiedName(), System.currentTimeMillis() - start);
        return arrayList;
    }

    public static List<IType> findSupertypes(IType type) throws CoreException {
        if (type == null) {
            return null;
        }
        ArrayList<IType> types = new ArrayList<IType>();
        types.add(type);
        ITypeHierarchy returnTypeHierarchy = JdtUtils.resolveTypeHierarchy(type, (IJavaElement)type.getJavaProject(), false, (IProgressMonitor)new NullProgressMonitor());
        types.addAll(Arrays.asList(returnTypeHierarchy.getAllSupertypes(type)));
        return types;
    }

    public static List<IType> resolveTypeArguments(IType parameterizedType, CompilationUnit compilationUnit, IType matchGenericType, ITypeHierarchy parameterizedTypeHierarchy, IProgressMonitor progressMonitor) throws CoreException {
        if (compilationUnit == null) {
            Logger.warn("Unable to retrieve the Compilation Unit for type '" + parameterizedType + "'. Check the library sources attachement.");
            return null;
        }
        List<Object> pathToParameterizedType = new ArrayList<IType>(Arrays.asList(parameterizedTypeHierarchy.getAllSubtypes(matchGenericType)));
        int index = pathToParameterizedType.indexOf(parameterizedType);
        if (index < 0) {
            return null;
        }
        pathToParameterizedType = pathToParameterizedType.subList(0, index);
        pathToParameterizedType.add(0, matchGenericType);
        Collections.reverse(pathToParameterizedType);
        ArrayList<IType> arguments = null;
        for (TypeDeclaration typeDeclaration : compilationUnit.types()) {
            int n;
            ITypeBinding typeBinding = typeDeclaration.resolveBinding();
            if (!typeBinding.getJavaElement().equals(parameterizedType)) continue;
            int i = 0;
            while (i < pathToParameterizedType.size()) {
                IType superType = (IType)pathToParameterizedType.get(i);
                if (superType.isInterface()) {
                    ITypeBinding[] iTypeBindingArray = typeBinding.getInterfaces();
                    int n2 = iTypeBindingArray.length;
                    n = 0;
                    while (n < n2) {
                        ITypeBinding superInterfaceBinding = iTypeBindingArray[n];
                        String superInterfaceErasureQName = superInterfaceBinding.getErasure().getQualifiedName();
                        if (superInterfaceErasureQName.equals(superType.getFullyQualifiedName())) {
                            typeBinding = superInterfaceBinding;
                            break;
                        }
                        ++n;
                    }
                } else {
                    typeBinding = typeBinding.getSuperclass();
                }
                ++i;
            }
            ITypeBinding[] typeArgBindings = typeBinding.getTypeArguments();
            arguments = new ArrayList<IType>(typeArgBindings.length);
            ITypeBinding[] iTypeBindingArray = typeArgBindings;
            n = typeArgBindings.length;
            int n3 = 0;
            while (n3 < n) {
                ITypeBinding typeArgBinding = iTypeBindingArray[n3];
                Logger.trace("Resolving Java ElementKind for type argument '" + typeArgBinding.getName() + "'", new Object[0]);
                IJavaElement javaElement = typeArgBinding.getJavaElement();
                if (javaElement.getElementType() == 7 && javaElement.exists()) {
                    arguments.add((IType)javaElement);
                }
                ++n3;
            }
        }
        return arguments;
    }

    public static Map<String, JavaMethodSignature> resolveMethodSignatures(IType type, CompilationUnit ast) throws JavaModelException {
        if (type == null || ast == null) {
            return Collections.emptyMap();
        }
        HashMap<String, JavaMethodSignature> signatures = new HashMap<String, JavaMethodSignature>();
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            JavaMethodSignature resolvedMethodSignature = JdtUtils.resolveMethodSignature(method, ast);
            if (resolvedMethodSignature != null) {
                signatures.put(method.getHandleIdentifier(), resolvedMethodSignature);
            }
            ++n2;
        }
        return signatures;
    }

    public static JavaMethodSignature resolveMethodSignature(IMethod method, CompilationUnit ast) throws JavaModelException {
        if (ast == null || !method.exists()) {
            return null;
        }
        ASTNode matchNode = NodeFinder.perform((ASTNode)ast, (ISourceRange)method.getNameRange());
        if (matchNode == null || matchNode.getParent() == null || matchNode.getParent().getNodeType() != 31) {
            return null;
        }
        MethodDeclaration methodDeclaration = (MethodDeclaration)matchNode.getParent();
        IMethodBinding methodBinding = methodDeclaration.resolveBinding();
        if (methodBinding == null) {
            return null;
        }
        SourceType returnedType = JdtUtils.getReturnType(methodBinding, methodDeclaration);
        ArrayList<IJavaMethodParameter> methodParameters = new ArrayList<IJavaMethodParameter>();
        List parameters = methodDeclaration.parameters();
        int i = 0;
        while (i < parameters.size()) {
            SingleVariableDeclaration parameter = (SingleVariableDeclaration)parameters.get(i);
            ILocalVariable localVariable = method.getParameters()[i];
            String paramName = parameter.getName().getFullyQualifiedName();
            SourceType paramType = SourceType.from((VariableDeclaration)parameter);
            IVariableBinding paramBinding = parameter.resolveBinding();
            List<Annotation> paramAnnotations = JdtUtils.resolveParameterAnnotations(localVariable, paramBinding);
            methodParameters.add(new JavaMethodParameter(paramName, paramType, paramAnnotations, method.getResource()));
            ++i;
        }
        return new JavaMethodSignature(method, returnedType, methodParameters);
    }

    public static SourceType resolveFieldType(IField javaField, CompilationUnit ast) {
        ASTNode matchNode;
        block4: {
            if (javaField == null || ast == null) {
                return null;
            }
            try {
                matchNode = NodeFinder.perform((ASTNode)ast, (ISourceRange)javaField.getNameRange());
                if (matchNode != null && matchNode.getParent() != null && matchNode.getParent().getParent() != null && matchNode.getParent().getParent().getNodeType() == 23) break block4;
                return null;
            }
            catch (JavaModelException e) {
                Logger.error("Failed to retrieve type for field " + javaField.getElementName(), e);
                return null;
            }
        }
        FieldDeclaration fieldDeclaration = (FieldDeclaration)matchNode.getParent().getParent();
        return SourceType.from(fieldDeclaration);
    }

    private static List<Annotation> resolveParameterAnnotations(ILocalVariable localVariable, IVariableBinding paramBinding) throws JavaModelException {
        ArrayList<Annotation> paramAnnotations = new ArrayList<Annotation>();
        IAnnotationBinding[] annotationBindings = paramBinding.getAnnotations();
        int j = 0;
        while (j < annotationBindings.length) {
            if (j < localVariable.getAnnotations().length) {
                IAnnotation javaAnnotation = localVariable.getAnnotations()[j];
                IAnnotationBinding javaAnnotationBinding = annotationBindings[j];
                paramAnnotations.add(JdtUtils.toAnnotation(javaAnnotationBinding, javaAnnotation));
            }
            ++j;
        }
        return paramAnnotations;
    }

    private static SourceType getReturnType(IMethodBinding methodBinding, MethodDeclaration methodDeclaration) {
        try {
            if (methodBinding.getReturnType() != null && methodBinding.getReturnType().getJavaElement() != null) {
                return SourceType.from(methodBinding.getReturnType(), methodDeclaration.getStartPosition(), methodDeclaration.getLength());
            }
        }
        catch (IllegalArgumentException e) {
            Logger.debug("Caught an IllegalArgumentException while trying to retrieve return type on method {}: {}", methodBinding, e.getMessage());
        }
        return null;
    }

    public static boolean isTypeOrSuperType(IType superType, IType subType) throws CoreException {
        if (subType == null || superType == null) {
            return false;
        }
        if (superType.getHandleIdentifier().equals(subType.getHandleIdentifier())) {
            return true;
        }
        ITypeHierarchy hierarchy = JdtUtils.resolveTypeHierarchy(subType, (IJavaElement)subType.getJavaProject(), true, (IProgressMonitor)new NullProgressMonitor());
        List<IType> allSupertypes = Arrays.asList(hierarchy.getAllSupertypes(subType));
        for (IType type : allSupertypes) {
            if (!type.getHandleIdentifier().equals(superType.getHandleIdentifier())) continue;
            return true;
        }
        return false;
    }

    public static String getReadableMethodSignature(IMethod method) {
        StringBuilder name = new StringBuilder();
        name.append(method.getElementName()).append("(");
        String comma = "";
        String[] parameterTypes = method.getParameterTypes();
        try {
            String[] parameterNames = method.getParameterNames();
            int i = 0;
            while (i < method.getParameterTypes().length) {
                name.append(comma);
                name.append(Signature.toString((String)parameterTypes[i]));
                name.append(" ");
                name.append(parameterNames[i]);
                comma = ", ";
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        name.append(")");
        return name.toString();
    }

    public static String toDisplayableTypeName(String typeName) {
        if (typeName == null) {
            return null;
        }
        if (typeName.startsWith(String.valueOf(List.class.getName()) + "<")) {
            String parameterType = typeName.substring(List.class.getName().length() + 1, typeName.length() - 1);
            return "List<" + JdtUtils.toDisplayableTypeName(parameterType) + ">";
        }
        if (typeName.startsWith(String.valueOf(Set.class.getName()) + "<")) {
            String parameterType = typeName.substring(Set.class.getName().length() + 1, typeName.length() - 1);
            return "Set<" + JdtUtils.toDisplayableTypeName(parameterType) + ">";
        }
        if (typeName.startsWith(String.valueOf(SortedSet.class.getName()) + "<")) {
            String parameterType = typeName.substring(SortedSet.class.getName().length() + 1, typeName.length() - 1);
            return "SortedSet<" + JdtUtils.toDisplayableTypeName(parameterType) + ">";
        }
        if (typeName.contains(".")) {
            return typeName.substring(typeName.lastIndexOf(".") + 1);
        }
        return typeName;
    }

    public static SourceType getPropertyType(IJavaMethodSignature methodSignature) throws IllegalArgumentException, JavaModelException {
        IMethod javaMethod;
        if (methodSignature != null && (javaMethod = methodSignature.getJavaMethod()) != null && javaMethod.getElementName().startsWith("set") && Signature.getParameterCount((String)javaMethod.getSignature()) == 1) {
            return methodSignature.getMethodParameters().get(0).getType();
        }
        return null;
    }

    public static boolean isSetter(IMethod javaMethod) throws JavaModelException {
        return javaMethod != null && javaMethod.getElementName().startsWith("set");
    }

    public static void makeConsistentIfNecessary(IMember javaMember) throws JavaModelException {
        if (javaMember != null && javaMember.getCompilationUnit() != null && javaMember.getCompilationUnit().exists() && !javaMember.getCompilationUnit().isConsistent()) {
            Logger.trace("Making {} consistent...", javaMember.getCompilationUnit().getElementName());
            javaMember.getCompilationUnit().makeConsistent((IProgressMonitor)new NullProgressMonitor());
        }
    }
}

