/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.jdt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;

public class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static Map<String, Annotation> extractTemplateParameters(Annotation pathAnnotation) {
        HashMap<String, Annotation> proposals = new HashMap<String, Annotation>();
        if (pathAnnotation != null && pathAnnotation.getFullyQualifiedName().equals("javax.ws.rs.Path") && pathAnnotation.getValue() != null) {
            String value = pathAnnotation.getValue();
            List<String> params = AnnotationUtils.extractParamsFromUriTemplateFragment(value);
            for (String param : params) {
                proposals.put(param, pathAnnotation);
            }
        }
        return proposals;
    }

    public static List<String> extractParamsFromUriTemplateFragment(String value) {
        ArrayList<String> params = new ArrayList<String>();
        int beginIndex = -1;
        while ((beginIndex = value.indexOf("{", beginIndex + 1)) != -1) {
            int endIndex;
            int semicolonIndex = value.indexOf(":", beginIndex);
            int closingCurlyBraketIndex = value.indexOf("}", beginIndex);
            int n = endIndex = semicolonIndex != -1 ? Math.min(semicolonIndex, closingCurlyBraketIndex) : closingCurlyBraketIndex;
            if (endIndex == -1) break;
            params.add(value.substring(beginIndex + 1, endIndex).trim());
        }
        return params;
    }

    public static boolean isValidAnnotationValue(String value) {
        if (value == null || value.isEmpty()) {
            return true;
        }
        int beginIndex = -1;
        int lastMatchIndex = -1;
        while ((beginIndex = value.indexOf("{", beginIndex + 1)) != -1) {
            int endIndex = value.indexOf("}", beginIndex);
            if (beginIndex != -1 && endIndex == -1) {
                return false;
            }
            lastMatchIndex = endIndex + 1;
        }
        return value.indexOf("}", lastMatchIndex) <= -1;
    }

    public static Map<String, Annotation> createWorkingCopies(Map<String, Annotation> originals) {
        HashMap<String, Annotation> workingCopies = new HashMap<String, Annotation>();
        for (Map.Entry<String, Annotation> entry : originals.entrySet()) {
            workingCopies.put(entry.getKey(), entry.getValue().createWorkingCopy());
        }
        return workingCopies;
    }
}

