/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementKind;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsApplication;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElement;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsJavaElement;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsMetamodel;

public class JaxrsShadowElementsCache {
    private Map<String, Set<EnumElementKind>> elements = new HashMap<String, Set<EnumElementKind>>();

    protected JaxrsShadowElementsCache() {
    }

    public void index(IJaxrsMetamodel metamodel) {
        List<IJaxrsElement> allElements = metamodel.getAllElements();
        for (IJaxrsElement element : allElements) {
            if (!this.isRelevantForIndexation(element)) continue;
            String key = element.getResource().getLocation().toPortableString();
            if (!this.elements.containsKey(key)) {
                this.elements.put(key, new HashSet());
            }
            this.elements.get(key).add(element.getElementKind());
        }
    }

    private boolean isRelevantForIndexation(IJaxrsElement element) {
        if (element == null || element.getResource() == null) {
            return false;
        }
        if (element instanceof IJaxrsApplication) {
            return true;
        }
        return element instanceof IJaxrsJavaElement && ((IJaxrsJavaElement)element).getJavaElement().getElementType() == 7;
    }

    public void index(IJaxrsElement element) {
        if (element == null || element.getResource() == null) {
            return;
        }
        String key = element.getResource().getLocation().toPortableString();
        if (!this.elements.containsKey(key)) {
            this.elements.put(key, new HashSet());
        }
        this.elements.get(key).add(element.getElementKind());
    }

    public Set<EnumElementKind> lookup(IResource resource) {
        if (resource == null) {
            return null;
        }
        return this.elements.get(resource.getLocation().toPortableString());
    }

    public void unindex(IResource resource) {
        if (resource == null) {
            return;
        }
        this.elements.remove(resource.getLocation().toPortableString());
    }
}

