/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JavaMethodSignature;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParamAnnotations;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParameterAggregator;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParameterAggregatorElement;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.AnnotationUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.Flags;
import org.jboss.tools.ws.jaxrs.core.jdt.FlagsUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.SourceType;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementKind;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElement;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsParameterAggregatorProperty;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsElementDelta;

public class JaxrsParameterAggregatorProperty
extends JaxrsParameterAggregatorElement<IMethod>
implements IJaxrsParameterAggregatorProperty {
    public static Builder from(IMethod javaMethod, CompilationUnit ast) {
        return new Builder(javaMethod, ast);
    }

    private JaxrsParameterAggregatorProperty(Builder builder) {
        this(builder.javaMethod, (Map<String, Annotation>)builder.annotations, builder.metamodel, builder.javaMethodParameterType, builder.parentParameterAggregator, (JaxrsParameterAggregatorProperty)null);
    }

    private JaxrsParameterAggregatorProperty(IMethod javaMethod, Map<String, Annotation> annotations, JaxrsMetamodel metamodel, SourceType javaMethodParameterType, JaxrsParameterAggregator parentParameterAggregator, JaxrsParameterAggregatorProperty primaryCopy) {
        super(javaMethod, annotations, metamodel, javaMethodParameterType, parentParameterAggregator, primaryCopy);
        if (this.getParentParameterAggregator() != null) {
            this.getParentParameterAggregator().addElement(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JaxrsParameterAggregatorProperty createWorkingCopy() {
        JaxrsParameterAggregatorProperty jaxrsParameterAggregatorProperty = this;
        synchronized (jaxrsParameterAggregatorProperty) {
            JaxrsParameterAggregator parentWorkingCopy = this.getParentParameterAggregator().getWorkingCopy();
            return parentWorkingCopy.getProperties().get(((IMethod)this.javaElement).getHandleIdentifier());
        }
    }

    protected JaxrsParameterAggregatorProperty createWorkingCopy(JaxrsParameterAggregator parentWorkingCopy) {
        return new JaxrsParameterAggregatorProperty((IMethod)this.getJavaElement(), AnnotationUtils.createWorkingCopies(this.getAnnotations()), this.getMetamodel(), this.getType(), parentWorkingCopy, this);
    }

    @Override
    public JaxrsParameterAggregatorProperty getWorkingCopy() {
        return (JaxrsParameterAggregatorProperty)super.getWorkingCopy();
    }

    @Override
    public void update(IJavaElement javaElement, CompilationUnit ast) throws CoreException {
        if (javaElement == null) {
            this.remove(FlagsUtils.computeElementFlags(this));
        } else {
            switch (javaElement.getElementType()) {
                case 5: {
                    IType primaryType = ((ICompilationUnit)javaElement).findPrimaryType();
                    if (primaryType == null) break;
                    IMethod method = primaryType.getMethod(((IMethod)this.getJavaElement()).getElementName(), ((IMethod)this.getJavaElement()).getParameterTypes());
                    this.update((IJavaElement)method, ast);
                    break;
                }
                case 9: {
                    this.update(JaxrsParameterAggregatorProperty.from((IMethod)javaElement, ast).buildTransient());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(JaxrsParameterAggregatorProperty transientProperty) throws CoreException {
        JaxrsParameterAggregatorProperty jaxrsParameterAggregatorProperty = this;
        synchronized (jaxrsParameterAggregatorProperty) {
            Flags annotationsFlags = FlagsUtils.computeElementFlags(this);
            if (transientProperty == null) {
                this.remove(annotationsFlags);
            } else {
                Flags updateAnnotationsFlags = this.updateAnnotations(transientProperty.getAnnotations());
                JaxrsElementDelta delta = new JaxrsElementDelta((IJaxrsElement)this, 4, updateAnnotationsFlags);
                if (this.isMarkedForRemoval()) {
                    this.remove(annotationsFlags);
                } else if (this.hasMetamodel()) {
                    this.getMetamodel().update(delta);
                }
            }
        }
    }

    @Override
    boolean isMarkedForRemoval() {
        boolean hasPathParamAnnotation = this.hasAnnotation("javax.ws.rs.PathParam");
        boolean hasQueryParamAnnotation = this.hasAnnotation("javax.ws.rs.QueryParam");
        boolean hasMatrixParamAnnotation = this.hasAnnotation("javax.ws.rs.MatrixParam");
        return !hasPathParamAnnotation && !hasQueryParamAnnotation && !hasMatrixParamAnnotation;
    }

    @Override
    public void remove(Flags flags) throws CoreException {
        this.getParentParameterAggregator().removeProperty(this);
        super.remove(flags);
    }

    public Annotation getPathParamAnnotation() {
        return this.getAnnotation("javax.ws.rs.PathParam");
    }

    public Annotation getQueryParamAnnotation() {
        return this.getAnnotation("javax.ws.rs.QueryParam");
    }

    public Annotation getMatrixParamAnnotation() {
        return this.getAnnotation("javax.ws.rs.MatrixParam");
    }

    public Annotation getDefaultValueAnnotation() {
        return this.getAnnotation("javax.ws.rs.DefaultValue");
    }

    @Override
    public EnumElementKind getElementKind() {
        return EnumElementKind.PARAMETER_AGGREGATOR_PROPERTY;
    }

    /* synthetic */ JaxrsParameterAggregatorProperty(Builder builder, JaxrsParameterAggregatorProperty jaxrsParameterAggregatorProperty) {
        this(builder);
    }

    public static class Builder {
        private final IMethod javaMethod;
        private final CompilationUnit ast;
        private Map<String, Annotation> annotations;
        private JaxrsParameterAggregator parentParameterAggregator;
        private JaxrsMetamodel metamodel;
        private SourceType javaMethodParameterType;

        private Builder(IMethod javaMethod, CompilationUnit ast) {
            this.javaMethod = javaMethod;
            this.ast = ast;
        }

        public JaxrsParameterAggregatorProperty buildTransient() throws CoreException {
            return this.buildInParentAggregator(null);
        }

        public Builder withAnnotations(Map<String, Annotation> annotations) {
            this.annotations = annotations;
            return this;
        }

        public JaxrsParameterAggregatorProperty buildInParentAggregator(JaxrsParameterAggregator parentParameterAggregator) throws CoreException {
            long start;
            block8: {
                block7: {
                    start = System.currentTimeMillis();
                    try {
                        if (this.javaMethod != null && this.javaMethod.exists() && this.javaMethod.isStructureKnown()) break block7;
                    }
                    catch (Throwable throwable) {
                        long end = System.currentTimeMillis();
                        Logger.tracePerf("Built JAX-RS Resource Method in {}ms", end - start);
                        throw throwable;
                    }
                    long end = System.currentTimeMillis();
                    Logger.tracePerf("Built JAX-RS Resource Method in {}ms", end - start);
                    return null;
                }
                JdtUtils.makeConsistentIfNecessary((IMember)this.javaMethod);
                this.parentParameterAggregator = parentParameterAggregator;
                if (this.parentParameterAggregator != null) {
                    this.metamodel = this.parentParameterAggregator.getMetamodel();
                }
                JavaMethodSignature methodSignature = JdtUtils.resolveMethodSignature(this.javaMethod, this.ast);
                this.javaMethodParameterType = JdtUtils.getPropertyType(methodSignature);
                IType parentType = (IType)this.javaMethod.getParent();
                if (parentParameterAggregator == null && this.metamodel != null) {
                    Logger.trace("Skipping {}.{} because parent Parameter Aggregator does not exist", parentType.getFullyQualifiedName(), this.javaMethod.getElementName());
                }
                if (this.annotations == null) {
                    this.annotations = JdtUtils.resolveAllAnnotations((IMember)this.javaMethod, this.ast);
                }
                if (!JaxrsParamAnnotations.matchesAtLeastOne(this.annotations.keySet())) break block8;
                JaxrsParameterAggregatorProperty field = new JaxrsParameterAggregatorProperty(this, null);
                if (this.metamodel != null) {
                    field.joinMetamodel();
                }
                JaxrsParameterAggregatorProperty jaxrsParameterAggregatorProperty = field;
                long end = System.currentTimeMillis();
                Logger.tracePerf("Built JAX-RS Resource Method in {}ms", end - start);
                return jaxrsParameterAggregatorProperty;
            }
            long end = System.currentTimeMillis();
            Logger.tracePerf("Built JAX-RS Resource Method in {}ms", end - start);
            return null;
        }
    }
}

