/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsBaseElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.utils.CollectionUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.Flags;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementKind;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElement;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsHttpMethod;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsJavaElement;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsNameBinding;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsElementDelta;

public abstract class JaxrsJavaElement<T extends IMember>
extends JaxrsBaseElement
implements IJaxrsJavaElement {
    protected final T javaElement;
    private final Map<String, Annotation> annotations = new HashMap<String, Annotation>();

    JaxrsJavaElement(T element, Map<String, Annotation> annotations, JaxrsMetamodel metamodel, JaxrsJavaElement<?> primaryCopy) {
        super(metamodel, primaryCopy);
        this.javaElement = element;
        if (annotations != null) {
            this.annotations.putAll(annotations);
        }
    }

    static Map<String, Annotation> singleToMap(Annotation annotation) {
        if (annotation != null) {
            return CollectionUtils.toMap(annotation.getFullyQualifiedName(), annotation);
        }
        return Collections.emptyMap();
    }

    @Override
    public boolean isBinary() {
        if (this.javaElement == null) {
            return true;
        }
        return this.javaElement.isBinary();
    }

    public boolean isBasedOnJavaType() {
        return this.javaElement != null && this.javaElement.getElementType() == 7;
    }

    @Override
    public Annotation getAnnotation(String className) {
        return this.annotations.get(className);
    }

    @Override
    public boolean hasAnnotation(String className) {
        return this.annotations.get(className) != null;
    }

    public final T getJavaElement() {
        return this.javaElement;
    }

    @Override
    public String getIdentifier() {
        return this.javaElement.getHandleIdentifier();
    }

    @Override
    public String getName() {
        return this.javaElement != null ? this.javaElement.getElementName() : "*unknown java element*";
    }

    @Override
    public Map<String, Annotation> getAnnotations() {
        return this.annotations;
    }

    public void addOrUpdateAnnotation(Annotation annotation) throws CoreException {
        if (annotation != null) {
            boolean changed = false;
            EnumElementKind previousKind = this.getElementKind();
            String annotationName = annotation.getFullyQualifiedName();
            if (this.annotations.containsKey(annotationName)) {
                changed = this.annotations.get(annotationName).update(annotation);
            } else {
                this.annotations.put(annotationName, annotation);
                changed = true;
            }
            if (changed) {
                Flags flags = this.qualifyChange(annotationName, previousKind);
                JaxrsElementDelta delta = new JaxrsElementDelta((IJaxrsElement)this, 4, flags);
                this.getMetamodel().update(delta);
            }
        }
    }

    public void addAnnotation(Annotation annotation) throws CoreException {
        Flags annotationAdditionFlags = this.internalAddAnnotation(annotation);
        JaxrsElementDelta delta = new JaxrsElementDelta((IJaxrsElement)this, 4, annotationAdditionFlags);
        if (this.hasMetamodel() && annotationAdditionFlags.hasValue()) {
            this.getMetamodel().update(delta);
        }
    }

    public Flags updateAnnotation(Annotation annotation) throws CoreException {
        Flags flags = this.internalUpdateAnnotation(annotation);
        if (flags.hasValue()) {
            JaxrsElementDelta delta = new JaxrsElementDelta((IJaxrsElement)this, 4, flags);
            this.getMetamodel().update(delta);
        }
        return flags;
    }

    private Flags internalAddAnnotation(Annotation annotation) {
        if (annotation == null) {
            return Flags.NONE;
        }
        EnumElementKind previousKind = this.getElementKind();
        String annotationName = annotation.getFullyQualifiedName();
        this.annotations.put(annotationName, annotation);
        Flags flags = this.qualifyChange(annotationName, previousKind);
        return flags;
    }

    private Flags internalUpdateAnnotation(Annotation annotation) {
        if (annotation == null || !this.hasAnnotation(annotation.getFullyQualifiedName())) {
            return Flags.NONE;
        }
        EnumElementKind previousKind = this.getElementKind();
        String annotationName = annotation.getFullyQualifiedName();
        if (this.annotations.get(annotationName).update(annotation)) {
            return this.qualifyChange(annotationName, previousKind);
        }
        return Flags.NONE;
    }

    Flags updateAnnotations(Map<String, Annotation> otherAnnotations) {
        Flags flags = new Flags();
        CollectionUtils.MapComparison<String, Annotation> annotationsComparison = CollectionUtils.compare(this.annotations, otherAnnotations);
        Map<String, Annotation> addedAnnotations = annotationsComparison.getAddedItems();
        Map<String, Annotation> removedAnnotations = annotationsComparison.getRemovedItems();
        Map<String, Annotation> changedAnnotations = annotationsComparison.getChangedItems();
        for (Map.Entry<String, Annotation> entry : addedAnnotations.entrySet()) {
            flags.addFlags(this.internalAddAnnotation(entry.getValue()));
        }
        for (Map.Entry<String, Annotation> entry : changedAnnotations.entrySet()) {
            flags.addFlags(this.internalUpdateAnnotation(entry.getValue()));
        }
        for (Map.Entry<String, Annotation> entry : removedAnnotations.entrySet()) {
            flags.addFlags(this.internalRemoveAnnotation(entry.getValue()));
        }
        return flags;
    }

    private Flags qualifyChange(String annotationName, EnumElementKind previousKind) {
        EnumElementKind currentKind = this.getElementKind();
        Flags flags = this.computeChangeAnnotationFlag(annotationName);
        if (currentKind != previousKind) {
            flags.addFlags(2);
        }
        return flags;
    }

    private Flags computeChangeAnnotationFlag(String annotationName) {
        if (annotationName.equals("javax.ws.rs.Path")) {
            return new Flags(8);
        }
        if (annotationName.equals("javax.ws.rs.ApplicationPath")) {
            return new Flags(16);
        }
        if (annotationName.equals("javax.ws.rs.HttpMethod")) {
            return new Flags(256);
        }
        if (annotationName.equals("javax.ws.rs.NameBinding")) {
            return new Flags(0x400000);
        }
        if (annotationName.equals("java.lang.annotation.Target")) {
            return new Flags(131072);
        }
        if (annotationName.equals("java.lang.annotation.Retention")) {
            return new Flags(262144);
        }
        if (annotationName.equals("javax.ws.rs.ext.Provider")) {
            return new Flags(524288);
        }
        if (annotationName.equals("javax.ws.rs.PathParam")) {
            return new Flags(512);
        }
        if (annotationName.equals("javax.ws.rs.QueryParam")) {
            return new Flags(1024);
        }
        if (annotationName.equals("javax.ws.rs.MatrixParam")) {
            return new Flags(2048);
        }
        if (annotationName.equals("javax.ws.rs.DefaultValue")) {
            return new Flags(4096);
        }
        if (annotationName.equals("javax.ws.rs.Encoded")) {
            return new Flags(0x100000);
        }
        if (annotationName.equals("javax.ws.rs.Consumes")) {
            return new Flags(8192);
        }
        if (annotationName.equals("javax.ws.rs.Produces")) {
            return new Flags(16384);
        }
        for (IJaxrsHttpMethod httpMethod : this.getMetamodel().findAllHttpMethods()) {
            if (!httpMethod.getJavaClassName().equals(annotationName)) continue;
            return new Flags(256);
        }
        for (IJaxrsNameBinding nameBinding : this.getMetamodel().findAllNameBindings()) {
            if (!nameBinding.getJavaClassName().equals(annotationName)) continue;
            return new Flags(0x400000);
        }
        return Flags.NONE;
    }

    public void removeAnnotation(IAnnotation annotation) throws CoreException {
        if (annotation != null) {
            Flags removalFlags = this.internalRemoveAnnotation(annotation);
            if (this.isMarkedForRemoval()) {
                this.remove(removalFlags);
            } else {
                JaxrsElementDelta delta = new JaxrsElementDelta((IJaxrsElement)this, 4, removalFlags);
                this.getMetamodel().update(delta);
            }
        }
    }

    private Flags internalRemoveAnnotation(IAnnotation javaAnnotation) {
        if (javaAnnotation != null) {
            for (Map.Entry<String, Annotation> entry : this.annotations.entrySet()) {
                Annotation annotation = entry.getValue();
                if (!annotation.getJavaAnnotation().getHandleIdentifier().equals(javaAnnotation.getHandleIdentifier())) continue;
                return this.internalRemoveAnnotation(annotation);
            }
        }
        return Flags.NONE;
    }

    private Flags internalRemoveAnnotation(Annotation annotation) {
        if (annotation != null) {
            EnumElementKind previousKind = this.getElementKind();
            this.annotations.remove(annotation.getFullyQualifiedName());
            return this.qualifyChange(annotation.getFullyQualifiedName(), previousKind);
        }
        return Flags.NONE;
    }

    @Override
    public IResource getResource() {
        return this.javaElement.getResource();
    }

    public Map<String, Annotation> getNameBindingAnnotations() {
        Collection<Annotation> annotations = this.getAnnotations().values();
        HashMap<String, Annotation> nameBindingAnnotations = new HashMap<String, Annotation>();
        for (Annotation annotation : annotations) {
            String annotationClassName = annotation.getFullyQualifiedName();
            if (this.getMetamodel().findNameBinding(annotationClassName) == null) continue;
            nameBindingAnnotations.put(annotation.getFullyQualifiedName(), annotation);
        }
        return nameBindingAnnotations;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.javaElement == null ? 0 : this.javaElement.getHandleIdentifier().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JaxrsJavaElement other = (JaxrsJavaElement)obj;
        return !(this.javaElement == null ? other.javaElement != null : !this.javaElement.getHandleIdentifier().equals(((IMember)other.javaElement).getHandleIdentifier()));
    }

    public abstract void update(IJavaElement var1, CompilationUnit var2) throws CoreException;

    public IJavaElement getJavaProject() {
        if (this.javaElement != null) {
            return this.javaElement.getJavaProject();
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.hasMetamodel()) {
            builder.append(this.getElementKind().toString());
        } else {
            builder.append("TRANSIENT");
        }
        builder.append(" ").append(this.getJavaElement().getElementName()).append(" ");
        if (this.getAnnotations().isEmpty()) {
            builder.append(" (no annotation)");
        } else {
            for (Map.Entry<String, Annotation> entry : this.getAnnotations().entrySet()) {
                Annotation annotation = entry.getValue();
                builder.append(" ").append(annotation);
            }
        }
        return builder.toString();
    }
}

