/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.jboss.tools.ws.jaxrs.core.internal.utils.CollectionUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.AnnotationUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.SourceType;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJavaMethodParameter;

public class JavaMethodParameter
implements IJavaMethodParameter {
    private final String name;
    private final SourceType type;
    private final Map<String, Annotation> annotations;
    private final IResource resource;

    public JavaMethodParameter(String name, SourceType type, List<Annotation> annotations, IResource resource) {
        this.name = name;
        this.type = type;
        this.resource = resource;
        this.annotations = new HashMap<String, Annotation>(annotations.size() * 2);
        for (Annotation annotation : annotations) {
            this.annotations.put(annotation.getFullyQualifiedName(), annotation);
        }
    }

    private JavaMethodParameter(String name, SourceType type, Map<String, Annotation> annotations, IResource resource) {
        this.name = name;
        this.type = type;
        this.resource = resource;
        this.annotations = annotations;
    }

    public JavaMethodParameter createWorkingCopy() {
        return new JavaMethodParameter(new String(this.name), this.type.createWorkingCopy(), AnnotationUtils.createWorkingCopies(this.getAnnotations()), this.resource);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SourceType getType() {
        return this.type;
    }

    @Override
    public Map<String, Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public Annotation getAnnotation(String fullyQualifiedName) {
        return this.annotations.get(fullyQualifiedName);
    }

    @Override
    public boolean hasAnnotation(String fullyQualifiedName) {
        return this.getAnnotation(fullyQualifiedName) != null;
    }

    public void removeAnnotation(Annotation annotation) {
        this.annotations.remove(annotation.getFullyQualifiedName());
    }

    public void removeAnnotation(String qualifiedName) {
        this.annotations.remove(qualifiedName);
    }

    public void addAnnotation(Annotation annotation) {
        this.annotations.put(annotation.getFullyQualifiedName(), annotation);
    }

    public boolean hasChanges(IJavaMethodParameter otherMethodParameter) {
        Map<String, Annotation> otherAnnotations = otherMethodParameter.getAnnotations();
        CollectionUtils.MapComparison<String, Annotation> comparison = CollectionUtils.compare(this.annotations, otherAnnotations);
        return comparison.hasDifferences();
    }

    @Override
    public IResource getResource() {
        return this.resource;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Annotation annotation : this.annotations.values()) {
            builder.append("@").append(annotation.getJavaAnnotation().getElementName());
            if (annotation.getValue() != null && !annotation.getValue().isEmpty()) {
                builder.append('(').append(annotation.getValue()).append(')');
            }
            builder.append(' ');
        }
        builder.append(this.getType().getDisplayableTypeName()).append(' ').append(this.getName());
        return builder.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.annotations == null ? 0 : this.annotations.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaMethodParameter other = (JavaMethodParameter)obj;
        if (this.annotations == null ? other.annotations != null : !this.annotations.equals(other.annotations)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

