/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder.JavaElementChangedEvent;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder.JavaElementDeltaFilter;
import org.jboss.tools.ws.jaxrs.core.internal.utils.ConstantUtils;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.jdt.Flags;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;

public class JavaElementDeltaScanner {
    private final JavaElementDeltaFilter javaElementChangedEventFilter = new JavaElementDeltaFilter();

    public List<JavaElementChangedEvent> scanAndFilterEvent(ElementChangedEvent event, IProgressMonitor progressMonitor) throws CoreException {
        try {
            progressMonitor.beginTask("Analysing changes", 1);
            Logger.debug("Some java elements changed on a {} event ", ConstantUtils.getStaticFieldName(ElementChangedEvent.class, event.getType()));
            List<JavaElementChangedEvent> list = this.scanDelta(event.getDelta(), event.getType());
            return list;
        }
        finally {
            progressMonitor.done();
        }
    }

    private List<JavaElementChangedEvent> scanDelta(IJavaElementDelta delta, int eventType) throws CoreException {
        JavaElementChangedEvent event;
        int n;
        JavaElementChangedEvent event2;
        IPackageFragmentRoot packageFragmentRoot;
        ArrayList<JavaElementChangedEvent> events = new ArrayList<JavaElementChangedEvent>();
        IJavaElement element = delta.getElement();
        if (element == null) {
            Logger.debug("** skipping this build because the delta element is null **");
            return Collections.emptyList();
        }
        if (element.getElementType() == 2 && !element.getJavaProject().getProject().isOpen() && delta.getFlags() != 512) {
            Logger.debug("** skipping this build because the java project is closed. **");
            return Collections.emptyList();
        }
        if (element.getElementType() == 3 ? !(packageFragmentRoot = (IPackageFragmentRoot)element).isExternal() && (packageFragmentRoot.getResource() == null || !packageFragmentRoot.getResource().exists()) : element.getResource() == null || !element.getResource().exists()) {
            return Collections.emptyList();
        }
        int elementKind = element.getElementType();
        int deltaKind = JavaElementDeltaScanner.retrieveDeltaKind(delta);
        Flags flags = new Flags(delta.getFlags());
        if (elementKind == 2 && this.javaElementChangedEventFilter.apply(event2 = new JavaElementChangedEvent(element, delta.getKind(), eventType, null, new Flags(delta.getFlags())))) {
            events.add(event2);
            return events;
        }
        CompilationUnit compilationUnitAST = this.getCompilationUnitAST(delta);
        if (elementKind == 5) {
            ICompilationUnit compilationUnit = (ICompilationUnit)element;
            if (compilationUnit.exists() && compilationUnit.isWorkingCopy() && compilationUnitAST != null && this.requiresDiffsComputation(flags)) {
                IType[] iTypeArray = compilationUnit.getAllTypes();
                int n2 = iTypeArray.length;
                n = 0;
                while (n < n2) {
                    IType type = iTypeArray[n];
                    IMethod[] iMethodArray = type.getMethods();
                    int n3 = iMethodArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IMethod javaMethod = iMethodArray[n4];
                        JavaElementChangedEvent event3 = new JavaElementChangedEvent((IJavaElement)javaMethod, 4, eventType, compilationUnitAST, new Flags(0x2000000));
                        if (this.javaElementChangedEventFilter.apply(event3)) {
                            events.add(event3);
                        }
                        ++n4;
                    }
                    ++n;
                }
            }
        } else if (compilationUnitAST != null && this.javaElementChangedEventFilter.apply(event = new JavaElementChangedEvent(element, deltaKind, eventType, compilationUnitAST, flags))) {
            events.add(event);
        }
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        n = iJavaElementDeltaArray.length;
        int n5 = 0;
        while (n5 < n) {
            IJavaElementDelta affectedChild = iJavaElementDeltaArray[n5];
            events.addAll(this.scanDelta(affectedChild, eventType));
            ++n5;
        }
        iJavaElementDeltaArray = delta.getAnnotationDeltas();
        n = iJavaElementDeltaArray.length;
        n5 = 0;
        while (n5 < n) {
            IJavaElementDelta annotation = iJavaElementDeltaArray[n5];
            events.addAll(this.scanDelta(annotation, eventType));
            ++n5;
        }
        return events;
    }

    private CompilationUnit getCompilationUnitAST(IJavaElementDelta delta) throws JavaModelException {
        CompilationUnit compilationUnitAST = null;
        IJavaElement element = delta.getElement();
        compilationUnitAST = delta.getCompilationUnitAST();
        if (compilationUnitAST == null) {
            compilationUnitAST = JdtUtils.parse(element, (IProgressMonitor)new NullProgressMonitor());
        }
        return compilationUnitAST;
    }

    private boolean requiresDiffsComputation(Flags flags) {
        return flags.hasExactValue(1, 16384) || flags.hasExactValue(1, 16384, 524288);
    }

    private static int retrieveDeltaKind(IJavaElementDelta delta) {
        IJavaElement element = delta.getElement();
        int elementType = element.getElementType();
        int flags = delta.getFlags();
        switch (elementType) {
            case 3: {
                switch (flags) {
                    case 64: {
                        return 1;
                    }
                    case 128: {
                        return 2;
                    }
                }
            }
        }
        return delta.getKind();
    }
}

