/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.java.JavaGenerator;
import org.eclipse.jpt.jpa.core.context.java.JavaGeneratorContainer;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaContextModel;
import org.eclipse.jpt.jpa.core.resource.java.GeneratorAnnotation;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaGenerator<P extends JavaGeneratorContainer, A extends GeneratorAnnotation>
extends AbstractJavaContextModel<P>
implements JavaGenerator {
    protected final A generatorAnnotation;
    protected String name;

    protected AbstractJavaGenerator(P parent, A generatorAnnotation) {
        super(parent);
        this.generatorAnnotation = generatorAnnotation;
        this.name = generatorAnnotation.getName();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setName_(this.generatorAnnotation.getName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.generatorAnnotation.setName(name);
        this.setName_(name);
    }

    protected void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    @Override
    public boolean supportsValidationMessages() {
        return MappingTools.modelIsInternalSource(this, this.getGeneratorAnnotation());
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (StringTools.isBlank((String)this.name)) {
            messages.add(this.buildValidationMessage(this.getNameTextRange(), JptJpaCoreValidationMessages.GENERATOR_NAME_UNDEFINED));
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.generatorAnnotation.getTextRange();
        return textRange != null ? textRange : ((JavaGeneratorContainer)this.parent).getValidationTextRange();
    }

    @Override
    public TextRange getNameTextRange() {
        return this.getValidationTextRange(this.generatorAnnotation.getNameTextRange());
    }

    @Override
    public boolean isEquivalentTo(Generator other) {
        return this != other && this.getGeneratorType() == other.getGeneratorType() && this.isEquivalentTo_(other);
    }

    protected boolean isEquivalentTo_(Generator other) {
        return ObjectTools.equals((Object)this.name, (Object)other.getName());
    }

    public A getGeneratorAnnotation() {
        return this.generatorAnnotation;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }
}

