/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms;

import java.util.Collections;
import java.util.Set;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.el.AndFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.localization.LabelTransformer;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.forms.PageBookPart;
import org.eclipse.sapphire.ui.forms.WithDef;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.sapphire.ui.forms.swt.internal.WithPresentation;
import org.eclipse.swt.widgets.Composite;

public final class WithPart
extends PageBookPart {
    private ModelPath path;
    private ElementHandle<?> property;
    private Element elementForChildParts;
    private Listener listener;
    private FunctionResult labelFunctionResult;

    @Override
    protected void init() {
        WithDef def = (WithDef)this.definition;
        this.path = new ModelPath(this.substituteParams(def.getPath().text()));
        this.property = (ElementHandle)this.getModelElement().property(this.path);
        if (this.property == null) {
            throw new IllegalStateException();
        }
        super.init();
        this.setExposePageValidationState(true);
        this.listener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                if (event instanceof PropertyContentEvent) {
                    WithPart.this.updateCurrentPage(false);
                } else if (event instanceof PropertyValidationEvent) {
                    WithPart.this.refreshValidation();
                }
            }
        };
        this.property.attach(this.listener);
        this.updateCurrentPage(true);
    }

    @Override
    protected Function initVisibleWhenFunction() {
        return AndFunction.create((Function[])new Function[]{super.initVisibleWhenFunction(), WithPart.createVersionCompatibleFunction(this.property)});
    }

    @Override
    public WithDef definition() {
        return (WithDef)super.definition();
    }

    public ModelPath getPath() {
        return this.path;
    }

    @Override
    public Element getLocalModelElement() {
        return this.property.element();
    }

    public ElementHandle<?> property() {
        return this.property;
    }

    public String label() {
        return this.label(CapitalizationType.NO_CAPS, true);
    }

    public String label(CapitalizationType capitalizationType, boolean includeMnemonic) {
        WithDef def = this.definition();
        if (((Boolean)def.getShowLabel().content()).booleanValue()) {
            if (this.labelFunctionResult == null) {
                this.labelFunctionResult = this.initExpression((Function)def.getLabel().content(), String.class, (Function)Literal.create((Object)this.property.definition().getLabel(false, CapitalizationType.NO_CAPS, true)), new Runnable(){

                    @Override
                    public void run() {
                        WithPart.this.broadcast(new SapphirePart.LabelChangedEvent(WithPart.this));
                    }
                });
            }
            String label = (String)this.labelFunctionResult.value();
            return LabelTransformer.transform((String)label, (CapitalizationType)capitalizationType, (boolean)includeMnemonic);
        }
        return null;
    }

    @Override
    protected Status computeValidation() {
        Status state = super.computeValidation();
        if (this.property != null) {
            Status.CompositeStatusFactory factory = Status.factoryForComposite();
            factory.merge(this.property.validation());
            factory.merge(state);
            state = factory.create();
        }
        return state;
    }

    private void updateCurrentPage(boolean force) {
        Element child = this.property.content();
        if (force || this.elementForChildParts != child) {
            this.elementForChildParts = child;
            this.changePage(this.elementForChildParts);
        }
    }

    @Override
    public boolean setFocus(ModelPath path) {
        if (this.path.isPrefixOf(path)) {
            ModelPath tail = path.makeRelativeTo(this.path);
            if (this.property == null || this.property.enabled()) {
                return super.setFocus(tail);
            }
        }
        return false;
    }

    @Override
    public Set<String> getActionContexts() {
        return Collections.singleton("Sapphire.WithDirective");
    }

    @Override
    public FormComponentPresentation createPresentation(SwtPresentation parent, Composite composite) {
        return new WithPresentation(this, parent, composite);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.listener != null) {
            this.property.detach(this.listener);
        }
    }

    public static enum Style {
        CHECKBOX("checkbox"),
        RADIO_BUTTONS("radio.buttons"),
        DROP_DOWN_LIST("drop.down.list");

        private final String text;

        public static Style decode(String text) {
            if (text != null) {
                Style[] styleArray = Style.values();
                int n = styleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Style style = styleArray[n2];
                    if (style.text.equals(text)) {
                        return style;
                    }
                    ++n2;
                }
            }
            return null;
        }

        private Style(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

