/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.PartValidationEvent;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.diagram.editor.ContainerShapePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.ShapeFactoryPart;
import org.eclipse.sapphire.ui.diagram.shape.def.LayoutConstraintDef;
import org.eclipse.sapphire.ui.diagram.shape.def.SelectionPresentation;
import org.eclipse.sapphire.ui.diagram.shape.def.ShapeDef;
import org.eclipse.sapphire.ui.forms.PropertiesViewContributionManager;
import org.eclipse.sapphire.ui.forms.PropertiesViewContributionPart;
import org.eclipse.sapphire.ui.forms.PropertiesViewContributorPart;

public class ShapePart
extends SapphirePart
implements PropertiesViewContributorPart {
    private ShapeDef shapeDef;
    private Element modelElement;
    private boolean isActive = false;
    private boolean isEditable = false;
    private PropertiesViewContributionManager propertiesViewContributionManager;
    private SelectionPresentation selectionPresentation = null;

    @Override
    protected void init() {
        super.init();
        this.shapeDef = (ShapeDef)this.definition;
        this.modelElement = this.getModelElement();
        if (this.getPropertiesViewContribution() != null) {
            this.getPropertiesViewContribution().attach((Listener)new FilteredListener<PartValidationEvent>(){

                protected void handleTypedEvent(PartValidationEvent event) {
                    ShapePart.this.refreshValidation();
                }
            });
        }
    }

    public LayoutConstraintDef getLayoutConstraint() {
        return this.shapeDef.getSequenceLayoutConstraint();
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean editable) {
        this.isEditable = editable;
    }

    @Override
    public Set<String> getActionContexts() {
        HashSet<String> contextSet = new HashSet<String>();
        contextSet.add("Sapphire.Diagram.Node.Shape");
        contextSet.add("Sapphire.Diagram.Node.Shape.Hidden");
        return contextSet;
    }

    @Override
    public Element getLocalModelElement() {
        return this.modelElement;
    }

    public List<ShapePart> getActiveChildren() {
        return Collections.emptyList();
    }

    public List<ShapePart> getChildren() {
        return Collections.emptyList();
    }

    public static <T extends ShapePart> List<T> getContainedShapeParts(ShapePart shapePart, Class<T> shapeType) {
        ArrayList<ShapePart> containedShapeParts = new ArrayList<ShapePart>();
        for (ShapePart childPart : shapePart.getChildren()) {
            if (shapeType.isAssignableFrom(childPart.getClass())) {
                containedShapeParts.add(childPart);
                continue;
            }
            if (!(childPart instanceof ContainerShapePart) && !(childPart instanceof ShapeFactoryPart)) continue;
            containedShapeParts.addAll(ShapePart.getContainedShapeParts(childPart, shapeType));
        }
        return containedShapeParts;
    }

    public DiagramNodePart getNodePart() {
        DiagramNodePart nodePart = null;
        ISapphirePart part = this;
        while (part != null) {
            if (part instanceof DiagramNodePart) {
                nodePart = (DiagramNodePart)part;
                break;
            }
            part = part.parent();
        }
        return nodePart;
    }

    @Override
    public PropertiesViewContributionPart getPropertiesViewContribution() {
        if (this.propertiesViewContributionManager == null) {
            this.propertiesViewContributionManager = new PropertiesViewContributionManager(this, this.getLocalModelElement());
        }
        return this.propertiesViewContributionManager.getPropertiesViewContribution();
    }

    public void setSelectionPresentation(SelectionPresentation selectionPresentation) {
        this.selectionPresentation = selectionPresentation;
    }

    public SelectionPresentation getSelectionPresentation() {
        return this.selectionPresentation;
    }

    @Override
    protected Status computeValidation() {
        Status.CompositeStatusFactory factory = Status.factoryForComposite();
        factory.merge(super.computeValidation());
        PropertiesViewContributionPart propertiesPage = this.getPropertiesViewContribution();
        if (propertiesPage != null) {
            factory.merge(propertiesPage.validation());
        }
        return factory.create();
    }
}

