/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.js.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.jboss.tools.jst.js.internal.Activator;

public final class WorkbenchResourceUtil {
    private WorkbenchResourceUtil() {
    }

    public static void openInEditor(IFile file, String editorID) throws PartInitException {
        IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        if (editorID == null || editorRegistry.findEditor(editorID) == null) {
            editorID = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getFullPath().toString()).getId();
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        page.openEditor((IEditorInput)new FileEditorInput(file), editorID, true, 2);
    }

    public static void createFile(IFile file, String content) throws CoreException {
        if (!file.exists()) {
            ByteArrayInputStream source = new ByteArrayInputStream(content.getBytes());
            try {
                file.create((InputStream)source, 0, null);
            }
            catch (CoreException e) {
                Activator.logError(e);
            }
        }
    }

    public static void updateFile(IFile file, String content) throws CoreException {
        if (file.exists()) {
            ByteArrayInputStream source = new ByteArrayInputStream(content.getBytes());
            file.setContents((InputStream)source, true, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static IProject getSelectedProject() {
        StructuredSelection structuredSelection;
        Object firstElement;
        IResource resource;
        ISelection selection;
        IWorkbenchPage activePage;
        IWorkbenchWindow workbenchWindow = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow != null && (activePage = workbenchWindow.getActivePage()) != null && (selection = activePage.getSelection()) instanceof StructuredSelection && (resource = ResourceUtil.getResource((Object)(firstElement = (structuredSelection = (StructuredSelection)selection).getFirstElement()))) != null) {
            return resource.getProject();
        }
        return null;
    }

    public static IProject getProject(String projectString) {
        if (projectString != null) {
            try {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectString);
                if (project != null && project.exists()) {
                    return project;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return null;
    }

    public static IContainer getContainerFromSelection(IStructuredSelection selection) {
        IContainer container = null;
        if (selection != null && !selection.isEmpty()) {
            Object selectedObject = selection.getFirstElement();
            if (selectedObject instanceof IContainer) {
                container = (IContainer)selectedObject;
            } else if (selectedObject instanceof IFile) {
                container = ((IFile)selectedObject).getParent();
            }
        }
        return container;
    }

    public static String getAbsolutePath(IResource resource) {
        IPath path = null;
        String absoluteLocation = null;
        if (resource != null) {
            path = resource.getRawLocation();
            IPath iPath = path = path != null ? path : resource.getLocation();
            if (path != null) {
                absoluteLocation = path.toOSString();
            }
        }
        return absoluteLocation;
    }
}

