/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.js.bower.internal.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.jboss.tools.jst.js.bower.BowerJson;

public final class BowerUtil {
    private BowerUtil() {
    }

    public static boolean isBowerJsonExist(IProject project) throws CoreException {
        final ArrayList foundFiles = new ArrayList();
        if (project != null) {
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource.getType() == 1 && "bower.json".equals(resource.getName())) {
                        foundFiles.add((IFile)resource);
                        return false;
                    }
                    return true;
                }
            });
        }
        return !foundFiles.isEmpty();
    }

    public static boolean hasBowerJson(IFolder folder) throws CoreException {
        IResource bowerJson = folder.findMember("bower.json");
        return bowerJson != null && bowerJson.exists();
    }

    public static boolean isBowerJson(IResource resource) {
        return resource != null && "bower.json".equals(resource.getName()) && resource.exists();
    }

    public static String generateJson(BowerJson bowerJson) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        return gson.toJson((Object)bowerJson);
    }
}

