/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.js.bower.internal.launch.shortcut;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.jboss.tools.jst.js.bower.internal.ui.ExceptionNotifier;
import org.jboss.tools.jst.js.bower.internal.util.ExternalToolUtil;
import org.jboss.tools.jst.js.internal.Activator;

public abstract class GenericNativeBowerLaunch
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        Object element;
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) != null && element instanceof IResource) {
            try {
                String nodeLocation = ExternalToolUtil.getNodeExecutableLocation();
                String bowerLocation = ExternalToolUtil.getBowerExecutableLocation();
                if (nodeLocation == null || nodeLocation.isEmpty()) {
                    ExceptionNotifier.nodeLocationNotDefined();
                } else if (bowerLocation == null || bowerLocation.isEmpty()) {
                    ExceptionNotifier.bowerLocationNotDefined();
                } else {
                    this.execute(this.getWorkingDirectory((IResource)element), nodeLocation, bowerLocation);
                }
            }
            catch (CoreException e) {
                Activator.logError(e);
            }
        }
    }

    public void launch(IEditorPart editor, String mode) {
    }

    protected void execute(String workingDirectory, String nodeExecutableLocation, String bowerExecutableLocation) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType programType = manager.getLaunchConfigurationType("org.eclipse.ui.externaltools.ProgramLaunchConfigurationType");
        try {
            ILaunchConfigurationWorkingCopy cfg = programType.newInstance(null, this.getLaunchName());
            ILaunchConfigurationWorkingCopy wc = cfg.getWorkingCopy();
            wc.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", nodeExecutableLocation);
            wc.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", "${workspace_loc:" + workingDirectory + "}");
            wc.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", String.valueOf(bowerExecutableLocation) + " " + this.getCommandName());
            cfg = wc.doSave();
            cfg.launch("run", null, false, true);
            cfg.delete();
        }
        catch (CoreException e) {
            Activator.logError(e);
            ExceptionNotifier.launchError((Exception)((Object)e));
        }
    }

    protected abstract String getWorkingDirectory(IResource var1) throws CoreException;

    protected abstract String getCommandName();

    protected abstract String getLaunchName();
}

