/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.xpl;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.debug.ui.IJavaDebugUIConstants;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.DebugTypeSelectionDialog;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.debug.ui.launcher.MainMethodSearchEngine;
import org.eclipse.jdt.internal.debug.ui.launcher.SharedJavaMainTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class JavaMainTabClone
extends SharedJavaMainTab {
    public static final String ATTR_INCLUDE_EXTERNAL_JARS = String.valueOf(IJavaDebugUIConstants.PLUGIN_ID) + ".INCLUDE_EXTERNAL_JARS";
    public static final String ATTR_CONSIDER_INHERITED_MAIN = String.valueOf(IJavaDebugUIConstants.PLUGIN_ID) + ".CONSIDER_INHERITED_MAIN";
    private Button fSearchExternalJarsCheckButton;
    private Button fConsiderInheritedMainButton;
    private Button fStopInMainCheckButton;
    private ILaunchConfiguration fLaunchConfig;

    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)1808);
        ((GridLayout)comp.getLayout()).verticalSpacing = 0;
        this.createProjectEditor(comp);
        this.createVerticalSpacer(comp, 1);
        this.createMainTypeEditor(comp, LauncherMessages.JavaMainTab_Main_cla_ss__4);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IJavaDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_MAIN_TAB);
    }

    protected void createMainTypeExtensions(Composite parent) {
        this.fSearchExternalJarsCheckButton = SWTFactory.createCheckButton((Composite)parent, (String)LauncherMessages.JavaMainTab_E_xt__jars_6, null, (boolean)false, (int)2);
        this.fSearchExternalJarsCheckButton.addSelectionListener((SelectionListener)this.getDefaultListener());
        this.fConsiderInheritedMainButton = SWTFactory.createCheckButton((Composite)parent, (String)LauncherMessages.JavaMainTab_22, null, (boolean)false, (int)2);
        this.fConsiderInheritedMainButton.addSelectionListener((SelectionListener)this.getDefaultListener());
        this.fStopInMainCheckButton = SWTFactory.createCheckButton((Composite)parent, (String)LauncherMessages.JavaMainTab_St_op_in_main_1, null, (boolean)false, (int)1);
        this.fStopInMainCheckButton.addSelectionListener((SelectionListener)this.getDefaultListener());
    }

    public Image getImage() {
        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.class_obj.gif");
    }

    public String getName() {
        return LauncherMessages.JavaMainTab__Main_19;
    }

    public String getId() {
        return "org.eclipse.jdt.debug.ui.javaMainTab";
    }

    protected void handleSearchButtonSelected() {
        IJavaProject project = this.getJavaProject();
        IJavaElement[] elements = null;
        if (project == null || !project.exists()) {
            IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            if (model != null) {
                try {
                    elements = model.getJavaProjects();
                }
                catch (JavaModelException e) {
                    JDIDebugUIPlugin.log((Throwable)e);
                }
            }
        } else {
            elements = new IJavaElement[]{project};
        }
        if (elements == null) {
            elements = new IJavaElement[]{};
        }
        int constraints = 1;
        constraints |= 2;
        if (this.fSearchExternalJarsCheckButton.getSelection()) {
            constraints |= 4;
        }
        IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])elements, (int)constraints);
        MainMethodSearchEngine engine = new MainMethodSearchEngine();
        IType[] types = null;
        try {
            types = engine.searchMainMethods((IRunnableContext)this.getLaunchConfigurationDialog(), searchScope, this.fConsiderInheritedMainButton.getSelection());
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(e.getMessage());
            return;
        }
        catch (InterruptedException e) {
            this.setErrorMessage(e.getMessage());
            return;
        }
        DebugTypeSelectionDialog mmsd = new DebugTypeSelectionDialog(this.getShell(), types, LauncherMessages.JavaMainTab_Choose_Main_Type_11);
        if (mmsd.open() == 1) {
            return;
        }
        Object[] results = mmsd.getResult();
        IType type = (IType)results[0];
        if (type != null) {
            this.fMainText.setText(type.getFullyQualifiedName());
            this.fProjText.setText(type.getJavaProject().getElementName());
        }
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.setCurrentLaunchConfiguration(config);
        this.updateMainTypeFromConfig(config);
        this.updateStopInMainFromConfig(config);
        this.updateInheritedMainsFromConfig(config);
        this.updateExternalJars(config);
    }

    protected ILaunchConfiguration getCurrentLaunchConfiguration() {
        return this.fLaunchConfig;
    }

    protected void setCurrentLaunchConfiguration(ILaunchConfiguration config) {
        this.fLaunchConfig = config;
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String name = this.fProjText.getText().trim();
        if (name.length() > 0) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus status = workspace.validateName(name, 4);
            if (status.isOK()) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                if (!project.exists()) {
                    this.setErrorMessage(MessageFormat.format(LauncherMessages.JavaMainTab_20, name));
                    return false;
                }
                if (!project.isOpen()) {
                    this.setErrorMessage(MessageFormat.format(LauncherMessages.JavaMainTab_21, name));
                    return false;
                }
            } else {
                this.setErrorMessage(MessageFormat.format(LauncherMessages.JavaMainTab_19, status.getMessage()));
                return false;
            }
        }
        if ((name = this.fMainText.getText().trim()).length() == 0) {
            this.setErrorMessage(LauncherMessages.JavaMainTab_Main_type_not_specified_16);
            return false;
        }
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.fMainText.getText().trim());
        this.mapResources(config);
        if (this.fStopInMainCheckButton.getSelection()) {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN, true);
        } else {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN, null);
        }
        if (this.fSearchExternalJarsCheckButton.getSelection()) {
            config.setAttribute(ATTR_INCLUDE_EXTERNAL_JARS, true);
        } else {
            config.setAttribute(ATTR_INCLUDE_EXTERNAL_JARS, null);
        }
        if (this.fConsiderInheritedMainButton.getSelection()) {
            config.setAttribute(ATTR_CONSIDER_INHERITED_MAIN, true);
        } else {
            config.setAttribute(ATTR_CONSIDER_INHERITED_MAIN, null);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        IJavaElement javaElement = this.getContext();
        if (javaElement != null) {
            this.initializeJavaProject(javaElement, config);
        } else {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        }
        this.initializeMainTypeAndName(javaElement, config);
    }

    protected void updateExternalJars(ILaunchConfiguration config) {
        boolean search = false;
        try {
            search = config.getAttribute(ATTR_INCLUDE_EXTERNAL_JARS, false);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log((Throwable)e);
        }
        this.fSearchExternalJarsCheckButton.setSelection(search);
    }

    protected void updateInheritedMainsFromConfig(ILaunchConfiguration config) {
        boolean inherit = false;
        try {
            inherit = config.getAttribute(ATTR_CONSIDER_INHERITED_MAIN, false);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log((Throwable)e);
        }
        this.fConsiderInheritedMainButton.setSelection(inherit);
    }

    protected void updateStopInMainFromConfig(ILaunchConfiguration config) {
        boolean stop = false;
        try {
            stop = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN, false);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log((Throwable)e);
        }
        this.fStopInMainCheckButton.setSelection(stop);
    }
}

