/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.wizards;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBossExtendedProperties;
import org.jboss.ide.eclipse.as.core.server.internal.v7.LocalJBoss7ServerRuntime;
import org.jboss.ide.eclipse.as.core.util.JavaUtils;
import org.jboss.ide.eclipse.as.core.util.ServerUtil;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.UIUtil;
import org.jboss.ide.eclipse.as.ui.wizards.JBossRuntimeWizardFragment;

public class JBoss7RuntimeWizardFragment
extends JBossRuntimeWizardFragment {
    private Label baseDirLabel;
    private Text baseDirText;
    private Button baseDirBrowse;
    private String baseDirTextVal;

    @Override
    protected void createConfigurationComposite(Composite main) {
        UIUtil u = new UIUtil();
        this.configComposite = new Composite(main, 0);
        this.configComposite.setLayoutData((Object)u.createFormData(this.jreComposite, 10, 100, -5, 0, 5, 100, -5));
        this.configComposite.setLayout((Layout)new FormLayout());
        this.configDirLabel = new Label(this.configComposite, 0);
        this.configDirLabel.setText("Configuration file: ");
        this.configDirText = new Text(this.configComposite, 2048);
        this.configBrowse = new Button(this.configComposite, 0);
        this.configBrowse.setText(Messages.browse);
        this.baseDirLabel = new Label(this.configComposite, 0);
        this.baseDirLabel.setText("Server base directory: ");
        this.baseDirText = new Text(this.configComposite, 2048);
        this.baseDirBrowse = new Button(this.configComposite, 0);
        this.baseDirBrowse.setText(Messages.browse);
        this.baseDirLabel.setLayoutData((Object)u.createFormData(0, 7, null, 0, 0, 5, null, 0));
        this.baseDirText.setLayoutData((Object)u.createFormData(0, 5, null, 0, this.baseDirLabel, 5, this.baseDirBrowse, -5));
        this.baseDirBrowse.setLayoutData((Object)u.createFormData(0, 5, null, 0, null, 0, 100, -5));
        this.configDirLabel.setLayoutData((Object)u.createFormData(this.baseDirText, 7, null, 0, 0, 5, null, 0));
        this.configDirText.setLayoutData((Object)u.createFormData(this.baseDirText, 5, null, 0, this.configDirLabel, 5, this.configBrowse, -5));
        this.configBrowse.setLayoutData((Object)u.createFormData(this.baseDirText, 5, null, 0, null, 0, 100, -5));
        this.configDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JBoss7RuntimeWizardFragment.this.configDirTextVal = JBoss7RuntimeWizardFragment.this.configDirText.getText();
                JBoss7RuntimeWizardFragment.this.updatePage();
            }
        });
        this.baseDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JBoss7RuntimeWizardFragment.this.baseDirTextVal = JBoss7RuntimeWizardFragment.this.baseDirText.getText();
                JBoss7RuntimeWizardFragment.this.updatePage();
            }
        });
        this.configBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JBoss7RuntimeWizardFragment.this.configBrowsePressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.baseDirBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JBoss7RuntimeWizardFragment.this.baseDirBrowsePressed();
                JBoss7RuntimeWizardFragment.this.updatePage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void updateModels() {
        super.updateModels();
        IJBossServerRuntime rt = this.getRuntime();
        if (rt.getRuntime().getLocation() != null) {
            LocalJBoss7ServerRuntime jb7rt = (LocalJBoss7ServerRuntime)rt;
            String bd = jb7rt.getBaseDirectory();
            IPath relative = ServerUtil.makeRelative((IRuntime)rt.getRuntime(), (IPath)new Path(bd));
            this.baseDirTextVal = relative.toString();
        }
    }

    private File getConfigBrowseInitialFolder() {
        String homeDir = this.homeDirComposite.getHomeDirectory();
        Object f1 = null;
        f1 = new Path(this.configDirTextVal).isAbsolute() ? new Path(this.configDirTextVal) : new Path(this.getAbsoluteBaseDir(this.baseDirTextVal, homeDir)).append("configuration").append(this.configDirTextVal);
        String folder = f1.removeLastSegments(1).toString();
        File file = new File(folder);
        if (!file.exists()) {
            file = null;
        }
        return file;
    }

    @Override
    protected void configBrowsePressed() {
        String homeDir = this.homeDirComposite.getHomeDirectory();
        File file = this.getConfigBrowseInitialFolder();
        File ffile = JBoss7RuntimeWizardFragment.getFile(file, this.homeDirComposite.getShell());
        if (ffile != null) {
            IPath chosenConfigFolder = new Path(this.getAbsoluteBaseDir(this.baseDirTextVal, homeDir)).append("configuration");
            if (ffile.getAbsolutePath().startsWith(chosenConfigFolder.toFile().getAbsolutePath())) {
                String result = ffile.getAbsolutePath().substring(chosenConfigFolder.toString().length());
                this.configDirTextVal = new Path(result).makeRelative().toString();
            } else {
                String relativeToConfig;
                Path ffilePath = new Path(ffile.getAbsolutePath());
                this.configDirTextVal = relativeToConfig = this.makeRelativeToConfigFolder(chosenConfigFolder, (IPath)ffilePath);
            }
            this.configDirText.setText(this.configDirTextVal);
        }
    }

    protected void baseDirBrowsePressed() {
        String homeDir = this.homeDirComposite.getHomeDirectory();
        File file = null;
        file = new Path(this.baseDirTextVal).isAbsolute() ? new Path(this.baseDirTextVal).toFile() : new Path(homeDir).append(this.baseDirTextVal).toFile();
        File ffile = JBoss7RuntimeWizardFragment.getDirectory((File)file, (Shell)this.homeDirComposite.getShell());
        if (ffile != null) {
            Path ffilePath = new Path(ffile.getAbsolutePath());
            if (new Path(homeDir).isPrefixOf((IPath)ffilePath)) {
                String relative = ffile.getAbsolutePath().substring(homeDir.toString().length());
                this.baseDirTextVal = new Path(relative).makeRelative().toString();
            } else {
                this.baseDirTextVal = ffile.getAbsolutePath();
            }
            this.baseDirText.setText(this.baseDirTextVal);
        }
    }

    private String makeRelativeToConfigFolder(IPath baseFolder, IPath ffilePath) {
        StringBuffer sb = new StringBuffer();
        boolean done = false;
        while (!done) {
            if (!baseFolder.isPrefixOf(ffilePath)) {
                sb.append("../");
                baseFolder = baseFolder.removeLastSegments(1);
                continue;
            }
            done = true;
        }
        sb.append(ffilePath.removeFirstSegments(baseFolder.segmentCount()).toString());
        return sb.toString();
    }

    protected static File getFile(File startingDirectory, Shell shell) {
        String dir;
        FileDialog fileDialog = new FileDialog(shell, 4096);
        if (startingDirectory != null) {
            fileDialog.setFilterPath(startingDirectory.getPath());
        }
        if ((dir = fileDialog.open()) != null && (dir = dir.trim()).length() > 0) {
            return new File(dir);
        }
        return null;
    }

    @Override
    protected void fillConfigWidgets(IRuntime rt) {
        LocalJBoss7ServerRuntime rt2 = (LocalJBoss7ServerRuntime)rt.loadAdapter(LocalJBoss7ServerRuntime.class, null);
        this.baseDirTextVal = this.getPresentableBaseDir(rt);
        this.baseDirText.setText(this.baseDirTextVal);
        this.configDirTextVal = rt2.getConfigurationFile();
        this.configDirText.setText(this.configDirTextVal);
    }

    private String getPresentableBaseDir(IRuntime rt) {
        IPath rtLocWithSep;
        LocalJBoss7ServerRuntime rt2 = (LocalJBoss7ServerRuntime)rt.loadAdapter(LocalJBoss7ServerRuntime.class, null);
        String baseDir = rt2.getBaseDirectory();
        Path baseDirPath = new Path(baseDir);
        if (baseDirPath.isAbsolute() && (rtLocWithSep = rt.getLocation().addTrailingSeparator()).isPrefixOf((IPath)new Path(baseDir))) {
            return baseDir.substring(rtLocWithSep.toOSString().length());
        }
        return baseDir;
    }

    private String getAbsoluteBaseDir(String path, String homeDir) {
        if (new Path(path).isAbsolute()) {
            return path;
        }
        return new Path(homeDir).append(path).toString();
    }

    protected void updatePage() {
        this.configDirTextVal = this.configDirText.getText();
        this.saveDetailsInRuntime();
        this.updateErrorMessage();
    }

    @Override
    protected String getErrorString() {
        if (this.nameText == null) {
            return null;
        }
        if (this.getRuntime(this.name) != null) {
            return Messages.rwf_NameInUse;
        }
        if (this.name == null || this.name.equals("")) {
            return Messages.rwf_nameTextBlank;
        }
        if (this.jreComposite != null) {
            IExecutionEnvironment selectedEnv = this.jreComposite.getSelectedExecutionEnvironment();
            IVMInstall install = this.jreComposite.getSelectedVM();
            if (install == null && selectedEnv != null && selectedEnv.getCompatibleVMs().length == 0) {
                return NLS.bind((String)Messages.rwf_noValidJRE, (Object)selectedEnv.getId());
            }
        }
        if (this.jreComposite != null && this.jreComposite.getValidJREs().size() == 0) {
            return NLS.bind((String)Messages.rwf_noValidJRE, (Object)this.getRuntime().getExecutionEnvironment().getId());
        }
        if (!this.homeDirectoryIsDirectory()) {
            return Messages.rwf_homeIsNotDirectory;
        }
        if (!this.jbossModulesJarExists()) {
            return NLS.bind((String)Messages.rwf_homeMissingFiles2, (Object)this.getJBossModulesJar());
        }
        if (this.configDirTextVal != null) {
            IPath actualPath;
            String homeDir = this.homeDirComposite.getHomeDirectory();
            Path p = new Path(this.configDirTextVal);
            if (p.isAbsolute()) {
                return Messages.bind((String)Messages.rwf7_ConfigFileAbsoluteError, (Object)p.toString());
            }
            IPath iPath = actualPath = this.baseDirTextVal == null ? null : new Path(this.getAbsoluteBaseDir(this.baseDirTextVal, homeDir)).append("configuration").append((IPath)p);
            if (actualPath == null || !actualPath.toFile().exists()) {
                return Messages.bind((String)Messages.rwf7_ConfigFileError, (Object)(actualPath == null ? null : actualPath.toString()));
            }
        }
        return null;
    }

    public String getWarningString() {
        JBossExtendedProperties props = (JBossExtendedProperties)this.getRuntime().getRuntime().getAdapter(JBossExtendedProperties.class);
        if (props != null && props.requiresJDK()) {
            IVMInstall selected = this.jreComposite.getSelectedVM();
            if (selected == null) {
                boolean isjdk = JavaUtils.isJDK((IVMInstall)this.getRuntime().getVM());
                if (!isjdk) {
                    return Messages.rwf_jdkWarning;
                }
            } else if (!JavaUtils.isJDK((IVMInstall)selected)) {
                return Messages.rwf_requiresJDK;
            }
        }
        return super.getWarningString();
    }

    protected boolean homeDirectoryIsDirectory() {
        String homeDir = this.homeDirComposite.getHomeDirectory();
        if (homeDir == null || homeDir.length() == 0) {
            return false;
        }
        File home = new File(homeDir);
        return home.exists() && home.isDirectory();
    }

    protected boolean jbossModulesJarExists() {
        return this.getJBossModulesJar().toFile().exists();
    }

    protected IPath getJBossModulesJar() {
        String homeDir = this.homeDirComposite.getHomeDirectory();
        return new Path(homeDir).append("jboss-modules.jar");
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        this.exit();
        String homeDir = this.homeDirComposite.getHomeDirectory();
        IRuntime rt = this.getRuntimeFromTaskModel();
        ((IRuntimeWorkingCopy)rt).setLocation((IPath)new Path(homeDir));
        this.saveRuntimeLocationInPreferences(rt);
    }

    @Override
    protected void saveConfigurationDetailsInRuntime(IRuntimeWorkingCopy wc) {
        LocalJBoss7ServerRuntime srt = (LocalJBoss7ServerRuntime)wc.loadAdapter(LocalJBoss7ServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
        if (this.configDirTextVal != null && !"".equals(this.configDirTextVal)) {
            srt.setConfigurationFile(this.configDirTextVal);
        }
        if (this.baseDirTextVal != null && !"".equals(this.baseDirTextVal)) {
            srt.setBaseDirectory(this.baseDirTextVal);
        }
    }
}

