/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.views;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.internal.views.log.SharedImages;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.extensions.events.ServerLogger;
import org.jboss.ide.eclipse.as.core.server.IServerLogListener;
import org.jboss.ide.eclipse.as.ui.JBossServerUIPlugin;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.views.AbstractEntry;
import org.jboss.ide.eclipse.as.ui.views.EventDetailsDialog;
import org.jboss.ide.eclipse.as.ui.views.LogEntry;
import org.jboss.ide.eclipse.as.ui.views.LogLabelProvider;
import org.jboss.ide.eclipse.as.ui.views.LogReader;
import org.jboss.ide.eclipse.as.ui.views.LogSession;

public class ServerLogView
extends ViewPart
implements IServerLogListener,
ISelectionListener {
    public static final String VIEW_ID = "org.jboss.ide.eclipse.as.ui.view.serverLogView";
    public static final byte MESSAGE = 0;
    public static final byte DATE = 1;
    public static int ASCENDING = 1;
    public static int DESCENDING = -1;
    private int MESSAGE_ORDER;
    private int DATE_ORDER;
    private static final String P_COLUMN_1 = "column1";
    private static final String P_COLUMN_2 = "column2";
    public static final String P_ORDER_TYPE = "orderType";
    public static final String P_ORDER_VALUE = "orderValue";
    private IServer server;
    private TreeViewer viewer;
    private File fInputFile;
    private String fDirectory;
    private IMemento fMemento;
    private Action fDeleteLogAction;
    private Action fOpenLogAction;
    private Action fReadLogAction;
    private Action fExportLogAction;
    private Action fReLogErrorsAction;
    private TreeColumn fColumn1;
    private TreeColumn fColumn2;
    private Comparator fComparator;
    private List<AbstractEntry> elements = new ArrayList<AbstractEntry>();
    private ReloadLogJob reloadJob = null;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        ISelectionService service = (ISelectionService)this.getSite().getService(ISelectionService.class);
        service.addSelectionListener((ISelectionListener)this);
        this.fMemento = memento == null ? XMLMemento.createWriteRoot((String)"SERVERLOGVIEW") : memento;
        this.fMemento.putInteger(P_COLUMN_1, this.fMemento.getInteger(P_COLUMN_1) != null && this.fMemento.getInteger(P_COLUMN_1) > 0 ? this.fMemento.getInteger(P_COLUMN_1) : 350);
        this.fMemento.putInteger(P_COLUMN_2, this.fMemento.getInteger(P_COLUMN_2) != null && this.fMemento.getInteger(P_COLUMN_2) > 0 ? this.fMemento.getInteger(P_COLUMN_2) : 150);
        this.fMemento.putInteger(P_ORDER_VALUE, this.fMemento.getInteger(P_ORDER_VALUE) != null && this.fMemento.getInteger(P_ORDER_VALUE) != 0 ? this.fMemento.getInteger(P_ORDER_VALUE) : DESCENDING);
        this.fMemento.putInteger(P_ORDER_TYPE, this.fMemento.getInteger(P_ORDER_TYPE) != null && this.fMemento.getInteger(P_ORDER_TYPE) != 0 ? this.fMemento.getInteger(P_ORDER_TYPE) : 1);
        byte type = this.fMemento.getInteger(P_ORDER_TYPE).byteValue();
        switch (type) {
            case 1: {
                this.DATE_ORDER = this.fMemento.getInteger(P_ORDER_VALUE);
                this.MESSAGE_ORDER = DESCENDING;
                break;
            }
            case 0: {
                this.MESSAGE_ORDER = this.fMemento.getInteger(P_ORDER_VALUE);
                this.DATE_ORDER = DESCENDING;
                break;
            }
            default: {
                this.DATE_ORDER = DESCENDING;
                this.MESSAGE_ORDER = DESCENDING;
            }
        }
        this.setComparator(this.fMemento.getInteger(P_ORDER_TYPE).byteValue());
    }

    public void saveState(IMemento memento) {
        if (this.fMemento == null || memento == null) {
            return;
        }
        this.fMemento.putInteger(P_COLUMN_1, this.fColumn1.getWidth());
        this.fMemento.putInteger(P_COLUMN_2, this.fColumn2.getWidth());
        memento.putMemento(this.fMemento);
    }

    public void createPartControl(Composite parent) {
        Composite child = new Composite(parent, 0);
        child.setLayout((Layout)new FillLayout());
        this.viewer = new TreeViewer(child);
        this.createColumns(this.viewer);
        this.viewer.setContentProvider((IContentProvider)new LogContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LogLabelProvider());
        this.viewer.setInput((Object)this);
        this.viewer.setAutoExpandLevel(2);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                Object[] arr = sel.toArray();
                ServerLogView.this.viewer.update(arr, null);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object[] o = ((IStructuredSelection)ServerLogView.this.viewer.getSelection()).toArray();
                if (o != null && o.length > 0 && o[0] != null && o[0] instanceof AbstractEntry) {
                    new EventDetailsDialog(ServerLogView.this.viewer.getTree().getShell(), (AbstractEntry)((Object)o[0]), ServerLogView.this.viewer).open();
                }
            }
        });
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        this.fReLogErrorsAction = this.createReLogErrorAction();
        this.updateReLogActionText();
        toolBarManager.add((IAction)this.fReLogErrorsAction);
        toolBarManager.add((IContributionItem)new Separator());
        this.fExportLogAction = this.createExportLogAction();
        toolBarManager.add((IAction)this.fExportLogAction);
        toolBarManager.add((IContributionItem)new Separator());
        Action clearAction = this.createClearAction();
        toolBarManager.add((IAction)clearAction);
        this.fDeleteLogAction = this.createDeleteLogAction();
        toolBarManager.add((IAction)this.fDeleteLogAction);
        this.fOpenLogAction = this.createOpenLogAction();
        toolBarManager.add((IAction)this.fOpenLogAction);
        this.fReadLogAction = this.createReadLogAction();
        toolBarManager.add((IAction)this.fReadLogAction);
        this.setLogFile(null);
    }

    protected void createColumns(final TreeViewer viewer) {
        this.fColumn1 = new TreeColumn(viewer.getTree(), 16384);
        this.fColumn1.setText(org.eclipse.ui.internal.views.log.Messages.LogView_column_message);
        this.fColumn1.setWidth(this.fMemento.getInteger(P_COLUMN_1).intValue());
        this.fColumn1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerLogView serverLogView = ServerLogView.this;
                serverLogView.MESSAGE_ORDER = serverLogView.MESSAGE_ORDER * -1;
                ViewerComparator comparator = ServerLogView.this.getViewerComparator((byte)0);
                viewer.setComparator(comparator);
                ServerLogView.this.setComparator((byte)0);
                ServerLogView.this.fMemento.putInteger(ServerLogView.P_ORDER_VALUE, ServerLogView.this.MESSAGE_ORDER);
                ServerLogView.this.fMemento.putInteger(ServerLogView.P_ORDER_TYPE, 0);
                ServerLogView.this.setColumnSorting(ServerLogView.this.fColumn1, ServerLogView.this.MESSAGE_ORDER);
            }
        });
        this.fColumn2 = new TreeColumn(viewer.getTree(), 16384);
        this.fColumn2.setText(org.eclipse.ui.internal.views.log.Messages.LogView_column_date);
        this.fColumn2.setWidth(this.fMemento.getInteger(P_COLUMN_2).intValue());
        this.fColumn2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerLogView serverLogView = ServerLogView.this;
                serverLogView.DATE_ORDER = serverLogView.DATE_ORDER * -1;
                ViewerComparator comparator = ServerLogView.this.getViewerComparator((byte)1);
                viewer.setComparator(comparator);
                ServerLogView.this.setComparator((byte)1);
                ServerLogView.this.fMemento.putInteger(ServerLogView.P_ORDER_VALUE, ServerLogView.this.DATE_ORDER);
                ServerLogView.this.fMemento.putInteger(ServerLogView.P_ORDER_TYPE, 1);
                ServerLogView.this.setColumnSorting(ServerLogView.this.fColumn2, ServerLogView.this.DATE_ORDER);
            }
        });
        viewer.getTree().setHeaderVisible(true);
    }

    private void setColumnSorting(TreeColumn column, int order) {
        this.viewer.getTree().setSortColumn(column);
        this.viewer.getTree().setSortDirection(order == ASCENDING ? 128 : 1024);
    }

    public void setServer(IServer server) {
        if (this.server != null) {
            ServerLogger.getDefault().removeListener(this.server, (IServerLogListener)this);
        }
        this.server = server;
        ServerLogger.getDefault().addListener(server, (IServerLogListener)this);
        ServerLogger.getDefault();
        this.setLogFile(ServerLogger.getServerLogFile((IServer)server));
    }

    public void dispose() {
        ISelectionService service = (ISelectionService)this.getSite().getService(ISelectionService.class);
        service.removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    protected void setLogFile(File file) {
        this.fInputFile = file;
        this.fDirectory = this.fInputFile == null ? null : this.fInputFile.getParent();
        this.elements.clear();
        this.reloadLog();
    }

    protected void reloadLog() {
        if (this.reloadJob != null && this.reloadJob.getResult() == null) {
            this.reloadJob.cancel();
        }
        this.reloadJob = new ReloadLogJob();
        this.reloadJob.schedule();
    }

    private void updateButtons() {
        this.fDeleteLogAction.setEnabled(this.exists(this.fInputFile));
        this.fOpenLogAction.setEnabled(this.exists(this.fInputFile));
        this.fExportLogAction.setEnabled(this.exists(this.fInputFile));
    }

    private void asyncRefresh(final boolean activate) {
        if (this.viewer.getTree().isDisposed()) {
            return;
        }
        Display display = this.viewer.getTree().getDisplay();
        final ServerLogView view = this;
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    IServer selected = ServerLogger.findServerForFile((File)ServerLogView.this.fInputFile);
                    ServerLogView.this.setContentDescription(selected == null ? Messages.ServerLogView_NoLogSelected : selected.getName());
                    if (!ServerLogView.this.viewer.getTree().isDisposed()) {
                        IWorkbenchPage page;
                        ServerLogView.this.viewer.refresh();
                        ServerLogView.this.viewer.expandToLevel(2);
                        if (activate && (page = JBossServerUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null) {
                            page.bringToTop((IWorkbenchPart)view);
                        }
                    }
                }
            });
        }
    }

    protected boolean exists(File f) {
        return f != null && f.exists();
    }

    public void logging(IStatus status, IServer server) {
        if (server != null && server.equals(this.server)) {
            LogEntry entry = new LogEntry(status);
            this.elements.add(entry);
            this.asyncRefresh(false);
        }
    }

    public void setFocus() {
    }

    public boolean shouldSort() {
        return true;
    }

    public AbstractEntry[] getElements() {
        return this.elements.toArray(new AbstractEntry[this.elements.size()]);
    }

    private Action createReadLogAction() {
        Action action = new Action(org.eclipse.ui.internal.views.log.Messages.LogView_readLog_restore){

            public void run() {
                ServerLogView.this.reloadLog();
            }
        };
        action.setToolTipText(org.eclipse.ui.internal.views.log.Messages.LogView_readLog_restore_tooltip);
        action.setImageDescriptor(SharedImages.getImageDescriptor((String)"icons/elcl16/restore_log.gif"));
        action.setDisabledImageDescriptor(SharedImages.getImageDescriptor((String)"icons/dlcl16/restore_log.gif"));
        return action;
    }

    private Action createClearAction() {
        Action action = new Action(org.eclipse.ui.internal.views.log.Messages.LogView_clear){

            public void run() {
                ServerLogView.this.handleClear();
            }
        };
        action.setImageDescriptor(SharedImages.getImageDescriptor((String)"icons/elcl16/clear.gif"));
        action.setDisabledImageDescriptor(SharedImages.getImageDescriptor((String)"icons/dlcl16/clear.gif"));
        action.setToolTipText(org.eclipse.ui.internal.views.log.Messages.LogView_clear_tooltip);
        action.setText(org.eclipse.ui.internal.views.log.Messages.LogView_clear);
        return action;
    }

    private Action createOpenLogAction() {
        Action action = new Action(){

            public void run() {
                ServerLogView.this.openLog();
            }
        };
        action.setText(org.eclipse.ui.internal.views.log.Messages.LogView_view_currentLog);
        action.setImageDescriptor(SharedImages.getImageDescriptor((String)"icons/elcl16/open_log.gif"));
        action.setDisabledImageDescriptor(SharedImages.getImageDescriptor((String)"icons/dlcl16/open_log.gif"));
        action.setEnabled(this.fInputFile != null && this.fInputFile.exists());
        action.setToolTipText(org.eclipse.ui.internal.views.log.Messages.LogView_view_currentLog_tooltip);
        return action;
    }

    private Action createReLogErrorAction() {
        Action action = new Action(""){

            public void run() {
                ServerLogView.this.handleLogErrorAction();
            }
        };
        action.setImageDescriptor(SharedImages.getImageDescriptor((String)"icons/obj16/error_st_obj.gif"));
        return action;
    }

    private void handleLogErrorAction() {
        boolean currentVal = ServerLogger.shouldDoubleLogErrors();
        ServerLogger.setDoubleLogErrors((!currentVal ? 1 : 0) != 0);
        this.updateReLogActionText();
    }

    private void updateReLogActionText() {
        String newVal = !ServerLogger.shouldDoubleLogErrors() ? Messages.LogAction_DoNotLogErrorsToErrorLog : Messages.LogAction_AlsoLogErrorsToErrorLog;
        this.fReLogErrorsAction.setText(newVal);
        this.fReLogErrorsAction.setToolTipText(newVal);
    }

    private Action createExportLogAction() {
        Action action = new Action(org.eclipse.ui.internal.views.log.Messages.LogView_export){

            public void run() {
                ServerLogView.this.handleExport();
            }
        };
        action.setToolTipText(org.eclipse.ui.internal.views.log.Messages.LogView_export_tooltip);
        action.setImageDescriptor(SharedImages.getImageDescriptor((String)"icons/elcl16/export_log.gif"));
        action.setDisabledImageDescriptor(SharedImages.getImageDescriptor((String)"icons/dlcl16/export_log.gif"));
        action.setEnabled(this.fInputFile != null && this.fInputFile.exists());
        return action;
    }

    private void openLog() {
        try {
            IWorkbench wb = PlatformUI.getWorkbench();
            IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
            IWorkbenchPage page = win.getActivePage();
            IFile eclipseFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(this.fInputFile.getAbsolutePath()));
            IFileStore fileStore = EFS.getLocalFileSystem().fromLocalFile(this.fInputFile);
            if (eclipseFile != null) {
                FileEditorInput input = new FileEditorInput(eclipseFile);
                IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(this.fInputFile.getName());
                if (desc != null) {
                    page.openEditor((IEditorInput)input, desc.getId());
                }
            } else if (fileStore != null) {
                FileStoreEditorInput input = new FileStoreEditorInput(fileStore);
                IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor("dummy.txt");
                if (desc != null) {
                    page.openEditor((IEditorInput)input, desc.getId());
                }
            }
        }
        catch (PartInitException pie) {
            Status status = new Status(4, "org.jboss.ide.eclipse.as.ui", pie.getMessage(), (Throwable)pie);
            JBossServerUIPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    private Action createDeleteLogAction() {
        Action action = new Action(org.eclipse.ui.internal.views.log.Messages.LogView_delete){

            public void run() {
                ServerLogView.this.doDeleteLog();
            }
        };
        action.setToolTipText(org.eclipse.ui.internal.views.log.Messages.LogView_delete_tooltip);
        action.setImageDescriptor(SharedImages.getImageDescriptor((String)"icons/elcl16/remove.gif"));
        action.setDisabledImageDescriptor(SharedImages.getImageDescriptor((String)"icons/dlcl16/remove.gif"));
        action.setEnabled(this.fInputFile != null && this.fInputFile.exists());
        return action;
    }

    private void doDeleteLog() {
        String title = org.eclipse.ui.internal.views.log.Messages.LogView_confirmDelete_title;
        String message = org.eclipse.ui.internal.views.log.Messages.LogView_confirmDelete_message;
        if (!MessageDialog.openConfirm((Shell)this.viewer.getTree().getShell(), (String)title, (String)message)) {
            return;
        }
        if (this.fInputFile.delete() || this.elements.size() > 0) {
            this.handleClear();
        }
    }

    protected void handleClear() {
        BusyIndicator.showWhile((Display)this.viewer.getTree().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                ServerLogView.this.elements.clear();
                ServerLogView.this.asyncRefresh(false);
            }
        });
    }

    private void handleExport() {
        String path;
        FileDialog dialog = new FileDialog(this.getViewSite().getShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*.log"});
        if (this.fDirectory != null) {
            dialog.setFilterPath(this.fDirectory);
        }
        if ((path = dialog.open()) != null) {
            if (path.indexOf(46) == -1 && !path.endsWith(".log")) {
                path = String.valueOf(path) + ".log";
            }
            File outputFile = new Path(path).toFile();
            this.fDirectory = outputFile.getParent();
            if (outputFile.exists()) {
                String message = NLS.bind((String)org.eclipse.ui.internal.views.log.Messages.LogView_confirmOverwrite_message, (Object)outputFile.toString());
                if (!MessageDialog.openQuestion((Shell)this.getViewSite().getShell(), (String)org.eclipse.ui.internal.views.log.Messages.LogView_exportLog, (String)message)) {
                    return;
                }
            }
            Reader in = null;
            OutputStreamWriter out = null;
            try {
                out = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8");
                in = new InputStreamReader((InputStream)new FileInputStream(this.fInputFile), "UTF-8");
                this.copy(in, out);
            }
            catch (IOException iOException) {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        ((Writer)out).close();
                    }
                }
                catch (IOException iOException2) {}
            }
        }
    }

    private void copy(Reader input, Writer output) {
        block18: {
            BufferedReader reader = null;
            BufferedWriter writer = null;
            try {
                try {
                    String line;
                    reader = new BufferedReader(input);
                    writer = new BufferedWriter(output);
                    while (reader.ready() && (line = reader.readLine()) != null) {
                        writer.write(line);
                        writer.newLine();
                    }
                }
                catch (IOException iOException) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        if (writer != null) {
                            writer.close();
                        }
                        break block18;
                    }
                    catch (IOException iOException2) {}
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void setComparator(byte sortType) {
        this.fComparator = sortType == 1 ? new Comparator(){

            public int compare(Object e1, Object e2) {
                long date1 = 0L;
                long date2 = 0L;
                if (e1 instanceof LogEntry && e2 instanceof LogEntry) {
                    date1 = ((LogEntry)((Object)e1)).getDate().getTime();
                    date2 = ((LogEntry)((Object)e2)).getDate().getTime();
                } else if (e1 instanceof LogSession && e2 instanceof LogSession) {
                    date1 = ((LogSession)((Object)e1)).getDate() == null ? 0L : ((LogSession)((Object)e1)).getDate().getTime();
                    long l = date2 = ((LogSession)((Object)e2)).getDate() == null ? 0L : ((LogSession)((Object)e2)).getDate().getTime();
                }
                if (date1 == date2) {
                    int result = ServerLogView.this.elements.indexOf(e2) - ServerLogView.this.elements.indexOf(e1);
                    if (ServerLogView.this.DATE_ORDER == DESCENDING) {
                        result *= DESCENDING;
                    }
                    return result;
                }
                if (ServerLogView.this.DATE_ORDER == DESCENDING) {
                    return date1 > date2 ? DESCENDING : ASCENDING;
                }
                return date1 < date2 ? DESCENDING : ASCENDING;
            }
        } : new Comparator(){

            public int compare(Object e1, Object e2) {
                if (e1 instanceof LogEntry && e2 instanceof LogEntry) {
                    LogEntry entry1 = (LogEntry)((Object)e1);
                    LogEntry entry2 = (LogEntry)((Object)e2);
                    return Policy.getComparator().compare(entry1.getMessage(), entry2.getMessage()) * ServerLogView.this.MESSAGE_ORDER;
                }
                return 0;
            }
        };
    }

    private ViewerComparator getViewerComparator(byte sortType) {
        if (sortType == 0) {
            return new ViewerComparator(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    if (e1 instanceof LogEntry && e2 instanceof LogEntry) {
                        LogEntry entry1 = (LogEntry)((Object)e1);
                        LogEntry entry2 = (LogEntry)((Object)e2);
                        return this.getComparator().compare(entry1.getMessage(), entry2.getMessage()) * ServerLogView.this.MESSAGE_ORDER;
                    }
                    return 0;
                }
            };
        }
        return new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                long date1 = 0L;
                long date2 = 0L;
                if (e1 instanceof LogEntry && e2 instanceof LogEntry) {
                    date1 = ((LogEntry)((Object)e1)).getDate().getTime();
                    date2 = ((LogEntry)((Object)e2)).getDate().getTime();
                } else if (e1 instanceof LogSession && e2 instanceof LogSession) {
                    date1 = ((LogSession)((Object)e1)).getDate() == null ? 0L : ((LogSession)((Object)e1)).getDate().getTime();
                    long l = date2 = ((LogSession)((Object)e2)).getDate() == null ? 0L : ((LogSession)((Object)e2)).getDate().getTime();
                }
                if (date1 == date2) {
                    int result = ServerLogView.this.elements.indexOf(e2) - ServerLogView.this.elements.indexOf(e1);
                    if (ServerLogView.this.DATE_ORDER == DESCENDING) {
                        result *= DESCENDING;
                    }
                    return result;
                }
                if (ServerLogView.this.DATE_ORDER == DESCENDING) {
                    return date1 > date2 ? DESCENDING : ASCENDING;
                }
                return date1 < date2 ? DESCENDING : ASCENDING;
            }
        };
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Object o;
        IStructuredSelection sel2;
        if (selection != null && selection instanceof IStructuredSelection && (sel2 = (IStructuredSelection)selection).size() > 0 && (o = sel2.getFirstElement()) instanceof IServer) {
            this.setServer((IServer)o);
        }
    }

    public static class EventCategory {
        int val;

        EventCategory(int i) {
            this.val = i;
        }

        public int getType() {
            return this.val;
        }

        public boolean equals(Object other) {
            return other instanceof EventCategory && ((EventCategory)other).getType() == this.val;
        }

        public int hashCode() {
            return this.val;
        }
    }

    private class LogContentProvider
    implements ITreeContentProvider {
        private LogContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof AbstractEntry) {
                return ((AbstractEntry)((Object)parentElement)).getChildren(parentElement);
            }
            if (parentElement instanceof EventCategory) {
                int type = ((EventCategory)parentElement).getType();
                ArrayList<AbstractEntry> returnable = new ArrayList<AbstractEntry>();
                AbstractEntry[] entries = ServerLogView.this.getElements();
                int i = 0;
                while (i < entries.length) {
                    int type2;
                    if (entries[i] instanceof LogEntry && type == (type2 = ((LogEntry)entries[i]).getCode() & 0x1F000000)) {
                        returnable.add(entries[i]);
                    }
                    ++i;
                }
                return returnable.toArray(new AbstractEntry[returnable.size()]);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof AbstractEntry) {
                return ((AbstractEntry)((Object)element)).getParent(null);
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            if (!ServerLogView.this.shouldSort()) {
                return ServerLogView.this.getElements();
            }
            ArrayList<EventCategory> cats = new ArrayList<EventCategory>();
            AbstractEntry[] entries = ServerLogView.this.getElements();
            int i = 0;
            while (i < entries.length) {
                int type;
                if (entries[i] instanceof LogEntry && !cats.contains(new EventCategory(type = ((LogEntry)entries[i]).getCode() & 0x1F000000))) {
                    cats.add(new EventCategory(type));
                }
                ++i;
            }
            return cats.toArray(new EventCategory[cats.size()]);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ReloadLogJob
    extends Job {
        public ReloadLogJob() {
            super(Messages.ServerLogView_ImportingLogTaskName);
        }

        protected IStatus run(IProgressMonitor monitor) {
            ArrayList<AbstractEntry> entries = new ArrayList<AbstractEntry>();
            LogReader.parseLogFile(ServerLogView.this.fInputFile, entries, ServerLogView.this.fMemento);
            if (!monitor.isCanceled()) {
                ServerLogView.this.elements.addAll(entries);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ServerLogView.this.asyncRefresh(false);
                        ServerLogView.this.updateButtons();
                    }
                });
            }
            return Status.OK_STATUS;
        }
    }
}

