/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.launch;

import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.jboss.ide.eclipse.as.core.server.IJBossServer;
import org.jboss.ide.eclipse.as.core.server.INeedCredentials;
import org.jboss.ide.eclipse.as.core.server.IProvideCredentials;
import org.jboss.ide.eclipse.as.core.server.IServerProvider;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.ui.JBossServerUIPlugin;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.dialogs.RequiredCredentialsDialog;
import org.osgi.service.prefs.BackingStoreException;

public class UserPassCredentialProvider
implements IProvideCredentials {
    public static final String NEVER_ASK_AGAIN_KEY = "org.jboss.ide.eclipse.as.ui.launch.credentials.neverAsk";

    public boolean accepts(IServerProvider serverProvider, List<String> requiredProperties) {
        if (requiredProperties.size() > 2) {
            return false;
        }
        IServer s = serverProvider.getServer();
        IJBossServer jbs = ServerConverter.getJBossServer((IServer)s);
        return jbs != null && !jbs.hasJMXProvider();
    }

    public void handle(final INeedCredentials inNeed, final List<String> requiredProperties) {
        IServer server = inNeed.getServer();
        final IServerWorkingCopy copy = server.createWorkingCopy();
        final JBossServer jbs = (JBossServer)ServerConverter.getJBossServer((IServerWorkingCopy)copy);
        final String initialUser = jbs.getUsername();
        final String initialPass = jbs.getPassword();
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.jboss.ide.eclipse.as.ui");
        boolean ignore = prefs.getBoolean(NEVER_ASK_AGAIN_KEY, false);
        if (ignore) {
            Properties p = new Properties();
            p.put(requiredProperties.get(0), initialUser);
            p.put(requiredProperties.get(1), initialPass);
            inNeed.provideCredentials(p);
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                RequiredCredentialsDialog d = new RequiredCredentialsDialog(new Shell(), initialUser, initialPass);
                if (d.open() == 0) {
                    if (d.getNeverAskAgain()) {
                        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.jboss.ide.eclipse.as.ui");
                        prefs.putBoolean(UserPassCredentialProvider.NEVER_ASK_AGAIN_KEY, true);
                        try {
                            prefs.flush();
                        }
                        catch (BackingStoreException e) {
                            JBossServerUIPlugin.log("Unable to save dialog settings", (Exception)((Object)e));
                        }
                    }
                    if (d.getSave()) {
                        jbs.setPassword(d.getPass());
                        jbs.setUsername(d.getUser());
                        try {
                            copy.save(false, null);
                        }
                        catch (CoreException ce) {
                            JBossServerUIPlugin.log(Messages.ServerSaveFailed, (Exception)((Object)ce));
                        }
                    }
                    Properties p = new Properties();
                    p.put(requiredProperties.get(0), d.getUser());
                    p.put(requiredProperties.get(1), d.getPass());
                    inNeed.provideCredentials(p);
                } else {
                    inNeed.provideCredentials(null);
                }
            }
        });
    }
}

