/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.launch;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.ClientDelegate;
import org.jboss.ide.eclipse.as.core.server.IServerModuleStateVerifier;
import org.jboss.ide.eclipse.as.core.server.internal.JBossLaunchAdapter;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;
import org.jboss.ide.eclipse.as.ui.JBossServerUIPlugin;

public class JBTWebLaunchableClient
extends ClientDelegate {
    private static final String BROWSER_COULD_NOT_OPEN_BROWSER = "Unable to open web browser";

    public boolean supports(IServer server, Object launchable, String launchMode) {
        return launchable instanceof JBossLaunchAdapter.JBTCustomHttpLaunchable;
    }

    public IStatus launch(final IServer server, final Object launchable, final String launchMode, final ILaunch launch) {
        if (server.getServerState() == 4 || server.getServerState() == 3) {
            return Status.CANCEL_STATUS;
        }
        new Thread(){

            @Override
            public void run() {
                JBTWebLaunchableClient.this.launch2(server, launchable, launchMode, launch);
            }
        }.start();
        return Status.OK_STATUS;
    }

    public IStatus launch2(IServer server, Object launchable, String launchMode, ILaunch launch) {
        final JBossLaunchAdapter.JBTCustomHttpLaunchable http = (JBossLaunchAdapter.JBTCustomHttpLaunchable)launchable;
        this.wait(server, http.getModuleTree(server));
        if (server.getServerState() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    JBTWebLaunchableClient.openBrowser(http.getURL());
                }
            });
        } else {
            JBossServerUIPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.jboss.ide.eclipse.as.ui", "Server stopped before before browser could be opened.", null));
        }
        return Status.OK_STATUS;
    }

    protected void wait(IServer server, IModule[] module) {
        IServerModuleStateVerifier verifier;
        ServerExtendedProperties props;
        this.waitServerStarted(server);
        int state = ((Server)server).getModulePublishState(module);
        if (state != 1) {
            server.publish(1, null);
        }
        if ((props = (ServerExtendedProperties)server.loadAdapter(ServerExtendedProperties.class, (IProgressMonitor)new NullProgressMonitor())) != null && props.canVerifyRemoteModuleState() && (verifier = props.getModuleStateVerifier()) != null) {
            verifier.waitModuleStarted(server, module, 20000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitServerStarted(final IServer server) {
        final Object lock = new Object();
        IServerListener listener = new IServerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serverChanged(ServerEvent event) {
                Object object = lock;
                synchronized (object) {
                    if (server.getServerState() != 1) {
                        lock.notifyAll();
                    }
                }
            }
        };
        Object object = lock;
        synchronized (object) {
            server.addServerListener(listener);
            if (server.getServerState() == 1) {
                try {
                    lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        server.removeServerListener(listener);
    }

    public static void checkedCreateInternalBrowser(String url, String browserId, String pluginId, ILog log) {
        try {
            JBTWebLaunchableClient.openUrl(url, PlatformUI.getWorkbench().getBrowserSupport().createBrowser(6, browserId, null, null), pluginId, log);
        }
        catch (PartInitException e) {
            IStatus errorStatus = JBTWebLaunchableClient.createErrorStatus(pluginId, BROWSER_COULD_NOT_OPEN_BROWSER, e, url);
            log.log(errorStatus);
        }
    }

    private static IStatus createErrorStatus(String pluginId, String message, Throwable e, Object ... messageArguments) {
        String formattedMessage = null;
        if (message != null) {
            formattedMessage = MessageFormat.format(message, messageArguments);
        }
        return new Status(4, pluginId, 4, formattedMessage, e);
    }

    public static void checkedCreateExternalBrowser(String url, String pluginId, ILog log) {
        try {
            JBTWebLaunchableClient.openUrl(url, PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser(), pluginId, log);
        }
        catch (PartInitException e) {
            IStatus errorStatus = JBTWebLaunchableClient.createErrorStatus(pluginId, BROWSER_COULD_NOT_OPEN_BROWSER, e, url);
            log.log(errorStatus);
        }
    }

    public static void openUrl(String url, IWebBrowser browser, String pluginId, ILog log) {
        try {
            browser.openURL(new URL(url));
        }
        catch (PartInitException e) {
            IStatus errorStatus = JBTWebLaunchableClient.createErrorStatus(pluginId, BROWSER_COULD_NOT_OPEN_BROWSER, e, url);
            log.log(errorStatus);
        }
        catch (MalformedURLException e) {
            IStatus errorStatus = JBTWebLaunchableClient.createErrorStatus(pluginId, BROWSER_COULD_NOT_OPEN_BROWSER, e, url);
            log.log(errorStatus);
        }
    }

    public static void openBrowser(URL url) {
        try {
            IWorkbenchBrowserSupport browserSupport = JBossServerUIPlugin.getDefault().getWorkbench().getBrowserSupport();
            IWebBrowser browser = browserSupport.createBrowser(6, null, null, null);
            browser.openURL(url);
        }
        catch (Exception e) {
            JBossServerUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.ide.eclipse.as.ui", BROWSER_COULD_NOT_OPEN_BROWSER, (Throwable)e));
        }
    }
}

