/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.conversion.ui.internal.jobs;

import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;

public abstract class IdentificationJob
extends Job {
    protected Boolean resolvable;
    protected Task task;
    protected Dependency dependency;

    public IdentificationJob(String name) {
        super(name);
    }

    public Dependency getDependency() {
        return this.dependency;
    }

    public void setDependency(Dependency dependency) {
        this.dependency = dependency;
    }

    public Boolean isResolvable() {
        return this.resolvable;
    }

    public void setRequestedProcess(Task requestedProcess) {
        this.task = requestedProcess;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (monitor.isCanceled()) {
            return Status.OK_STATUS;
        }
        this.resolvable = null;
        try {
            if (Task.ALL.equals((Object)this.task) || Task.IDENTIFICATION_ONLY.equals((Object)this.task)) {
                this.dependency = null;
                this.identifyDependency(monitor);
            }
            if (this.dependency != null && (Task.ALL.equals((Object)this.task) || Task.RESOLUTION_ONLY.equals((Object)this.task))) {
                this.checkResolution(monitor);
            }
        }
        catch (CoreException e) {
            monitor.worked(1);
            return new Status(4, "org.jboss.tools.maven.conversion.ui", e.getMessage(), (Throwable)e);
        }
        monitor.worked(1);
        return Status.OK_STATUS;
    }

    protected abstract void identifyDependency(IProgressMonitor var1) throws CoreException;

    protected void checkResolution(IProgressMonitor monitor) throws CoreException {
        if (this.dependency == null || monitor.isCanceled()) {
            return;
        }
        this.resolvable = Boolean.FALSE;
        String groupId = this.dependency.getGroupId();
        String artifactId = this.dependency.getArtifactId();
        String version = this.dependency.getVersion();
        String type = this.dependency.getType();
        if (groupId == null || artifactId == null || version == null) {
            return;
        }
        if (type == null) {
            type = "jar";
        }
        String classifier = this.dependency.getClassifier();
        IMaven maven = MavenPlugin.getMaven();
        List artifactRepositories = maven.getArtifactRepositories();
        Artifact a = null;
        try {
            a = maven.resolve(groupId, artifactId, version, type, classifier, artifactRepositories, monitor);
        }
        catch (CoreException coreException) {}
        this.resolvable = a != null && a.isResolved();
    }

    public static enum Task {
        ALL,
        IDENTIFICATION_ONLY,
        RESOLUTION_ONLY;

    }
}

