/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.websockets.ui.internal.ca;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.ui.text.java.CompletionProposalLabelProvider;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.jboss.tools.common.util.EclipseJavaUtil;
import org.jboss.tools.websockets.core.WebsocketConstants;
import org.jboss.tools.websockets.ui.WebsocketsUIPlugin;
import org.jboss.tools.websockets.ui.internal.ca.CAMessages;
import org.jboss.tools.websockets.ui.internal.ca.MethodCompletionProposal;
import org.jboss.tools.websockets.ui.internal.ca.WebsocketMethodInfo;

public class SocketProposalComputer
implements IJavaCompletionProposalComputer,
WebsocketConstants {
    static String ON_CLOSE_METHOD_NAME = "onClose";
    static String ON_ERROR_METHOD_NAME = "onError";
    static String ON_MESSAGE_METHOD_NAME = "onMessage";
    static String ON_OPEN_METHOD_NAME = "onOpen";
    static String MESSAGE_PARAM = "message";
    static WebsocketMethodInfo ON_CLOSE_INFO = new WebsocketMethodInfo(ON_CLOSE_METHOD_NAME, new String[]{"javax.websocket.Session", "javax.websocket.CloseReason"}, null, "javax.websocket.OnClose", SocketProposalComputer.createMethodProposalLabel(CAMessages.onCloseProposalLabel), CAMessages.onCloseProposalInfo);
    static WebsocketMethodInfo ON_ERROR_INFO = new WebsocketMethodInfo(ON_ERROR_METHOD_NAME, new String[]{"javax.websocket.Session", "java.lang.Throwable"}, null, "javax.websocket.OnError", SocketProposalComputer.createMethodProposalLabel(CAMessages.onErrorProposalLabel), CAMessages.onErrorProposalInfo);
    static WebsocketMethodInfo ON_OPEN_INFO = new WebsocketMethodInfo(ON_OPEN_METHOD_NAME, new String[]{"javax.websocket.Session", "javax.websocket.EndpointConfig"}, null, "javax.websocket.OnOpen", SocketProposalComputer.createMethodProposalLabel(CAMessages.onOpenProposalLabel), CAMessages.onOpenProposalInfo);
    static WebsocketMethodInfo ON_MESSAGE_TEXT_INFO = new WebsocketMethodInfo(ON_MESSAGE_METHOD_NAME, new String[]{"java.lang.String"}, new String[]{MESSAGE_PARAM}, "javax.websocket.OnMessage", SocketProposalComputer.createMethodProposalLabel(CAMessages.onMessageTextProposalLabel), CAMessages.onMessageTextProposalInfo);
    static WebsocketMethodInfo ON_MESSAGE_BINARY_INFO = new WebsocketMethodInfo(ON_MESSAGE_METHOD_NAME, new String[]{"byte[]"}, new String[]{MESSAGE_PARAM}, "javax.websocket.OnMessage", SocketProposalComputer.createMethodProposalLabel(CAMessages.onMessageBinaryProposalLabel), CAMessages.onMessageBinaryProposalInfo);
    static WebsocketMethodInfo ON_MESSAGE_PONG_INFO = new WebsocketMethodInfo(ON_MESSAGE_METHOD_NAME, new String[]{"javax.websocket.PongMessage"}, new String[]{MESSAGE_PARAM}, "javax.websocket.OnMessage", SocketProposalComputer.createMethodProposalLabel(CAMessages.onMessagePongProposalLabel), CAMessages.onMessagePongProposalInfo);
    CompletionProposalLabelProvider labelProvider = new CompletionProposalLabelProvider();
    static Set<String> ON_ANNOTATIONS_QNAMES = new HashSet<String>();
    static Set<String> ON_ANNOTATIONS_NAMES = new HashSet<String>();

    static {
        ON_ANNOTATIONS_QNAMES.add("javax.websocket.OnClose");
        ON_ANNOTATIONS_QNAMES.add("javax.websocket.OnError");
        ON_ANNOTATIONS_QNAMES.add("javax.websocket.OnMessage");
        ON_ANNOTATIONS_QNAMES.add("javax.websocket.OnOpen");
        ON_ANNOTATIONS_NAMES.add("OnClose");
        ON_ANNOTATIONS_NAMES.add("OnError");
        ON_ANNOTATIONS_NAMES.add("OnMessage");
        ON_ANNOTATIONS_NAMES.add("OnOpen");
    }

    public void sessionStarted() {
    }

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        MethodCompletionProposal proposal;
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        if (!(context instanceof JavaContentAssistInvocationContext)) {
            return result;
        }
        JavaContentAssistInvocationContext javaContext = (JavaContentAssistInvocationContext)context;
        ICompilationUnit cu = javaContext.getCompilationUnit();
        int offset = javaContext.getInvocationOffset();
        IDocument doc = javaContext.getDocument();
        HashSet<WebsocketMethodInfo> allowedMethods = new HashSet<WebsocketMethodInfo>();
        allowedMethods.add(ON_CLOSE_INFO);
        allowedMethods.add(ON_ERROR_INFO);
        allowedMethods.add(ON_MESSAGE_TEXT_INFO);
        allowedMethods.add(ON_MESSAGE_BINARY_INFO);
        allowedMethods.add(ON_MESSAGE_PONG_INFO);
        allowedMethods.add(ON_OPEN_INFO);
        Visitor visitor = null;
        try {
            IType type;
            cu.reconcile();
            IJavaElement el = cu.getElementAt(offset);
            if (!(el instanceof IMember)) {
                return result;
            }
            IMember m = (IMember)el;
            IType iType = type = m instanceof IType ? (IType)m : m.getDeclaringType();
            if (type == null) {
                return result;
            }
            IAnnotation a1 = EclipseJavaUtil.findAnnotation((IType)type, (IAnnotatable)type, (String)"javax.websocket.server.ServerEndpoint");
            IAnnotation a2 = EclipseJavaUtil.findAnnotation((IType)type, (IAnnotatable)type, (String)"javax.websocket.ClientEndpoint");
            if (a1 == null && a2 == null) {
                return result;
            }
            visitor = this.check(cu, context);
            if (visitor == null) {
                return result;
            }
            IMethod[] iMethodArray = type.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                if (allowedMethods.isEmpty()) break;
                String a = this.findEndpointMethodAnnotation(type, (IAnnotatable)method);
                if (a != null) {
                    if ("javax.websocket.OnClose".equals(a)) {
                        allowedMethods.remove(ON_CLOSE_INFO);
                    } else if ("javax.websocket.OnError".equals(a)) {
                        allowedMethods.remove(ON_ERROR_INFO);
                    } else if ("javax.websocket.OnOpen".equals(a)) {
                        allowedMethods.remove(ON_OPEN_INFO);
                    } else if ("javax.websocket.OnMessage".equals(a)) {
                        if (this.hasPongParameter(method)) {
                            allowedMethods.remove(ON_MESSAGE_PONG_INFO);
                        } else if (this.hasBinaryParameter(method)) {
                            allowedMethods.remove(ON_MESSAGE_BINARY_INFO);
                        } else {
                            allowedMethods.remove(ON_MESSAGE_TEXT_INFO);
                        }
                    }
                }
                ++n2;
            }
            if (allowedMethods.isEmpty()) {
                return result;
            }
        }
        catch (JavaModelException e) {
            WebsocketsUIPlugin.pluginLog().logError((Throwable)e);
        }
        MatchInfo match = null;
        if (visitor.isHeader) {
            match = new MatchInfo();
            match.prefix = "";
            match.matches.add("OnClose");
            match.matches.add("OnError");
            match.matches.add("OnMessage");
            match.matches.add("OnOpen");
        } else {
            match = this.computePrefix(doc, javaContext.getInvocationOffset());
        }
        if (match == null) {
            return result;
        }
        int length = visitor.endOffset - visitor.startOffset;
        if (allowedMethods.contains(ON_CLOSE_INFO) && match.contains("OnClose")) {
            proposal = new MethodCompletionProposal(cu.getJavaProject(), cu, ON_CLOSE_INFO, javaContext.getInvocationOffset(), length, visitor.startOffset, match.prefix.length(), "@OnClose public void onClose() {}");
            result.add((ICompletionProposal)proposal);
        }
        if (allowedMethods.contains(ON_OPEN_INFO) && match.contains("OnOpen")) {
            proposal = new MethodCompletionProposal(cu.getJavaProject(), cu, ON_OPEN_INFO, javaContext.getInvocationOffset(), length, visitor.startOffset, match.prefix.length(), "@OnOpen public void onOpen() {}");
            result.add((ICompletionProposal)proposal);
        }
        if (allowedMethods.contains(ON_ERROR_INFO) && match.contains("OnError")) {
            proposal = new MethodCompletionProposal(cu.getJavaProject(), cu, ON_ERROR_INFO, javaContext.getInvocationOffset(), length, visitor.startOffset, match.prefix.length(), "@OnError public void onError() {}");
            result.add((ICompletionProposal)proposal);
        }
        WebsocketMethodInfo[] messages = new WebsocketMethodInfo[]{ON_MESSAGE_TEXT_INFO, ON_MESSAGE_BINARY_INFO, ON_MESSAGE_PONG_INFO};
        if (match.contains("OnMessage")) {
            WebsocketMethodInfo[] websocketMethodInfoArray = messages;
            int n = messages.length;
            int n3 = 0;
            while (n3 < n) {
                WebsocketMethodInfo info = websocketMethodInfoArray[n3];
                if (allowedMethods.contains(info)) {
                    MethodCompletionProposal proposal2 = new MethodCompletionProposal(cu.getJavaProject(), cu, info, javaContext.getInvocationOffset(), length, visitor.startOffset, match.prefix.length(), "@OnMessage public String onMessage() {}");
                    result.add((ICompletionProposal)proposal2);
                }
                ++n3;
            }
        }
        return result;
    }

    MatchInfo computePrefix(IDocument doc, int offset) {
        MatchInfo match;
        block9: {
            match = new MatchInfo();
            int length = 8;
            if (offset < 8) {
                length = offset;
            }
            try {
                String s = doc.get(offset - length, length);
                int i = s.lastIndexOf("@");
                if (i >= 0) {
                    s = s.substring(i);
                    match.prefix = s.substring(1);
                    this.match(match);
                    match.prefix = s;
                } else {
                    int k = s.length() - 1;
                    while (k >= 0) {
                        if (!Character.isLetter(s.charAt(k))) {
                            match.prefix = s.substring(k + 1);
                            this.match(match);
                            break;
                        }
                        --k;
                    }
                }
                if (match.matches.isEmpty()) break block9;
                int q = offset - match.prefix.length() - 1;
                while (q >= 0) {
                    char ch = doc.getChar(q);
                    if (ch == ';' || ch == '{' || ch == '}' || ch == '\r' || ch == '\n') break;
                    if (!Character.isWhitespace(ch)) {
                        match.matches.clear();
                        break;
                    }
                    --q;
                }
            }
            catch (BadLocationException e) {
                WebsocketsUIPlugin.pluginLog().logError((Throwable)e);
            }
        }
        return match.matches.isEmpty() ? null : match;
    }

    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return new ArrayList<IContextInformation>();
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
    }

    static StyledString createMethodProposalLabel(String name) {
        StyledString nameBuffer = new StyledString();
        nameBuffer.append(name);
        int i = name.indexOf("-");
        if (i > 0) {
            nameBuffer.setStyle(i, name.length() - i, StyledString.QUALIFIER_STYLER);
        }
        return nameBuffer;
    }

    private Visitor check(ICompilationUnit unit, ContentAssistInvocationContext context) {
        CompilationUnit ast = SocketProposalComputer.parse(unit);
        Visitor visitor = new Visitor(context);
        ast.accept((ASTVisitor)visitor);
        return visitor.startOffset < 0 ? null : visitor;
    }

    private static CompilationUnit parse(ICompilationUnit unit) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setKind(8);
        parser.setSource(unit);
        parser.setResolveBindings(true);
        return (CompilationUnit)parser.createAST(null);
    }

    boolean isPrefix(String text) {
        MatchInfo match = new MatchInfo();
        match.prefix = text;
        this.match(match);
        return !match.matches.isEmpty();
    }

    private void match(MatchInfo matchInfo) {
        this.matchName(matchInfo, "OnClose");
        this.matchName(matchInfo, "OnError");
        this.matchName(matchInfo, "OnMessage");
        this.matchName(matchInfo, "OnOpen");
    }

    private void matchName(MatchInfo matchInfo, String tryName) {
        if (tryName.toLowerCase().startsWith(matchInfo.prefix.toLowerCase())) {
            matchInfo.matches.add(tryName);
        }
    }

    String findEndpointMethodAnnotation(IType sourceType, IAnnotatable member) throws JavaModelException {
        IAnnotation[] iAnnotationArray = member.getAnnotations();
        int n = iAnnotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType annotationType;
            String qName;
            IAnnotation annotation = iAnnotationArray[n2];
            String name = annotation.getElementName();
            if (ON_ANNOTATIONS_QNAMES.contains(name)) {
                return name;
            }
            if (ON_ANNOTATIONS_NAMES.contains(name) && (qName = EclipseJavaUtil.resolveType((IType)sourceType, (String)name)) != null && (annotationType = sourceType.getJavaProject().findType(qName)) != null && ON_ANNOTATIONS_QNAMES.contains(annotationType.getFullyQualifiedName())) {
                return annotationType.getFullyQualifiedName();
            }
            ++n2;
        }
        return null;
    }

    boolean hasPongParameter(IMethod method) {
        String[] stringArray = method.getParameterTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            String qType = EclipseJavaUtil.resolveTypeAsString((IType)method.getDeclaringType(), (String)type);
            if ("javax.websocket.PongMessage".equals(qType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean hasBinaryParameter(IMethod method) {
        String[] stringArray = method.getParameterTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            String qType = EclipseJavaUtil.resolveTypeAsString((IType)method.getDeclaringType(), (String)type);
            if ("byte[]".equals(qType) || "java.nio.ByteBuffer".equals(qType) || "java.io.InputStream".equals(qType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    class MatchInfo {
        String prefix;
        Set<String> matches = new HashSet<String>();

        MatchInfo() {
        }

        boolean contains(String name) {
            return this.matches.contains(name);
        }
    }

    class Visitor
    extends ASTVisitor {
        int offset = -1;
        IDocument doc = null;
        int startOffset = -1;
        int endOffset = -1;
        boolean isHeader = false;

        public Visitor(ContentAssistInvocationContext context) {
            this.startOffset = this.offset = context.getInvocationOffset();
            this.endOffset = this.offset;
            this.doc = context.getDocument();
        }

        public boolean visit(TypeDeclaration node) {
            SimpleName n = node.getName();
            if (this.offset >= n.getStartPosition() && this.offset <= n.getStartPosition() + n.getLength()) {
                this.endOffset = this.startOffset = node.getStartPosition() + node.getLength() - 1;
                this.isHeader = true;
                return false;
            }
            if (this.isBeforeEnd((ASTNode)node.getName()) || this.isBeforeEnd((ASTNode)node.getSuperclassType())) {
                this.endOffset = -1;
                this.startOffset = -1;
                return false;
            }
            for (Object o : node.superInterfaceTypes()) {
                if (!(o instanceof ASTNode) || !this.isBeforeEnd((ASTNode)o)) continue;
                this.endOffset = -1;
                this.startOffset = -1;
                return false;
            }
            return true;
        }

        boolean isBeforeEnd(ASTNode n) {
            return n != null && this.offset <= n.getStartPosition() + n.getLength();
        }

        public boolean visit(Block node) {
            if (this.offset > node.getStartPosition() && this.offset < node.getStartPosition() + node.getLength()) {
                this.endOffset = -1;
                this.startOffset = -1;
            }
            return false;
        }

        public boolean visit(FieldDeclaration node) {
            return this.visitFieldOrMethod((BodyDeclaration)node);
        }

        public boolean visit(MethodDeclaration node) {
            return this.visitFieldOrMethod((BodyDeclaration)node);
        }

        boolean visitFieldOrMethod(BodyDeclaration node) {
            if (this.offset > node.getStartPosition() && this.offset < node.getStartPosition() + node.getLength()) {
                int i;
                String text;
                block8: {
                    block7: {
                        text = this.doc.get(node.getStartPosition(), this.offset - node.getStartPosition());
                        i = text.indexOf("@");
                        if (i >= 0) break block7;
                        if (text.trim().length() > 0) {
                            this.endOffset = -1;
                            this.startOffset = -1;
                        }
                        return false;
                    }
                    if (text.substring(0, i).trim().length() <= 0) break block8;
                    this.endOffset = -1;
                    this.startOffset = -1;
                    return false;
                }
                try {
                    text = text.substring(i + 1);
                    if (!SocketProposalComputer.this.isPrefix(text)) {
                        this.endOffset = -1;
                        this.startOffset = -1;
                    }
                }
                catch (BadLocationException e) {
                    WebsocketsUIPlugin.pluginLog().logError((Throwable)e);
                }
            }
            return false;
        }
    }
}

