/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.CDIImages;
import org.jboss.tools.cdi.core.ICDIAnnotation;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.cdi.core.IQualifier;
import org.jboss.tools.cdi.core.IScope;
import org.jboss.tools.cdi.ui.CDIUIMessages;
import org.jboss.tools.cdi.ui.wizard.BeansXMLAccess;
import org.jboss.tools.cdi.ui.wizard.CheckBoxEditorWrapper;
import org.jboss.tools.cdi.ui.wizard.NewCDIAnnotationWizardPage;
import org.jboss.tools.cdi.ui.wizard.QualifierSelectionProvider;
import org.jboss.tools.common.ui.widget.editor.CheckBoxFieldEditor;
import org.jboss.tools.common.ui.widget.editor.CompositeEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditorFactory;
import org.jboss.tools.common.ui.widget.editor.ITaggedFieldEditor;
import org.jboss.tools.common.ui.widget.editor.LabelFieldEditor;
import org.jboss.tools.common.ui.widget.editor.ListFieldEditor;
import org.jboss.tools.common.ui.widget.editor.TextFieldEditor;

public class NewBeanWizardPage
extends NewClassWizardPage {
    protected CheckBoxEditorWrapper alternative = null;
    protected boolean mayBeRegisteredInBeansXML = true;
    protected BeansXMLAccess registerInBeansXML = new BeansXMLAccess((NewTypeWizardPage)this, "Alternatives", "CDIClass", "class");
    protected CheckBoxEditorWrapper isNamed;
    protected BeanNameEditorWrapper beanName;
    protected ITaggedFieldEditor scope = null;
    protected Map<String, String> scopes = new TreeMap<String, String>();
    protected QualifierSelectionProvider qualifiersProvider = new QualifierSelectionProvider();
    protected ListFieldEditor qualifiers = null;
    protected StatusInfo fieldNameStatus = new StatusInfo();
    protected StatusInfo scopeStatus = new StatusInfo();
    boolean isAlternativeInitialValue = false;

    public NewBeanWizardPage() {
        this.setTitle(CDIUIMessages.NEW_BEAN_WIZARD_PAGE_NAME);
        this.setDescription(CDIUIMessages.NEW_BEAN_WIZARD_DESCRIPTION);
        this.setImageDescriptor(CDIImages.getImageDescriptor((String)"wizard/CDIClassWizBan.png"));
    }

    public void setMayBeRegisteredInBeansXML(boolean b) {
        this.mayBeRegisteredInBeansXML = b;
    }

    public void init(IStructuredSelection selection) {
        super.init(selection);
        if (selection != null && !selection.isEmpty()) {
            Object o = selection.iterator().next();
            IType type = null;
            if (o instanceof IType) {
                type = (IType)o;
            } else if (o instanceof ICompilationUnit) {
                ICompilationUnit cu = (ICompilationUnit)o;
                try {
                    IType[] ts = cu.getTypes();
                    if (ts != null && ts.length > 0) {
                        type = ts[0];
                    }
                }
                catch (JavaModelException e) {
                    CDICorePlugin.getDefault().logError((Throwable)e);
                }
            }
            boolean isInterface = false;
            try {
                isInterface = type != null && type.isInterface();
            }
            catch (JavaModelException e) {
                CDICorePlugin.getDefault().logError((Throwable)e);
            }
            ArrayList<String> interfacesNames = new ArrayList<String>();
            if (isInterface) {
                String name = "";
                try {
                    name = type.getFullyQualifiedParameterizedName();
                }
                catch (JavaModelException javaModelException) {
                    name = type.getFullyQualifiedName();
                }
                interfacesNames.add(name);
                this.setDefaultTypeName(name);
            }
            this.setSuperInterfaces(interfacesNames, true);
            this.superInterfacesChanged();
        }
        this.doStatusUpdate();
    }

    void setDefaultTypeName(String interfaceName) {
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createModifierControls(composite, nColumns);
        this.createSuperClassControls(composite, nColumns);
        this.createSuperInterfacesControls(composite, nColumns);
        this.createCustomFields(composite);
        this.createCommentControls(composite, nColumns);
        this.enableCommentControl(true);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.new_class_wizard_page_context");
        this.computeScopeStatus();
        this.doStatusUpdate();
    }

    protected void createTypeMembers(IType newType, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        this.createInheritedMethods(newType, true, true, imports, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        ISourceRange range = newType.getSourceRange();
        IBuffer buf = newType.getCompilationUnit().getBuffer();
        String lineDelimiter = StubUtility.getLineDelimiterUsed((IJavaProject)newType.getJavaProject());
        StringBuffer sb = new StringBuffer();
        this.addAnnotations(imports, sb, lineDelimiter);
        buf.replace(range.getOffset(), 0, sb.toString());
    }

    void addAnnotations(NewTypeWizardPage.ImportsManager imports, StringBuffer sb, String lineDelimiter) {
        this.addAlternativeAnnotation(imports, sb, lineDelimiter);
        this.addNamedAnnotation(imports, sb, lineDelimiter);
        this.addScopeAnnotation(imports, sb, lineDelimiter);
        this.addQualifiersAnnotations(imports, sb, lineDelimiter);
    }

    protected void addAlternativeAnnotation(NewTypeWizardPage.ImportsManager imports, StringBuffer sb, String lineDelimiter) {
        if (this.alternative != null && this.alternative.composite.getValue() == Boolean.TRUE) {
            NewCDIAnnotationWizardPage.addAnnotation("javax.enterprise.inject.Alternative", imports, sb, lineDelimiter);
        }
    }

    protected void addNamedAnnotation(NewTypeWizardPage.ImportsManager imports, StringBuffer sb, String lineDelimiter) {
        if (this.isNamed.checkBox != null && this.isNamed.checkBox.getValue() != null && "true".equals(this.isNamed.checkBox.getValueAsString())) {
            if (this.beanName.text.getValue() != null && this.beanName.text.getValueAsString().length() > 0) {
                NewBeanWizardPage.addAnnotation("javax.inject.Named", imports, sb, lineDelimiter, this.beanName.text.getValueAsString());
            } else {
                NewCDIAnnotationWizardPage.addAnnotation("javax.inject.Named", imports, sb, lineDelimiter);
            }
        }
    }

    static void addAnnotation(String typeName, NewTypeWizardPage.ImportsManager imports, StringBuffer sb, String lineDelimiter, String value) {
        int i = typeName.lastIndexOf(46);
        String name = typeName.substring(i + 1);
        imports.addImport(typeName);
        sb.append("@").append(name).append("(\"").append(value).append("\")").append(lineDelimiter);
    }

    protected void addScopeAnnotation(NewTypeWizardPage.ImportsManager imports, StringBuffer sb, String lineDelimiter) {
        if (this.scope != null && this.scope.getValue() != null && this.scope.getValue().toString().length() > 0) {
            String scopeName = this.scope.getValue().toString();
            String qScopeName = this.scopes.get(scopeName);
            NewCDIAnnotationWizardPage.addAnnotation(qScopeName, imports, sb, lineDelimiter);
        }
    }

    protected void addQualifiersAnnotations(NewTypeWizardPage.ImportsManager imports, StringBuffer sb, String lineDelimiter) {
        if (this.qualifiers != null) {
            List list = (List)this.qualifiers.getValue();
            for (Object o : list) {
                if (!(o instanceof ICDIAnnotation)) continue;
                ICDIAnnotation a = (ICDIAnnotation)o;
                String typeName = a.getSourceType().getFullyQualifiedName();
                NewCDIAnnotationWizardPage.addAnnotation(typeName, imports, sb, lineDelimiter);
            }
        }
    }

    protected void createCustomFields(Composite composite) {
        this.createBeanNameField(composite);
        this.createAlternativeField(composite);
        this.createRegisterInBeansXML(composite);
        this.createScopeField(composite);
        this.createQualifiersField(composite);
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.isEnclosingTypeSelected() ? this.fEnclosingTypeStatus : this.fPackageStatus, this.fTypeNameStatus, this.fModifierStatus, this.fSuperClassStatus, this.fSuperInterfacesStatus};
        this.updateStatus(status);
    }

    protected void updateStatus(IStatus[] status) {
        IStatus[] ns = new IStatus[status.length + 2];
        System.arraycopy(status, 0, ns, 0, status.length);
        ns[status.length] = this.fieldNameStatus;
        ns[status.length + 1] = this.scopeStatus;
        status = ns;
        this.updateStatus(StatusUtil.getMostSevere((IStatus[])status));
    }

    public void setPackageFragmentRoot(IPackageFragmentRoot root, boolean canBeModified) {
        super.setPackageFragmentRoot(root, canBeModified);
        this.setScopes(root);
        this.setQualifiers(root);
    }

    void setScopes(IPackageFragmentRoot root) {
        if (root != null) {
            IJavaProject jp = root.getJavaProject();
            ICDIProject cdi = NewCDIAnnotationWizardPage.getCDIProject(jp);
            if (cdi != null) {
                this.setScopes(cdi.getScopeNames().toArray(new String[0]));
            } else {
                this.setScopes(new String[]{""});
            }
        } else {
            this.setScopes(new String[]{""});
        }
    }

    void setScopes(String[] tags) {
        this.scopes.clear();
        this.scopes.put("", "");
        String[] stringArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            if (tag.length() != 0) {
                int i = tag.lastIndexOf(46);
                String name = "@" + tag.substring(i + 1);
                this.scopes.put(name, tag);
            }
            ++n2;
        }
        if (this.scope != null) {
            this.scope.setTags(this.scopes.keySet().toArray(new String[0]));
            this.scope.setValue((Object)"");
        }
    }

    void setQualifiers(IPackageFragmentRoot root) {
        IJavaProject jp;
        ICDIProject cdi;
        this.qualifiersProvider.setProject(null);
        if (root != null && (cdi = CDICorePlugin.getCDIProject((IProject)(jp = root.getJavaProject()).getProject(), (boolean)true)) != null) {
            this.qualifiersProvider.setProject(cdi);
        }
    }

    protected void createQualifiersField(Composite composite) {
        this.qualifiers = new ListFieldEditor("qualifiers", CDIUIMessages.FIELD_EDITOR_QUALIFIER_LABEL, new ArrayList());
        this.qualifiers.setProvider((ListFieldEditor.ListFieldEditorProvider)this.qualifiersProvider);
        this.qualifiersProvider.setEditorField((IFieldEditor)this.qualifiers);
        this.qualifiers.doFillIntoGrid((Object)composite);
        this.setQualifiers(this.getPackageFragmentRoot());
        this.qualifiers.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
            }
        });
        Object data = this.qualifiers.getLabelControl().getLayoutData();
        if (data instanceof GridData) {
            GridData d = (GridData)data;
            d.verticalAlignment = 1;
            this.qualifiers.getLabelControl().setData((Object)d);
        }
    }

    public void addQualifier(IQualifier s) {
        List vs = (List)this.qualifiers.getValue();
        ArrayList<IQualifier> nvs = new ArrayList<IQualifier>();
        if (vs != null) {
            nvs.addAll(vs);
        }
        nvs.add(s);
        this.qualifiers.setValue(nvs);
    }

    public void setBeanName(String name) {
        this.isNamed.composite.setValue((Object)true);
        this.beanName.composite.setValue((Object)name);
    }

    protected void createBeanNameField(Composite composite) {
        this.isNamed = NewBeanWizardPage.createCheckBoxField(composite, "isNamed", "Add @Named", false);
        this.beanName = this.createTextField(composite, "name", "Bean Name:", "");
        this.beanName.composite.setEnabled(false);
        this.isNamed.checkBox.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean named = "true".equals(NewBeanWizardPage.this.isNamed.checkBox.getValueAsString());
                NewBeanWizardPage.this.beanName.composite.setEnabled(named);
            }
        });
    }

    protected void createAlternativeField(Composite composite) {
        String label = "Add @Alternative";
        this.alternative = NewBeanWizardPage.createCheckBoxField(composite, "isAlternative", label, this.isAlternativeInitialValue);
        if (this.mayBeRegisteredInBeansXML) {
            this.alternative.checkBox.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    boolean isAlternative = "true".equals(NewBeanWizardPage.this.alternative.checkBox.getValueAsString());
                    NewBeanWizardPage.this.registerInBeansXML.setEnabled(isAlternative);
                }
            });
        }
    }

    protected void createRegisterInBeansXML(Composite composite) {
        if (!this.mayBeRegisteredInBeansXML) {
            return;
        }
        this.registerInBeansXML.create(composite, this.isAlternativeInitialValue);
        this.registerInBeansXML.setEnabled(this.isAlternativeInitialValue);
    }

    protected static CheckBoxEditorWrapper createCheckBoxField(Composite composite, String name, String label, boolean defaultValue) {
        CheckBoxEditorWrapper wrapper = new CheckBoxEditorWrapper();
        wrapper.checkBox = new CheckBoxFieldEditor(name, "", (Object)defaultValue);
        CompositeEditor editor = new CompositeEditor(name, "", (Object)defaultValue);
        editor.addFieldEditors(new IFieldEditor[]{new LabelFieldEditor(name, ""), wrapper.checkBox});
        wrapper.composite = editor;
        wrapper.composite.doFillIntoGrid((Object)composite);
        ((Button)wrapper.checkBox.getCheckBoxControl()).setText(label);
        return wrapper;
    }

    protected BeanNameEditorWrapper createTextField(Composite composite, String name, String label, String defaultValue) {
        BeanNameEditorWrapper wrapper = new BeanNameEditorWrapper();
        wrapper.text = new TextFieldEditor(name, "", defaultValue);
        CompositeEditor editor = new CompositeEditor(name, "", (Object)defaultValue);
        LabelFieldEditor l = new LabelFieldEditor(name, label);
        editor.addFieldEditors(new IFieldEditor[]{l, wrapper.text, new LabelFieldEditor(name, "")});
        wrapper.composite = editor;
        wrapper.composite.doFillIntoGrid((Object)composite);
        return wrapper;
    }

    protected void createScopeField(Composite composite) {
        ArrayList<String> values = new ArrayList<String>();
        values.add("");
        this.scope = this.createComboField("Scope", CDIUIMessages.FIELD_EDITOR_SCOPE_LABEL, composite, values);
        this.scope.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                NewBeanWizardPage.this.onScopeModified();
            }
        });
        this.setScopes(this.getPackageFragmentRoot());
    }

    void onScopeModified() {
        this.fSuperInterfacesStatus = this.superInterfacesChanged();
        this.computeScopeStatus();
        this.doStatusUpdate();
    }

    void computeScopeStatus() {
        ICDIProject cdi;
        IJavaProject jp;
        this.scopeStatus = new StatusInfo();
        if (this.scope.getValueAsString().length() == 0 && (jp = this.getJavaProject()) != null && (cdi = NewCDIAnnotationWizardPage.getCDIProject(jp)) != null && cdi.getNature().getBeanDiscoveryMode() == 2) {
            this.scopeStatus.setError(CDIUIMessages.SCOPE_SHOULD_BE_SET_IN_ARCHIVE_WITH_DISCOVERY_MODE_ANNOTATED);
        }
    }

    protected IStatus superInterfacesChanged() {
        StatusInfo result = (StatusInfo)super.superClassChanged();
        if (!(this.checkScopeAndSerializable() || result.isError() || result.isWarning() || this.checkScopeAndSerializable())) {
            result.setWarning(CDIUIMessages.MESSAGE_BEAN_SHOULD_BE_SERIALIZABLE);
        }
        return result;
    }

    boolean checkScopeAndSerializable() {
        if (this.scope == null) {
            return true;
        }
        IJavaProject jp = this.getJavaProject();
        if (jp == null) {
            return true;
        }
        boolean isPassivating = false;
        String scopeName = this.scope.getValueAsString();
        String qScopeName = this.scopes.get(scopeName);
        if ("javax.enterprise.context.SessionScoped".equals(qScopeName)) {
            isPassivating = true;
        } else {
            IScope s;
            ICDIProject cdi = NewCDIAnnotationWizardPage.getCDIProject(jp);
            if (cdi != null && (s = cdi.getScope(qScopeName)) != null && s.isNorlmalScope() && cdi.isPassivatingScope(s.getSourceType())) {
                isPassivating = true;
            }
        }
        if (isPassivating) {
            boolean result = false;
            List list = this.getSuperInterfaces();
            if (list != null) {
                int i = 0;
                while (i < list.size() && !result) {
                    if ("java.io.Serializable".equals(list.get(i).toString())) {
                        result = true;
                    }
                    ++i;
                }
            }
            return result;
        }
        return true;
    }

    protected ITaggedFieldEditor createComboField(String name, String label, Composite composite, List<String> values) {
        ITaggedFieldEditor result = IFieldEditorFactory.INSTANCE.createComboEditor(name, label, values, (Object)values.get(0));
        ((CompositeEditor)result).addFieldEditors(new IFieldEditor[]{new LabelFieldEditor(name, "")});
        result.doFillIntoGrid((Object)composite);
        Combo combo = (Combo)result.getEditorControls()[1];
        Object layoutData = combo.getLayoutData();
        if (layoutData instanceof GridData) {
            ((GridData)layoutData).horizontalAlignment = 4;
        }
        return result;
    }

    public void setAlternative(boolean value) {
        if (this.alternative != null) {
            this.alternative.composite.setValue((Object)value);
        } else {
            this.isAlternativeInitialValue = value;
        }
    }

    public boolean isToBeRegisteredInBeansXML() {
        if (this.registerInBeansXML != null && this.alternative != null) {
            return this.alternative.composite.getValue() == Boolean.TRUE && this.registerInBeansXML.isSelected();
        }
        return false;
    }

    public void setScope(String qScopeName) {
        String[] tags;
        String[] stringArray = tags = this.scope.getTags();
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            String n3 = this.scopes.get(t);
            if (qScopeName.equals(n3)) {
                this.scope.setValue((Object)t);
                this.doStatusUpdate();
                return;
            }
            ++n2;
        }
    }

    protected IStatus packageChanged() {
        IStatus result = super.packageChanged();
        this.registerInBeansXML.validate();
        return result;
    }

    protected IStatus typeNameChanged() {
        IStatus result = super.typeNameChanged();
        this.registerInBeansXML.validate();
        return result;
    }

    protected static class BeanNameEditorWrapper {
        protected IFieldEditor composite = null;
        protected TextFieldEditor text = null;

        protected BeanNameEditorWrapper() {
        }
    }
}

