/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.search;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.Signature;
import org.jboss.tools.cdi.core.CDIUtil;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.ICDIElement;
import org.jboss.tools.cdi.core.IInitializerMethod;
import org.jboss.tools.cdi.core.IInjectionPointField;
import org.jboss.tools.cdi.core.IInjectionPointParameter;
import org.jboss.tools.cdi.core.IObserverMethod;

public class CDIElementWrapper {
    private static String SPACE = " ";
    private static String DOT = ".";
    private static String OPEN = "(";
    private static String CLOSE = ")";
    private static String BRACKETS = String.valueOf(OPEN) + CLOSE;
    private ICDIElement element;
    private String label;
    private String path;
    private IJavaElement javaElement;

    public CDIElementWrapper(ICDIElement element) {
        this.element = element;
        if (element instanceof IBean) {
            this.javaElement = ((IBean)element).getBeanClass();
            this.label = this.javaElement.getElementName();
        } else if (element instanceof IObserverMethod) {
            this.javaElement = ((IObserverMethod)element).getMethod();
            this.label = String.valueOf(((IObserverMethod)element).getMethod().getDeclaringType().getElementName()) + DOT + ((IObserverMethod)element).getMethod().getElementName() + BRACKETS;
        } else if (element instanceof IInjectionPointField) {
            this.javaElement = ((IInjectionPointField)element).getField();
            this.label = String.valueOf(((IInjectionPointField)element).getField().getDeclaringType().getElementName()) + DOT + ((IInjectionPointField)element).getField().getElementName();
        } else if (element instanceof IInitializerMethod) {
            this.javaElement = ((IInitializerMethod)element).getMethod();
            this.label = String.valueOf(((IInitializerMethod)element).getMethod().getDeclaringType().getElementName()) + DOT + ((IInitializerMethod)element).getMethod().getElementName() + BRACKETS;
        } else if (element instanceof IInjectionPointParameter) {
            IMethod method = ((IInjectionPointParameter)element).getBeanMethod().getMethod();
            this.javaElement = CDIUtil.getParameter((IMethod)method, (String)((IInjectionPointParameter)element).getName());
            String type = Signature.getSignatureSimpleName((String)((ILocalVariable)this.javaElement).getTypeSignature());
            this.label = String.valueOf(method.getDeclaringType().getElementName()) + DOT + method.getElementName() + OPEN + type + SPACE + this.javaElement.getElementName() + CLOSE;
        }
        this.path = this.javaElement.getResource() != null ? this.javaElement.getResource().getFullPath() + "/" + this.label : "/" + this.label;
    }

    public ICDIElement getCDIElement() {
        return this.element;
    }

    public IJavaElement getJavaElement() {
        return this.javaElement;
    }

    public String getLabel() {
        return this.label;
    }

    public String getPath() {
        return this.path;
    }
}

