/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.marker;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.jboss.tools.cdi.core.CDIImages;
import org.jboss.tools.cdi.internal.core.refactoring.CDIMarkerResolutionUtils;
import org.jboss.tools.cdi.ui.CDIUIMessages;
import org.jboss.tools.cdi.ui.CDIUIPlugin;
import org.jboss.tools.common.refactoring.BaseMarkerResolution;

public class MakeMethodPublicMarkerResolution
extends BaseMarkerResolution {
    private IMethod method;

    public MakeMethodPublicMarkerResolution(IMethod method) {
        super(CDIMarkerResolutionUtils.getJavaMember((IJavaElement)method).getCompilationUnit());
        this.label = MessageFormat.format(CDIUIMessages.MAKE_METHOD_PUBLIC_MARKER_RESOLUTION_TITLE, method.getElementName());
        this.method = method;
        this.init();
    }

    protected CompilationUnitChange getChange(ICompilationUnit compilationUnit) {
        CompilationUnitChange change = new CompilationUnitChange("", compilationUnit);
        MultiTextEdit edit = new MultiTextEdit();
        change.setEdit((TextEdit)edit);
        try {
            IBuffer buffer = compilationUnit.getBuffer();
            IMethod workingCopyMethod = (IMethod)CDIMarkerResolutionUtils.findWorkingCopy((ICompilationUnit)compilationUnit, (IJavaElement)this.method);
            if (workingCopyMethod != null) {
                int flag = workingCopyMethod.getFlags();
                String text = buffer.getText(workingCopyMethod.getSourceRange().getOffset(), workingCopyMethod.getSourceRange().getLength());
                int position = workingCopyMethod.getSourceRange().getOffset();
                if (!Flags.isPublic((int)flag)) {
                    if (Flags.isPrivate((int)flag)) {
                        ReplaceEdit re = new ReplaceEdit(position += text.indexOf("private"), "private".length(), "public");
                        edit.addChild((TextEdit)re);
                    } else if (Flags.isProtected((int)flag)) {
                        ReplaceEdit re = new ReplaceEdit(position += text.indexOf("protected"), "protected".length(), "public");
                        edit.addChild((TextEdit)re);
                    } else {
                        String type = Signature.getSignatureSimpleName((String)workingCopyMethod.getReturnType());
                        InsertEdit ie = new InsertEdit(position += text.indexOf(type), "public ");
                        edit.addChild((TextEdit)ie);
                    }
                }
            }
        }
        catch (CoreException ex) {
            CDIUIPlugin.getDefault().logError(ex);
        }
        return change;
    }

    public Image getImage() {
        return CDIImages.getImage((ImageDescriptor)CDIImages.QUICKFIX_EDIT);
    }
}

