/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.marker;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.cdi.core.CDIImages;
import org.jboss.tools.cdi.internal.core.refactoring.CDIMarkerResolutionUtils;
import org.jboss.tools.cdi.ui.CDIUIMessages;
import org.jboss.tools.cdi.ui.wizard.NewBeanCreationWizard;
import org.jboss.tools.cdi.ui.wizard.NewCDIElementWizard;
import org.jboss.tools.cdi.ui.wizard.NewDecoratorCreationWizard;
import org.jboss.tools.cdi.ui.wizard.NewInterceptorCreationWizard;
import org.jboss.tools.cdi.ui.wizard.NewStereotypeCreationWizard;
import org.jboss.tools.common.model.ui.wizards.NewTypeWizardAdapter;
import org.jboss.tools.common.quickfix.IQuickFix;
import org.jboss.tools.common.refactoring.TestableResolutionWithDialog;

public class CreateCDIElementMarkerResolution
implements IQuickFix,
TestableResolutionWithDialog {
    private static final String OBJECT = "java.lang.Object";
    public static final int CREATE_BEAN_CLASS = 1;
    public static final int CREATE_STEREOTYPE = 2;
    public static final int CREATE_INTERCEPTOR = 3;
    public static final int CREATE_DECORATOR = 4;
    private IProject project;
    private String qualifiedName;
    private int id;

    public CreateCDIElementMarkerResolution(IProject project, String text, int id) {
        this.project = project;
        this.qualifiedName = text;
        this.id = id;
    }

    public String getLabel() {
        switch (this.id) {
            case 1: {
                return NLS.bind((String)CDIUIMessages.CREATE_BEAN_CLASS_TITLE, (Object)this.qualifiedName);
            }
            case 2: {
                return NLS.bind((String)CDIUIMessages.CREATE_STEREOTYPE_TITLE, (Object)this.qualifiedName);
            }
            case 4: {
                return NLS.bind((String)CDIUIMessages.CREATE_DECORATOR_TITLE, (Object)this.qualifiedName);
            }
            case 3: {
                return NLS.bind((String)CDIUIMessages.CREATE_INTERCEPTOR_TITLE, (Object)this.qualifiedName);
            }
        }
        return "";
    }

    public void run(IMarker marker) {
        this.internal_run(false);
    }

    public void runForTest(IMarker marker) {
        this.internal_run(true);
    }

    private void internal_run(boolean test) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        NewCDIElementWizard wizard = null;
        switch (this.id) {
            case 1: {
                wizard = new NewBeanCreationWizard();
                break;
            }
            case 2: {
                wizard = new NewStereotypeCreationWizard();
                break;
            }
            case 4: {
                wizard = new NewDecoratorCreationWizard();
                break;
            }
            case 3: {
                wizard = new NewInterceptorCreationWizard();
                break;
            }
            default: {
                return;
            }
        }
        NewTypeWizardAdapter adapter = new NewTypeWizardAdapter(this.project);
        adapter.setRawPackageName(CDIMarkerResolutionUtils.getPackageName((String)this.qualifiedName));
        adapter.setRawClassName(this.qualifiedName);
        adapter.setRawSuperClassName(OBJECT);
        wizard.setAdapter(adapter);
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection(new Object[0]));
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        if (test) {
            dialog.setBlockOnOpen(false);
        }
        dialog.open();
        if (test) {
            wizard.performFinish();
            dialog.close();
        }
    }

    public String getDescription() {
        return this.getLabel();
    }

    public Image getImage() {
        return CDIImages.getImage((ImageDescriptor)CDIImages.QUICKFIX_EDIT);
    }

    public int getRelevance() {
        return 100;
    }

    public void apply(IDocument document) {
        this.internal_run(false);
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return this.getLabel();
    }

    public String getDisplayString() {
        return this.getLabel();
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

