/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.common.core.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.eclipse.core.runtime.Assert;
import org.jboss.tools.openshift.common.core.utils.StringUtils;

public class X509CertificateParser {
    private static final String HEX_CHARS = new String("0123456789ABCDEF");
    private String issuer;
    private String validity;
    private String fingerprint;

    public X509CertificateParser(X509Certificate certificate) {
        Assert.isLegal((certificate != null ? 1 : 0) != 0);
        this.issuer = this.getIssuer(certificate);
        this.validity = this.getValidity(certificate);
        this.fingerprint = this.getFingerprint(certificate);
    }

    public String getValidity() {
        return this.validity;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    private String getIssuer(X509Certificate certificate) {
        try {
            StringBuilder builder = new StringBuilder();
            LdapName ldapDN = new LdapName(certificate.getSubjectX500Principal().getName());
            for (Rdn rdn : ldapDN.getRdns()) {
                String type = this.getTypeFullName(rdn.getType());
                if (StringUtils.isEmpty(type)) {
                    builder.append("Serial Number: ").append(this.toHexString(rdn.getValue().toString().getBytes()));
                    continue;
                }
                builder.append(type).append(": ").append(rdn.getValue()).append('\n');
            }
            return builder.toString();
        }
        catch (InvalidNameException invalidNameException) {
            return "<Could not determine certificate issuer>";
        }
    }

    private String getValidity(X509Certificate certificate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("E, d MMM yyyy HH:mm:ss");
        return "Issued On: " + dateFormat.format(certificate.getNotBefore()) + '\n' + "Expires On: " + dateFormat.format(certificate.getNotAfter());
    }

    private String getFingerprint(X509Certificate certificate) {
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            sha1.update(certificate.getEncoded());
            return this.toHexString(sha1.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return "<Could not determine fingerprint>";
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return "<Could not determine fingerprint>";
        }
    }

    private String toHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        int j = 0;
        while (j < bytes.length) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2 + 0] = HEX_CHARS.charAt((v & 0xF0) >> 4);
            hexChars[j * 2 + 1] = HEX_CHARS.charAt(v & 0xF);
            ++j;
        }
        return new String(hexChars);
    }

    private String getTypeFullName(String type) {
        if ("C".equals(type)) {
            return "Country (C)";
        }
        if ("ST".equals(type)) {
            return "State (ST)";
        }
        if ("CN".equals(type)) {
            return "Common Name (CN)";
        }
        if ("O".equals(type)) {
            return "Organization (O)";
        }
        if ("OU".equals(type)) {
            return "Organizational Unit (OU)";
        }
        return null;
    }
}

