/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.common.core.connection;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.common.core.utils.UrlUtils;
import org.jboss.tools.openshift.internal.common.core.OpenShiftCommonCoreActivator;

public class ConnectionURL {
    private static final Pattern MALFORMED_URL_PATTERN = Pattern.compile("(https?://)?([^@]+)?@(https?://)?(.*)");
    private String username;
    private String host;
    private String scheme;
    private String url;

    private ConnectionURL(String username, String host, String scheme) throws UnsupportedEncodingException {
        this.username = username;
        this.host = host;
        this.scheme = scheme;
        this.url = UrlUtils.getUrlFor(username, host, scheme);
    }

    public String getUsername() {
        return this.username;
    }

    public String getHost() {
        return this.host;
    }

    public String getHostWithScheme() {
        if (this.isDefaultHost()) {
            return null;
        }
        return String.valueOf(this.scheme) + this.host;
    }

    public boolean isDefaultHost() {
        return StringUtils.isEmpty(this.host);
    }

    public String getScheme() {
        return this.scheme;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionURL other = (ConnectionURL)obj;
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }

    public String toString() {
        return this.url;
    }

    public String getUrl() {
        return this.url;
    }

    public static ConnectionURL forUsername(String username) throws UnsupportedEncodingException, MalformedURLException {
        if (StringUtils.isEmpty(username)) {
            throw new IllegalArgumentException("Username is empty");
        }
        return new ConnectionURL(username, null, "https://");
    }

    public static ConnectionURL forHost(String host) {
        return ConnectionURL.forHost(host);
    }

    public static ConnectionURL forUsernameAndHost(String username, String host) throws UnsupportedEncodingException, MalformedURLException {
        if (StringUtils.isEmpty(username)) {
            throw new IllegalArgumentException("Username is empty");
        }
        if (StringUtils.isEmpty(host)) {
            throw new IllegalArgumentException("Host is empty");
        }
        UrlUtils.UrlPortions portions = UrlUtils.toPortions(host);
        return new ConnectionURL(username, portions.getHost(), portions.getScheme());
    }

    public static ConnectionURL forConnection(IConnection connection) throws UnsupportedEncodingException, MalformedURLException {
        if (connection.isDefaultHost()) {
            return ConnectionURL.forUsername(connection.getUsername());
        }
        String host = ConnectionURL.getHost(connection);
        String scheme = ConnectionURL.getScheme(connection);
        String username = connection.getUsername();
        return new ConnectionURL(username, host, scheme);
    }

    public static ConnectionURL safeForConnection(IConnection connection) {
        try {
            return ConnectionURL.forConnection(connection);
        }
        catch (MalformedURLException e) {
            OpenShiftCommonCoreActivator.pluginLog().logError(NLS.bind((String)"Unable to getConnectionURL for connection {0}@{1}", (Object)connection.getUsername(), (Object)connection.getHost()), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            OpenShiftCommonCoreActivator.pluginLog().logError(NLS.bind((String)"Unable to getConnectionURL for connection {0}@{1}", (Object)connection.getUsername(), (Object)connection.getHost()), (Throwable)e);
        }
        return null;
    }

    private static String getHost(IConnection connection) {
        if (connection.isDefaultHost()) {
            return null;
        }
        return UrlUtils.cutScheme(connection.getHost());
    }

    private static String getScheme(IConnection connection) {
        String scheme = connection.getScheme();
        if (scheme == null) {
            scheme = "https://";
        }
        return scheme;
    }

    public static ConnectionURL forURL(String url) throws UnsupportedEncodingException, MalformedURLException {
        return ConnectionURL.forURL(new URL(ConnectionURL.correctMalformedUrl(url)));
    }

    public static ConnectionURL forURL(URL url) throws UnsupportedEncodingException {
        Assert.isLegal((url != null ? 1 : 0) != 0, (String)"url is null");
        UrlUtils.UrlPortions portions = UrlUtils.toPortions(url);
        String host = ConnectionURL.getHost(portions);
        return new ConnectionURL(portions.getUsername(), host, portions.getScheme());
    }

    private static String getHost(UrlUtils.UrlPortions portions) {
        String host = portions.getHost();
        if (StringUtils.isEmpty(host)) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(portions.getHost());
        if (portions.getPort() > -1) {
            builder.append(':').append(portions.getPort());
        }
        return builder.toString();
    }

    private static String correctMalformedUrl(String url) {
        Matcher matcher = MALFORMED_URL_PATTERN.matcher(url);
        if (!matcher.matches() || matcher.groupCount() != 4) {
            return url;
        }
        if (!StringUtils.isEmpty(matcher.group(1))) {
            return url;
        }
        if (StringUtils.isEmpty(matcher.group(4)) && !StringUtils.isEmpty(matcher.group(3))) {
            return matcher.group(3) + matcher.group(2) + '@';
        }
        if (!StringUtils.isEmpty(matcher.group(3))) {
            return matcher.group(3) + matcher.group(2) + '@' + matcher.group(4);
        }
        return url;
    }
}

