/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.central.internal.dnd;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDescriptor;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDiscovery;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryConnector;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.jboss.tools.central.JBossCentralActivator;
import org.jboss.tools.central.internal.dnd.LinuxURLTransfer;
import org.jboss.tools.discovery.core.internal.connectors.DiscoveryUtil;
import org.jboss.tools.discovery.core.internal.connectors.JBossDiscoveryUi;

public class JBossCentralDropTarget {
    public static final String JBOSS_DROP_TARGET = "jbossDropTarget";
    public static final String JBOSS_DROP_TARGET_ID = "jdt";
    private static final String DOWNLOAD_JBOSS_ORG_JBOSSTOOLS_CENTRAL_INSTALL_CONNECTORS = "http://download.jboss.org/jbosstools/central/install?connectors=";
    private static final String LEGACY_DEVSTUDIO_JBOSS_COM_CENTRAL_INSTALL_CONNECTORS = "https://devstudio.jboss.com/central/install?connectors=";
    private static final String DEVSTUDIO_REDHAT_COM_CENTRAL_INSTALL_CONNECTORS = "https://devstudio.redhat.com/central/install?connectors=";
    private DropTargetListener listener = new DropTargetAdapter(){

        public void dragEnter(DropTargetEvent e) {
            if (e.detail == 0) {
                e.detail = 4;
            }
        }

        public void dragOperationChanged(DropTargetEvent e) {
            if (e.detail == 0) {
                e.detail = 4;
            }
        }

        public void drop(DropTargetEvent event) {
            if (event.data == null) {
                event.detail = 0;
                return;
            }
            String url = this.getUrlFromEvent(event);
            if (url != null) {
                url = url.trim();
                final String[] connectorIds = new String[1];
                if (url.startsWith(JBossCentralDropTarget.DOWNLOAD_JBOSS_ORG_JBOSSTOOLS_CENTRAL_INSTALL_CONNECTORS)) {
                    connectorIds[0] = url.replace(JBossCentralDropTarget.DOWNLOAD_JBOSS_ORG_JBOSSTOOLS_CENTRAL_INSTALL_CONNECTORS, "");
                } else if (url.startsWith(JBossCentralDropTarget.DEVSTUDIO_REDHAT_COM_CENTRAL_INSTALL_CONNECTORS)) {
                    connectorIds[0] = url.replace(JBossCentralDropTarget.DEVSTUDIO_REDHAT_COM_CENTRAL_INSTALL_CONNECTORS, "");
                } else if (url.startsWith(JBossCentralDropTarget.LEGACY_DEVSTUDIO_JBOSS_COM_CENTRAL_INSTALL_CONNECTORS)) {
                    connectorIds[0] = url.replace(JBossCentralDropTarget.LEGACY_DEVSTUDIO_JBOSS_COM_CENTRAL_INSTALL_CONNECTORS, "");
                }
                if (connectorIds[0] != null && !connectorIds[0].trim().isEmpty()) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            JBossCentralDropTarget.this.dropConnectors(connectorIds[0]);
                        }
                    });
                } else if (event.data instanceof String) {
                    String[] urls;
                    String[] stringArray = urls = ((String)event.data).split(System.getProperty("line.separator"));
                    int n = urls.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String file;
                        String fn = stringArray[n2];
                        try {
                            URL u = new URL(fn);
                            file = u.getFile();
                        }
                        catch (MalformedURLException malformedURLException) {
                            file = fn;
                        }
                        if (new File(file).exists()) {
                            final IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(file));
                            Display.getCurrent().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                                    try {
                                        IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                                    }
                                    catch (PartInitException partInitException) {}
                                }
                            });
                        }
                        ++n2;
                    }
                }
            }
        }

        private String getUrlFromEvent(DropTargetEvent event) {
            String eventData = (String)event.data;
            String[] dataLines = eventData.split(System.getProperty("line.separator"));
            String url = dataLines[0];
            return url;
        }
    };

    public JBossCentralDropTarget(Control control) {
        DropTarget target = new DropTarget(control, 7);
        Transfer[] transfers = LinuxURLTransfer.isLinuxGTK() ? new Transfer[]{URLTransfer.getInstance(), LinuxURLTransfer.getInstance()} : new Transfer[]{URLTransfer.getInstance()};
        target.setTransfer(transfers);
        this.addListener(target);
    }

    public JBossCentralDropTarget(DropTarget target) {
        Transfer[] transfers;
        Assert.isNotNull((Object)target);
        Object object = target.getData(JBOSS_DROP_TARGET_ID);
        if (JBOSS_DROP_TARGET.equals(object)) {
            return;
        }
        boolean hasUrlTransfer = false;
        Transfer[] transferArray = transfers = target.getTransfer();
        int n = transfers.length;
        int n2 = 0;
        while (n2 < n) {
            Transfer transfer = transferArray[n2];
            if (transfer instanceof URLTransfer) {
                hasUrlTransfer = true;
                break;
            }
            ++n2;
        }
        Transfer[] newTransfers = null;
        if (!hasUrlTransfer) {
            if (LinuxURLTransfer.isLinuxGTK()) {
                newTransfers = new Transfer[transfers.length + 2];
                System.arraycopy(transfers, 0, newTransfers, 2, transfers.length);
                newTransfers[0] = URLTransfer.getInstance();
                newTransfers[1] = LinuxURLTransfer.getInstance();
            } else {
                newTransfers = new Transfer[transfers.length + 1];
                System.arraycopy(transfers, 0, newTransfers, 1, transfers.length);
                newTransfers[0] = URLTransfer.getInstance();
            }
        } else if (LinuxURLTransfer.isLinuxGTK()) {
            newTransfers = new Transfer[transfers.length + 1];
            System.arraycopy(transfers, 0, newTransfers, 1, transfers.length);
            newTransfers[1] = LinuxURLTransfer.getInstance();
        }
        if (newTransfers != null) {
            target.setTransfer(newTransfers);
        }
        this.addListener(target);
    }

    public void addListener(DropTarget target) {
        target.setData(JBOSS_DROP_TARGET_ID, (Object)JBOSS_DROP_TARGET);
        target.addDropListener(this.listener);
    }

    private void install(Set<String> connectorIds) throws InvocationTargetException, InterruptedException {
        if (connectorIds == null || connectorIds.isEmpty()) {
            JBossCentralActivator.log("No connectors selected for installation");
            return;
        }
        final IStatus[] results = new IStatus[1];
        final ConnectorDiscovery[] connectorDiscoveries = new ConnectorDiscovery[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                ConnectorDiscovery connectorDiscovery;
                connectorDiscoveries[0] = connectorDiscovery = DiscoveryUtil.createConnectorDiscovery();
                results[0] = connectorDiscoveries[0].performDiscovery(monitor);
                if (monitor.isCanceled()) {
                    results[0] = Status.CANCEL_STATUS;
                }
            }
        };
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        dialog.run(true, true, runnable);
        if (results[0] == null) {
            return;
        }
        if (results[0].isOK()) {
            boolean continueInstallation;
            List connectors = connectorDiscoveries[0].getConnectors();
            ArrayList<ConnectorDescriptor> installableConnectors = new ArrayList<ConnectorDescriptor>();
            ArrayList<String> notFoundConnectors = new ArrayList<String>(connectorIds);
            for (DiscoveryConnector connector : connectors) {
                if (!connectorIds.contains(connector.getId())) continue;
                installableConnectors.add((ConnectorDescriptor)connector);
                notFoundConnectors.remove(connector.getId());
            }
            Set installedFeatures = JBossDiscoveryUi.createInstallJob(installableConnectors).getInstalledFeatures((IProgressMonitor)new NullProgressMonitor());
            HashSet<ConnectorDescriptor> installedConnectors = new HashSet<ConnectorDescriptor>();
            Iterator iter = installableConnectors.iterator();
            while (iter.hasNext()) {
                ConnectorDescriptor connector = (ConnectorDescriptor)iter.next();
                connector.setInstalled(installedFeatures != null && installedFeatures.containsAll(connector.getInstallableUnits()));
                if (!connector.isInstalled()) continue;
                installedConnectors.add(connector);
                iter.remove();
            }
            StringBuilder buffer = new StringBuilder();
            if (!notFoundConnectors.isEmpty()) {
                buffer.append("The following connectors can not be found:\n");
                for (String id : notFoundConnectors) {
                    buffer.append(" - ");
                    buffer.append(id);
                    buffer.append("\n");
                }
                buffer.append("\n");
            }
            if (!installedConnectors.isEmpty()) {
                buffer.append("The following connectors are already installed:\n");
                this.formatConnectors(installedConnectors, buffer);
                buffer.append("\n");
            }
            boolean bl = continueInstallation = !installableConnectors.isEmpty();
            if (!buffer.toString().isEmpty()) {
                if (continueInstallation) {
                    buffer.append("Would you like to proceed with the installation of:\n");
                    this.formatConnectors(installableConnectors, buffer);
                    continueInstallation = MessageDialog.openQuestion((Shell)this.getShell(), (String)"Install New Software", (String)buffer.toString());
                } else {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)"Install New Software", (String)buffer.toString());
                }
            }
            if (continueInstallation) {
                JBossDiscoveryUi.install(installableConnectors, (IRunnableContext)dialog);
            }
        } else {
            String message = results[0].toString();
            switch (results[0].getSeverity()) {
                case 4: {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)message);
                    break;
                }
                case 2: {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)message);
                    break;
                }
                case 1: {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)"Information", (String)message);
                }
            }
        }
    }

    private void formatConnectors(Collection<ConnectorDescriptor> installedConnectors, StringBuilder buffer) {
        for (ConnectorDescriptor cd : installedConnectors) {
            buffer.append(" - ");
            buffer.append(cd.getId());
            buffer.append(" : ");
            buffer.append(cd.getName());
            buffer.append("\n");
        }
    }

    private Shell getShell() {
        return PlatformUI.getWorkbench().getModalDialogShellProvider().getShell();
    }

    private void dropConnectors(String connectorIds) {
        String[] ids = connectorIds.trim().split(",");
        if (ids != null && ids.length > 0) {
            HashSet<String> idSet = new HashSet<String>();
            String[] stringArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                if (!(id = id.trim()).isEmpty()) {
                    idSet.add(id);
                }
                ++n2;
            }
            if (!idSet.isEmpty()) {
                try {
                    this.install(idSet);
                }
                catch (InvocationTargetException e) {
                    JBossCentralActivator.log(e);
                }
                catch (InterruptedException e) {
                    JBossCentralActivator.log(e);
                }
            }
        }
    }
}

