/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.central.internal.browser;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.internal.part.StatusPart;
import org.jboss.tools.central.JBossCentralActivator;
import org.jboss.tools.central.Messages;
import org.jboss.tools.usage.event.UsageEventType;
import org.jboss.tools.usage.event.UsageReporter;

public class CentralBrowserErrorWrapper {
    public void showError(Composite parent, Throwable originalThrowable) {
        UsageEventType eventType = JBossCentralActivator.getDefault().getUsedBrowserEventType();
        UsageReporter.getInstance().trackEvent(eventType.event("N/A"));
        Throwable throwable = CentralBrowserErrorWrapper.wrapError(originalThrowable);
        String errorMessage = throwable.getMessage();
        parent.setLayout((Layout)new GridLayout());
        Composite statusComposite = new Composite(parent, 0);
        Color bgColor = parent.getDisplay().getSystemColor(25);
        Color fgColor = parent.getDisplay().getSystemColor(24);
        parent.setBackground(bgColor);
        parent.setForeground(fgColor);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 0;
        gridData.heightHint = 0;
        statusComposite.setLayoutData((Object)gridData);
        Status displayStatus = new Status(4, "org.jboss.tools.central", errorMessage, throwable);
        new StatusPart(statusComposite, (IStatus)displayStatus);
        final Link link = new Link(parent, 64);
        link.setLayoutData((Object)new GridData(128));
        link.setBackground(bgColor);
        link.setText("<a>" + Messages.visualEditorFaq + "</a>");
        link.setToolTipText(Messages.visualEditorFaqLink);
        link.setForeground(link.getDisplay().getSystemColor(9));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BusyIndicator.showWhile((Display)link.getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        JBossCentralActivator.openUrl(Messages.visualEditorFaqLink, Display.getDefault().getActiveShell(), true);
                    }
                });
            }
        });
        parent.getParent().layout(true, true);
    }

    private static Throwable wrapError(Throwable originalThrowable) {
        String message;
        if (originalThrowable instanceof SWTError && originalThrowable.getMessage() != null && (message = originalThrowable.getMessage()).contains("No more handles")) {
            return new Exception(Messages.noEngineError_message, originalThrowable);
        }
        return originalThrowable;
    }
}

