/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.central.internal;

import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.jboss.tools.central.internal.ImageUtil;
import org.jboss.tools.central.internal.discovery.wizards.ProxyWizard;
import org.jboss.tools.central.model.FeedsEntry;
import org.jboss.tools.project.examples.model.ProjectExample;

public class JsonUtil {
    private JsonUtil() {
    }

    public static String jsonifyWizards(Collection<ProxyWizard> proxyWizards) {
        StringBuilder json = new StringBuilder("[");
        if (proxyWizards != null) {
            boolean addComma = false;
            for (ProxyWizard pw : proxyWizards) {
                if (addComma) {
                    json.append(",");
                }
                addComma = true;
                json.append("{");
                JsonUtil.append("id", pw.getId(), json);
                JsonUtil.append("label", pw.getLabel(), json);
                JsonUtil.append("description", pw.getDescription(), json);
                String localIconUrl = "";
                try {
                    localIconUrl = ImageUtil.getImageAsLocalUrl(pw.getIconUrl().toString());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                JsonUtil.append("iconUrl", localIconUrl, json);
                json.append("}");
            }
        }
        json.append("]");
        return json.toString();
    }

    public static String jsonifyBuzz(Collection<FeedsEntry> buzzFeed) {
        StringBuilder json = new StringBuilder("[");
        if (buzzFeed != null) {
            boolean addComma = false;
            for (FeedsEntry feed : buzzFeed) {
                if (addComma) {
                    json.append(",");
                }
                addComma = true;
                json.append("{");
                JsonUtil.append("link", feed.getLink(), json);
                JsonUtil.append("description", feed.getTitle(), json);
                json.append("}");
            }
        }
        json.append("]");
        return json.toString();
    }

    private static void append(String key, Object value, StringBuilder json) {
        JsonUtil.quote(key, json).append(":");
        if (value instanceof Collection) {
            json.append("[");
            boolean addComma = false;
            for (Object o : (Collection)value) {
                if (addComma) {
                    json.append(",");
                }
                addComma = true;
                JsonUtil.quote(JsonUtil.sanitize(o), json);
            }
            json.append("]");
        } else {
            JsonUtil.quote(JsonUtil.sanitize(value), json).append(",");
        }
    }

    private static String sanitize(Object value) {
        return value == null ? "" : value.toString().replace("\n", "\\n");
    }

    private static StringBuilder quote(String value, StringBuilder json) {
        String quote = "\"";
        json.append(quote).append(value).append(quote);
        return json;
    }

    public static String jsonifyExamples(Collection<ProjectExample> examples) {
        StringBuilder json = new StringBuilder("[");
        if (examples != null) {
            boolean addComma = false;
            for (ProjectExample ex : examples) {
                if (addComma) {
                    json.append(",");
                }
                addComma = true;
                json.append("{");
                JsonUtil.append("id", ex.getId(), json);
                JsonUtil.append("label", ex.getName(), json);
                JsonUtil.append("title", ex.getHeadLine(), json);
                JsonUtil.append("description", ex.getDescription(), json);
                JsonUtil.append("tags", ex.getTags(), json);
                json.append("}");
            }
        }
        json.append("]");
        return json.toString();
    }
}

