/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.central.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.central.JBossCentralActivator;
import org.jboss.tools.central.configurators.IJBossCentralConfigurator;
import org.jboss.tools.central.internal.DefaultJBossCentralConfigurator;

public class CentralConfiguratorFactory {
    private static final String CONFIGURATORS_EXTENSION_ID = "org.jboss.tools.central.configurators";
    private static final Object CONFIGURATOR = "configurator";

    public static IJBossCentralConfigurator createConfigurator() {
        int n;
        int n2;
        IExtension[] iExtensionArray;
        IJBossCentralConfigurator configurator = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(CONFIGURATORS_EXTENSION_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions.length > 1) {
            iExtensionArray = extensions;
            n2 = extensions.length;
            n = 0;
            while (n < n2) {
                IExtension e = iExtensionArray[n];
                CentralConfiguratorFactory.logIgnoredExtensionPoint(e);
                ++n;
            }
        }
        if (extensions.length > 0) {
            iExtensionArray = extensions[0].getConfigurationElements();
            n2 = iExtensionArray.length;
            n = 0;
            while (n < n2) {
                IExtension configurationElement = iExtensionArray[n];
                if (CONFIGURATOR.equals(configurationElement.getName())) {
                    try {
                        configurator = (IJBossCentralConfigurator)configurationElement.createExecutableExtension("class");
                        break;
                    }
                    catch (CoreException e) {
                        JBossCentralActivator.log(e);
                    }
                }
                ++n;
            }
        }
        if (configurator == null) {
            configurator = new DefaultJBossCentralConfigurator();
        }
        return configurator;
    }

    private static void logIgnoredExtensionPoint(IExtension extension) {
        String className = null;
        IConfigurationElement[] configurationElements = extension.getConfigurationElements();
        int j = 0;
        while (j < configurationElements.length) {
            IConfigurationElement configurationElement = configurationElements[j];
            if (CONFIGURATOR.equals(configurationElement.getName())) {
                className = configurationElement.getAttribute("class");
            }
            ++j;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("The configurators extension point is ignored: classname=");
        builder.append(className);
        if (extension.getContributor() != null && extension.getContributor().getName() != null) {
            builder.append(",pluginId=");
            builder.append(extension.getContributor().getName());
        }
        JBossCentralActivator.log(builder.toString());
    }
}

