/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.central;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.browser.WebBrowserPreference;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.services.IServiceLocator;
import org.jboss.tools.central.Messages;
import org.jboss.tools.central.configurators.IJBossCentralConfigurator;
import org.jboss.tools.central.editors.JBossCentralEditor;
import org.jboss.tools.central.editors.JBossCentralEditorInput;
import org.jboss.tools.central.internal.CentralConfiguratorFactory;
import org.jboss.tools.central.internal.dnd.JBossCentralDropTarget;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.usage.event.UsageEventType;
import org.jboss.tools.usage.event.UsageReporter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.prefs.BackingStoreException;

public class JBossCentralActivator
extends AbstractUIPlugin {
    public static final Object JBOSS_CENTRAL_FAMILY = new Object();
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String CATEGORY = "category";
    public static final String PROJECT_EXAMPLE_TYPE = "projectExample";
    public static final String PLUGIN_ID = "org.jboss.tools.central";
    public static final String PROFILE_ID = "profileId";
    public static final String PROFILE_TIMESTAMP = "profileTimestamp";
    public static final String NEW_PROJECT_EXAMPLES_WIZARD_ID = "org.jboss.tools.project.examples.wizard.NewProjectExamplesWizard";
    public static final String FORM_END_TAG = "</p></form>";
    public static final String FORM_START_TAG = "<form><p>";
    public static final String CANCELED = "<form><p><span color=\"header\" font=\"header\">Cancelled.</span></p></form>";
    public static final String LOADING = "<form><p><span color=\"header\" font=\"header\">Loading...</span></p></form>";
    public static final String SEARCH_THE_COMMUNITY = "Search JBoss Community";
    public static final String SEARCH_RED_HAT_CUSTOMER_PORTAL = "Search Red Hat Customer Portal ";
    private BundleContext bundleContext;
    public static final int MAX_FEEDS = 100;
    private static final String ORG_ECLIPSE_UI_INTERNAL_INTROVIEW = "org.eclipse.ui.internal.introview";
    private static String CURRENT_VERSION;
    private static JBossCentralActivator plugin;
    private static Boolean isInternalWebBrowserAvailable;
    private IPerspectiveListener perspectiveListener = new PerspectiveAdapter(){

        public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            JBossCentralActivator.this.fixEditors(page);
        }
    };
    private IWorkbenchListener workbenchListener = new IWorkbenchListener(){

        public boolean preShutdown(IWorkbench workbench, boolean forced) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IEditorReference[] references = page.getEditorReferences();
                    if (references != null) {
                        JBossCentralActivator.this.fixEditors(page);
                    }
                }
            });
            return true;
        }

        public void postShutdown(IWorkbench workbench) {
        }
    };
    private IJBossCentralConfigurator configurator;
    private UsageEventType usedBrowserEventType;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.bundleContext = context;
        plugin = this;
        PlatformUI.getWorkbench().addWorkbenchListener(this.workbenchListener);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().addPerspectiveListener(JBossCentralActivator.this.perspectiveListener);
            }
        });
        PlatformUI.getWorkbench().addWindowListener(new IWindowListener(){

            public void windowOpened(IWorkbenchWindow window) {
                window.addPerspectiveListener(JBossCentralActivator.this.perspectiveListener);
            }

            public void windowDeactivated(IWorkbenchWindow window) {
            }

            public void windowClosed(IWorkbenchWindow window) {
                window.removePerspectiveListener(JBossCentralActivator.this.perspectiveListener);
            }

            public void windowActivated(IWorkbenchWindow window) {
            }
        });
        this.usedBrowserEventType = new UsageEventType((Plugin)this, "browser", Messages.usageEventBrowserLabelDescription);
        UsageReporter.getInstance().registerEvent(this.usedBrowserEventType);
    }

    public UsageEventType getUsedBrowserEventType() {
        return this.usedBrowserEventType;
    }

    public void stop(BundleContext context) throws Exception {
        PlatformUI.getWorkbench().removeWorkbenchListener(this.workbenchListener);
        if (!PlatformUI.getWorkbench().isClosing()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().removePerspectiveListener(JBossCentralActivator.this.perspectiveListener);
                }
            });
        }
        Job.getJobManager().cancel(JBOSS_CENTRAL_FAMILY);
        Job.getJobManager().join(JBOSS_CENTRAL_FAMILY, (IProgressMonitor)new NullProgressMonitor());
        this.configurator = null;
        plugin = null;
        this.bundleContext = null;
        super.stop(context);
    }

    public static JBossCentralActivator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return JBossCentralActivator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public IEclipsePreferences getPreferences() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        return prefs;
    }

    public void savePreferences() {
        IEclipsePreferences prefs = this.getPreferences();
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            JBossCentralActivator.log(e);
        }
    }

    public static void log(Throwable e, String message) {
        Status status = new Status(4, PLUGIN_ID, message, e);
        plugin.getLog().log((IStatus)status);
    }

    public static void log(Throwable e) {
        Status status = new Status(4, PLUGIN_ID, e.getLocalizedMessage(), e);
        plugin.getLog().log((IStatus)status);
    }

    public static void log(String message) {
        Status status = new Status(4, PLUGIN_ID, message);
        plugin.getLog().log((IStatus)status);
    }

    public static void logWarning(String message) {
        Status status = new Status(2, PLUGIN_ID, message);
        plugin.getLog().log((IStatus)status);
    }

    public boolean showJBossCentralOnStartup() {
        IEclipsePreferences prefs = JBossCentralActivator.getDefault().getPreferences();
        return prefs.getBoolean("showJBossCentralOnStartup", true);
    }

    public static void openUrl(String location, Shell shell) {
        JBossCentralActivator.openUrl(location, shell, false);
    }

    public static void openUrl(String location, Shell shell, boolean asExternal) {
        URL url = null;
        try {
            if (location != null) {
                url = new URL(location);
            }
            if (WebBrowserPreference.getBrowserChoice() == 1 || asExternal) {
                IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                support.getExternalBrowser().openURL(url);
            } else {
                IWebBrowser browser = null;
                int flags = WorkbenchBrowserSupport.getInstance().isInternalWebBrowserAvailable() ? 38 : 134;
                String generatedId = PLUGIN_ID + System.currentTimeMillis();
                browser = WorkbenchBrowserSupport.getInstance().createBrowser(flags, generatedId, null, null);
                browser.openURL(url);
            }
        }
        catch (PartInitException partInitException) {
            Status status = new Status(4, PLUGIN_ID, "Browser initialization failed");
            JBossCentralActivator.getDefault().getLog().log((IStatus)status);
            MessageDialog.openError((Shell)shell, (String)"Open Location", (String)status.getMessage());
        }
        catch (MalformedURLException malformedURLException) {
            Status status = new Status(4, PLUGIN_ID, "Invalid URL");
            JBossCentralActivator.getDefault().getLog().log((IStatus)status);
            MessageDialog.openError((Shell)shell, (String)"Open Location", (String)status.getMessage());
        }
    }

    public Image getImage(ImageDescriptor imageDescriptor) {
        String id;
        ImageRegistry imageRegistry = this.getImageRegistry();
        Image image = imageRegistry.get(id = this.getImageId(imageDescriptor));
        if (image == null) {
            image = imageDescriptor.createImage(true);
            imageRegistry.put(id, image);
        }
        return image;
    }

    private String getImageId(ImageDescriptor imageDescriptor) {
        return "org.jboss.tools.central/" + imageDescriptor.hashCode();
    }

    public static CommandContributionItem createContributionItem(IServiceLocator serviceLocator, String commandId) {
        CommandContributionItemParameter parameter = new CommandContributionItemParameter(serviceLocator, commandId, commandId, 8);
        return new CommandContributionItem(parameter);
    }

    public static JBossCentralEditor getJBossCentralEditor(boolean activate) {
        final WorkbenchWindow window = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        final IWorkbenchPage page = window.getActivePage();
        if (activate) {
            return JBossCentralActivator.openJBossCentralEditor(page);
        }
        if (page.findView(ORG_ECLIPSE_UI_INTERNAL_INTROVIEW) != null && !window.getCoolBarVisible() && !window.getPerspectiveBarVisible()) {
            IViewReference viewRef = page.findViewReference(ORG_ECLIPSE_UI_INTERNAL_INTROVIEW);
            if (page.getPartState((IWorkbenchPartReference)viewRef) != 1) {
                return JBossCentralActivator.openJBossCentralEditor(page);
            }
        } else {
            return JBossCentralActivator.openJBossCentralEditor(page);
        }
        window.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                Object newValue;
                String property = event.getProperty();
                if (("coolbarVisible".equals(property) || "coolbarVisible".equals(property)) && (newValue = event.getNewValue()) instanceof Boolean && ((Boolean)newValue).booleanValue()) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            JBossCentralActivator.openJBossCentralEditor(page);
                        }
                    });
                    window.removePropertyChangeListener((IPropertyChangeListener)this);
                }
            }
        });
        return null;
    }

    protected static JBossCentralEditor openJBossCentralEditor(IWorkbenchPage page) {
        if (!PlatformUI.isWorkbenchRunning() || PlatformUI.getWorkbench().isClosing()) {
            return null;
        }
        JBossCentralEditorInput input = JBossCentralEditorInput.INSTANCE;
        try {
            IEditorPart editor = page.openEditor((IEditorInput)input, "org.jboss.tools.central.editors.JBossCentralEditor");
            if (editor instanceof JBossCentralEditor) {
                return (JBossCentralEditor)editor;
            }
        }
        catch (PartInitException e) {
            JBossCentralActivator.log(e);
        }
        return null;
    }

    public Image getImage(String imagePath) {
        ImageRegistry registry = this.getImageRegistry();
        Image image = registry.get(imagePath);
        if (image != null) {
            return image;
        }
        ImageDescriptor imageDescriptor = JBossCentralActivator.getImageDescriptor(imagePath);
        if (imageDescriptor == null) {
            JBossCentralActivator.logWarning(String.valueOf(imagePath) + " can not be found!");
            return null;
        }
        image = imageDescriptor.createImage();
        registry.put(imagePath, image);
        return image;
    }

    public String getDescription(ProjectExample project) {
        StringBuilder buffer = new StringBuilder();
        if (project.getDescription() != null) {
            buffer.append(project.getDescription());
        }
        buffer.append("\n\nSize: ");
        buffer.append(project.getSizeAsText());
        return buffer.toString();
    }

    public static Dictionary<Object, Object> getEnvironment() {
        Hashtable<Object, Object> environment = new Hashtable<Object, Object>(System.getProperties());
        Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
        Version version = bundle.getVersion();
        ((Dictionary)environment).put("org.jboss.tools.central.version", version.toString());
        ((Dictionary)environment).put("org.jboss.tools.central.version.major", version.getMajor());
        ((Dictionary)environment).put("org.jboss.tools.central.version.minor", version.getMinor());
        ((Dictionary)environment).put("org.jboss.tools.central.version.micro", version.getMicro());
        return environment;
    }

    public Object getService(String name) {
        if (this.bundleContext == null) {
            return null;
        }
        ServiceReference reference = this.bundleContext.getServiceReference(name);
        if (reference == null) {
            return null;
        }
        Object result = this.bundleContext.getService(reference);
        this.bundleContext.ungetService(reference);
        return result;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    private void fixEditors(IWorkbenchPage page) {
        IEditorReference[] references = page.getEditorReferences();
        if (references != null) {
            ArrayList<IEditorReference> l = new ArrayList<IEditorReference>();
            IEditorReference[] iEditorReferenceArray = references;
            int n = references.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference reference = iEditorReferenceArray[n2];
                String id = reference.getId();
                if ("org.jboss.tools.central.editors.JBossCentralEditor".equals(id) && reference.getEditor(false) == null || "org.eclipse.ui.internal.emptyEditorTab".equals(id)) {
                    l.add(reference);
                }
                ++n2;
            }
            if (!l.isEmpty()) {
                page.closeEditors(l.toArray(new IEditorReference[l.size()]), false);
            }
        }
    }

    public static boolean isInternalWebBrowserAvailable() {
        if (isInternalWebBrowserAvailable != null) {
            return isInternalWebBrowserAvailable;
        }
        Shell shell = null;
        try {
            shell = new Shell(PlatformUI.getWorkbench().getDisplay());
            new Browser((Composite)shell, 0);
            isInternalWebBrowserAvailable = (boolean)Boolean.TRUE;
            return true;
        }
        catch (Throwable throwable) {
            try {
                new Browser((Composite)shell, 65536);
                isInternalWebBrowserAvailable = (boolean)Boolean.TRUE;
                return true;
            }
            catch (Throwable throwable2) {
                isInternalWebBrowserAvailable = (boolean)Boolean.FALSE;
                return false;
            }
        }
        finally {
            if (shell != null) {
                shell.dispose();
            }
        }
    }

    public static void initDropTarget(Control control) {
        if (control == null) {
            return;
        }
        Object dropTarget = control.getData("DropTarget");
        if (dropTarget != null) {
            if (!(dropTarget instanceof DropTarget)) {
                JBossCentralActivator.log("Cannot initialize JBoss DND");
                return;
            }
            Object object = ((DropTarget)dropTarget).getData("jdt");
            if ("jbossDropTarget".equals(object)) {
                return;
            }
            new JBossCentralDropTarget((DropTarget)dropTarget);
            return;
        }
        new JBossCentralDropTarget(control);
    }

    public IJBossCentralConfigurator getConfigurator() {
        if (this.configurator == null) {
            this.configurator = CentralConfiguratorFactory.createConfigurator();
        }
        return this.configurator;
    }

    public static String getVersion() {
        if (CURRENT_VERSION == null) {
            String version = (String)JBossCentralActivator.getDefault().getBundle().getHeaders().get("Bundle-Version");
            CURRENT_VERSION = version.replace('-', '_');
        }
        return CURRENT_VERSION;
    }
}

