/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.feedhenry.ui.model;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.feedhenry.ui.internal.util.HttpUtil;
import org.jboss.tools.feedhenry.ui.model.FeedHenryApplication;
import org.jboss.tools.feedhenry.ui.model.FeedHenryException;
import org.jboss.tools.feedhenry.ui.model.FeedHenryProject;

public class FeedHenry {
    private URL fhURL;
    private String apikey;

    public FeedHenry setFeedHenryURL(URL url) {
        this.fhURL = url;
        return this;
    }

    public FeedHenry setAPIKey(String key) {
        this.apikey = key;
        return this;
    }

    public List<FeedHenryProject> listProjects(IProgressMonitor monitor) throws FeedHenryException {
        SubMonitor sm;
        String json;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((json = this.doGetAPICall("/box/api/projects", (IProgressMonitor)(sm = SubMonitor.convert((IProgressMonitor)monitor, (String)"Retrieve FeedHenry project list", (int)100)).newChild(50))) == null) {
            return null;
        }
        JsonValue value = JsonValue.readFrom((String)json);
        if (value.isArray()) {
            ArrayList<FeedHenryProject> projects = new ArrayList<FeedHenryProject>();
            JsonArray array = value.asArray();
            sm.setWorkRemaining(array.size());
            int i = 0;
            while (i < array.size()) {
                FeedHenryProject fhp = new FeedHenryProject();
                JsonObject project = array.get(i).asObject();
                fhp.setTitle(project.get("title").asString());
                fhp.setGuid(project.get("guid").asString());
                JsonArray apps = project.get("apps").asArray();
                ArrayList<FeedHenryApplication> fhapps = new ArrayList<FeedHenryApplication>();
                int j = 0;
                while (j < apps.size()) {
                    JsonObject app = apps.get(j).asObject();
                    FeedHenryApplication fha = new FeedHenryApplication();
                    fha.setTitle(app.get("title").asString());
                    fha.setType(app.get("type").asString());
                    fha.setRepoUrl(app.get("internallyHostedRepoUrl").asString());
                    fha.setGuid(app.get("guid").asString());
                    fhapps.add(fha);
                    ++j;
                }
                fhp.setApplications(fhapps);
                projects.add(fhp);
                sm.worked(1);
                ++i;
            }
            return projects;
        }
        return null;
    }

    public FeedHenryApplication importBareRepo(String projectId, String appTitle, String appTemplateType, IProgressMonitor monitor) throws FeedHenryException {
        String url = "box/api/projects/" + projectId + "/apps";
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)"Create FeedHenry Project", (int)100);
        JsonObject payload = new JsonObject();
        payload.add("title", appTitle);
        payload.add("connections", (JsonValue)new JsonArray());
        JsonObject template = new JsonObject();
        template.add("type", appTemplateType);
        template.add("initaliseRepo", false);
        payload.add("template", (JsonValue)template);
        sm.worked(10);
        String response = this.doPostAPICall(url, payload.toString(), (IProgressMonitor)sm.newChild(70));
        JsonValue value = JsonValue.readFrom((String)response);
        sm.worked(25);
        FeedHenryApplication fha = new FeedHenryApplication();
        JsonObject object = value.asObject();
        fha.setTitle(object.get("title").asString());
        fha.setType(object.get("type").asString());
        fha.setRepoUrl(object.get("internallyHostedRepoUrl").asString());
        fha.setGuid(object.get("guid").asString());
        sm.worked(5);
        return fha;
    }

    private String doPostAPICall(String api, String payload, IProgressMonitor monitor) throws FeedHenryException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpUtil.setupProxy(httpClient);
        HttpPost post = new HttpPost(String.valueOf(this.fhURL.toString()) + "/" + api);
        post.addHeader("X-FH-AUTH-USER", this.apikey);
        post.addHeader("Content-Type", "application/json");
        post.setEntity((HttpEntity)new StringEntity(payload, ContentType.APPLICATION_JSON));
        try {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
            sm.worked(50);
            int status = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            InputStream stream = entity.getContent();
            Long contentLength = entity.getContentLength();
            sm.setWorkRemaining((int)(contentLength / 1024L));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int length = 0;
            while ((length = stream.read(buffer)) != -1) {
                baos.write(buffer, 0, length);
                sm.worked(1);
            }
            String json = new String(baos.toByteArray());
            if (status != 200 && status != 201) {
                throw new FeedHenryException(status, response.getStatusLine().getReasonPhrase());
            }
            return json;
        }
        catch (IOException e) {
            FeedHenryException fe = new FeedHenryException(15, NLS.bind((String)"Unexpected error while communicating with {0}", (Object)this.fhURL.getHost()));
            fe.initCause(e);
            throw fe;
        }
    }

    private String doGetAPICall(String api, IProgressMonitor monitor) throws FeedHenryException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpUtil.setupProxy(httpClient);
        HttpGet get = new HttpGet(String.valueOf(this.fhURL.toString()) + api);
        get.addHeader("X-FH-AUTH-USER", this.apikey);
        try {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            sm.worked(1);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);
            sm.worked(50);
            int status = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            InputStream stream = entity.getContent();
            Long contentLength = entity.getContentLength();
            sm.setWorkRemaining((int)(contentLength / 1024L));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int length = 0;
            while ((length = stream.read(buffer)) != -1) {
                baos.write(buffer, 0, length);
                sm.worked(1);
            }
            String json = new String(baos.toByteArray());
            if (status != 200) {
                throw new FeedHenryException(status, response.getStatusLine().getReasonPhrase());
            }
            return json;
        }
        catch (IOException e) {
            FeedHenryException fe = new FeedHenryException(15, NLS.bind((String)"Unexpected error while communicating with {0}", (Object)this.fhURL.getHost()));
            fe.initCause(e);
            throw fe;
        }
    }
}

