/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.feedhenry.ui.internal;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.feedhenry.ui.FHPlugin;
import org.jboss.tools.feedhenry.ui.cordova.internal.preferences.FHPreferences;
import org.jboss.tools.feedhenry.ui.internal.FHAppLabelProvider;
import org.jboss.tools.feedhenry.ui.internal.FHApplicationContentProvider;
import org.jboss.tools.feedhenry.ui.internal.FHErrorHandler;
import org.jboss.tools.feedhenry.ui.internal.FeedHenryApplicationSelectionPart;
import org.jboss.tools.feedhenry.ui.model.FeedHenry;
import org.jboss.tools.feedhenry.ui.model.FeedHenryApplication;
import org.jboss.tools.feedhenry.ui.model.FeedHenryException;
import org.jboss.tools.feedhenry.ui.model.FeedHenryProject;

public class FeedHenryApplicationSelector {
    private final FeedHenryApplicationSelectionPart block;
    private final FHAppLabelProvider labelProvider = new FHAppLabelProvider();
    private final FHApplicationContentProvider contentProvider = new FHApplicationContentProvider();
    private SelectionChangeCallback selectionCallback;
    private List<FeedHenryProject> projects;

    public FeedHenryApplicationSelector() {
        this.block = new FeedHenryApplicationSelectionPart(this);
        this.block.setContentProvider(this.contentProvider);
        this.block.setLabelProvider(this.labelProvider);
    }

    public FeedHenryApplicationSelector createSelectorUI(Composite parent) {
        Assert.isTrue((parent.getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0, (String)"Must be called from the UI thread");
        this.block.createContent(parent);
        if (this.projects != null) {
            this.block.setInput(this.projects);
        }
        return this;
    }

    public FeedHenryApplicationSelector retrieveProjects(IRunnableContext context) {
        Assert.isNotNull((Object)context);
        try {
            context.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        final SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)"Display FeedHenry Projects", (int)100);
                        FeedHenryApplicationSelector.this.prepareInput((IProgressMonitor)sm.newChild(70));
                        if (FeedHenryApplicationSelector.this.block != null) {
                            Display display = PlatformUI.getWorkbench().getDisplay();
                            display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    FeedHenryApplicationSelector.this.block.setInput(FeedHenryApplicationSelector.this.projects);
                                    sm.worked(30);
                                }
                            });
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            if (FHErrorHandler.handle(e)) {
                this.retrieveProjects(context);
            }
        }
        catch (InterruptedException e) {
            FHPlugin.log(1, "Project retrieaval interrupted", e);
        }
        return this;
    }

    public FeedHenryApplicationSelector setProjectsFilter(IFilter filter) {
        this.contentProvider.setProjectFilter(filter);
        this.block.setProjectFilter(filter);
        return this;
    }

    public FeedHenryApplicationSelector setDisabledProjectsFilter(IFilter filter) {
        this.labelProvider.setDisabledItemsFilter(filter);
        this.block.setDisabledFilter(filter);
        return this;
    }

    public FeedHenryApplicationSelector setSelectionChangeCallback(SelectionChangeCallback cb) {
        this.selectionCallback = cb;
        return this;
    }

    public List<FeedHenryApplication> getSelectedApplications() {
        Object[] checked = this.block.getCheckedElements();
        if (checked == null || checked.length < 1) {
            return Collections.emptyList();
        }
        ArrayList<FeedHenryApplication> selectedApps = new ArrayList<FeedHenryApplication>();
        int i = 0;
        while (i < checked.length) {
            if (checked[i] instanceof FeedHenryApplication) {
                selectedApps.add((FeedHenryApplication)checked[i]);
            }
            ++i;
        }
        return selectedApps;
    }

    public FeedHenryApplicationSelector setLabel(String label) {
        this.block.setLabel(label);
        return this;
    }

    void selectionChanged() {
        if (this.selectionCallback != null) {
            this.selectionCallback.selectionChanged(this.getSelectedApplications());
        }
    }

    private void prepareInput(IProgressMonitor monitor) throws CoreException {
        FeedHenry fh = new FeedHenry();
        FHPreferences prefs = FHPreferences.getPreferences();
        String feedHenryURL = prefs.getFeedHenryURL();
        if (feedHenryURL == null || feedHenryURL.isEmpty()) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.feedhenry.ui", 10, "FeedHenry URL preference is empty. Specify FeedHenry URL on preferences.", null));
        }
        try {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.projects = fh.setFeedHenryURL(new URL(feedHenryURL)).setAPIKey(prefs.getUserAPIKey()).listProjects(monitor);
        }
        catch (MalformedURLException e) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.feedhenry.ui", 10, NLS.bind((String)"{0} is not a valid URL", (Object)feedHenryURL), (Throwable)e));
        }
        catch (FeedHenryException e) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.feedhenry.ui", e.getCode(), e.getMessage(), (Throwable)e));
        }
    }

    public static interface SelectionChangeCallback {
        public void selectionChanged(List<FeedHenryApplication> var1);
    }
}

