/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.feedhenry.ui.internal;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.feedhenry.ui.FHPlugin;
import org.jboss.tools.feedhenry.ui.model.FeedHenryApplication;
import org.jboss.tools.feedhenry.ui.model.FeedHenryProject;

public final class FHAppLabelProvider
extends LabelProvider
implements IFontProvider,
IColorProvider {
    private static final String ICON_PATH_FEEDHENRY = "/icons/obj16/feedhenry_16.png";
    private static final String ICON_PATH_ANDROID = "/icons/obj16/android_16.png";
    private static final String ICON_PATH_IOS = "/icons/obj16/apple_16.png";
    private static final String ICON_PATH_CORDOVA = "/icons/obj16/cordova_16.png";
    private static final String ICON_PATH_NODEJS = "/icons/obj16/nodejs_16.png";
    private static final String ICON_PATH_HTML5 = "/icons/obj16/html5_16.png";
    private static final String ICON_PATH_WEBAPP = "/icons/obj16/web_application.png";
    private IFilter disabledFilter;
    private ImageRegistry images;
    private Image defaultImage;

    public String getText(Object element) {
        if (element instanceof FeedHenryProject) {
            FeedHenryProject p = (FeedHenryProject)element;
            return p.getTitle();
        }
        FeedHenryApplication app = (FeedHenryApplication)element;
        return app.getTitle();
    }

    public Image getImage(Object element) {
        block29: {
            if (element instanceof FeedHenryProject) {
                ImageDescriptor desc = FHPlugin.getImageDescriptor("org.jboss.tools.feedhenry.ui", ICON_PATH_FEEDHENRY);
                return desc.createImage();
            }
            if (!(element instanceof FeedHenryApplication)) break block29;
            FeedHenryApplication app = (FeedHenryApplication)element;
            String imagePath = null;
            boolean isDisabled = this.disabledFilter != null && this.disabledFilter.select((Object)app);
            switch (app.getType()) {
                case "client_advanced_hybrid": {
                    imagePath = ICON_PATH_CORDOVA;
                    break;
                }
                case "client_native_android": {
                    imagePath = ICON_PATH_ANDROID;
                    break;
                }
                case "cloud_nodejs": {
                    imagePath = ICON_PATH_NODEJS;
                    break;
                }
                case "webapp_advanced": 
                case "webapp_basic": {
                    imagePath = ICON_PATH_WEBAPP;
                    break;
                }
                case "client_native_ios": {
                    imagePath = ICON_PATH_IOS;
                    break;
                }
                case "client_hybrid": {
                    imagePath = ICON_PATH_HTML5;
                    break;
                }
                default: {
                    if (this.defaultImage == null) {
                        this.defaultImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT_CLOSED");
                        if (isDisabled) {
                            this.defaultImage = new Image(this.defaultImage.getDevice(), this.defaultImage, 1);
                        }
                    }
                    return this.defaultImage;
                }
            }
            String registryKey = isDisabled ? String.valueOf(imagePath) + "_disabled" : imagePath;
            Image image = this.getImageRegistry().get(registryKey);
            if (image == null) {
                ImageDescriptor desc = FHPlugin.getImageDescriptor("org.jboss.tools.feedhenry.ui", imagePath);
                image = desc.createImage();
                if (isDisabled) {
                    image = new Image(image.getDevice(), image, 1);
                }
                this.getImageRegistry().put(registryKey, image);
            }
            return image;
        }
        return super.getImage(element);
    }

    public Font getFont(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        if (element instanceof FeedHenryApplication) {
            FeedHenryApplication app = (FeedHenryApplication)element;
            if (this.disabledFilter != null && this.disabledFilter.select((Object)app)) {
                return Display.getCurrent().getSystemColor(33);
            }
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    void setDisabledItemsFilter(IFilter filter) {
        this.disabledFilter = filter;
    }

    private ImageRegistry getImageRegistry() {
        if (this.images == null) {
            this.images = new ImageRegistry();
        }
        return this.images;
    }

    public void dispose() {
        super.dispose();
        if (this.defaultImage != null) {
            this.defaultImage.dispose();
        }
        if (this.images != null) {
            this.images.dispose();
        }
    }
}

