/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.operation;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderFramework;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFFacetInstallDataModelProvider;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.filesystems.impl.FileSystemImpl;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jsf.JSFModelPlugin;
import org.jboss.tools.jsf.project.JSFAutoLoad;
import org.jboss.tools.jsf.ui.JsfUiPlugin;
import org.jboss.tools.jsf.web.JSFTemplate;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.WebUtils;
import org.jboss.tools.jst.web.context.RegisterServerContext;
import org.jboss.tools.jst.web.kb.internal.KbBuilder;
import org.jboss.tools.jst.web.project.helpers.IWebProjectTemplate;
import org.jboss.tools.jst.web.project.helpers.NewWebProjectContext;
import org.jboss.tools.jst.web.ui.operation.WebProjectCreationOperation;

public class JSFProjectCreationOperation
extends WebProjectCreationOperation {
    public JSFProjectCreationOperation(IProject project, IPath projectLocation, RegisterServerContext registry, Properties properties) {
        super(project, projectLocation, registry, properties);
    }

    public JSFProjectCreationOperation(NewWebProjectContext context) {
        super(context);
    }

    protected String getNatureID() {
        return "org.jboss.tools.jsf.jsfnature";
    }

    protected void configFacets(IDataModel dataModel, String projectLocation) {
        super.configFacets(dataModel, projectLocation);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dataModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel configJSF = (IDataModel)map.get((Object)"jst.jsf");
        if (configJSF == null) {
            configJSF = DataModelFactory.createDataModel((IDataModelProvider)new JSFFacetInstallDataModelProvider());
            map.add(configJSF);
        }
        if ((configJSF = (IDataModel)map.get((Object)"jst.jsf")) != null) {
            String version;
            String template = this.getProperty("WebNatureOperation.TEMPLATE_VERSION_ID");
            String string = template.indexOf("1.1") >= 0 ? "1.1" : (template.indexOf("1.2") >= 0 ? "1.2" : (template.indexOf("2.0") >= 0 ? "2.0" : (template.indexOf("2.1") >= 0 ? "2.1" : (version = template.indexOf("2.2") >= 0 ? "2.2" : null))));
            if (version != null) {
                configJSF.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)version);
            }
            IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)"jst.jsf");
            try {
                IFacetedProject fproj = ProjectFacetsManager.create((IProject)this.getProject(), (boolean)true, (IProgressMonitor)new NullProgressMonitor());
                LibraryInstallDelegate libraryDelegate = new LibraryInstallDelegate((IFacetedProjectBase)fproj, facet.getDefaultVersion());
                ILibraryProvider provider = LibraryProviderFramework.getProvider((String)"jsf-no-op-library-provider");
                libraryDelegate.setLibraryProvider(provider);
                configJSF.setProperty("IJSFFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE", (Object)libraryDelegate);
            }
            catch (CoreException e) {
                JsfUiPlugin.getDefault().logError(e);
            }
        }
    }

    protected IWebProjectTemplate createTemplate() {
        return new JSFTemplate();
    }

    protected String getLibLocation() {
        FileSystemImpl fs = (FileSystemImpl)FileSystemsHelper.getFileSystem((XModel)this.templateModel, (String)"lib");
        if (fs != null) {
            return fs.getAbsoluteLocation();
        }
        fs = (FileSystemImpl)FileSystemsHelper.getWebInf((XModel)this.templateModel);
        return String.valueOf(fs.getAbsoluteLocation()) + "/lib";
    }

    protected void copyTemplate() throws Exception {
        String location;
        String location2 = location = this.getProject().getLocation().toString();
        String templateLocation = this.getTemplateLocation();
        String version = this.getProperty("WebNatureOperation.TEMPLATE_VERSION_ID");
        File templateFile = new File(templateLocation);
        templateLocation = templateFile.getCanonicalPath().replace('\\', '/');
        File targetDir = new File(location);
        File targetDir2 = new File(location2);
        FileUtil.copyDir((File)templateFile, (File)targetDir2, (boolean)true, (boolean)true);
        this.preprocessTemplate(templateFile, targetDir2);
        this.adjustProjectFile(targetDir, targetDir2);
        String[] jars = this.template.getLibraries(version);
        String libDir = this.getLibLocation();
        libDir = String.valueOf(location2) + libDir.substring(templateLocation.length());
        int i = 0;
        while (i < jars.length) {
            File source = new File(jars[i]);
            FileUtil.copyFile((File)source, (File)new File(libDir, source.getName()), (boolean)true);
            ++i;
        }
        String servletVersion = this.getProperty("WebNatureOperation.SERVLET_VERSION_ID");
        String[] servletJars = WebUtils.getServletLibraries((String)this.template.getTemplatesBase(), (String)servletVersion);
        StringBuilder sb = new StringBuilder();
        int i2 = 0;
        while (i2 < servletJars.length) {
            sb.append(servletJars[i2++]).append(';');
        }
        Properties buildProperties = new Properties();
        buildProperties.setProperty("classpath.external", sb.toString());
        File antDir = new File(String.valueOf(location2) + "/ant");
        if (!antDir.exists()) {
            antDir.mkdirs();
        }
        BufferedOutputStream propFile = new BufferedOutputStream(new FileOutputStream(String.valueOf(location2) + "/ant/build.properties"));
        try {
            buildProperties.store(propFile, "");
        }
        finally {
            ((OutputStream)propFile).close();
        }
        this.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
    }

    private void adjustProjectFile(File targetDir, File targetDir2) {
        File f2 = this.getProjectFile(targetDir2);
        if (f2 != null) {
            f2.delete();
        }
    }

    private File getProjectFile(File targetDir2) {
        File f = new File(targetDir2, ".settings/org.jboss.tools.jst.web.xml");
        if (f.exists()) {
            return f;
        }
        return null;
    }

    protected void postCreateWebNature() {
        if (this.projectFile != null) {
            if (this.projectFile.isFile()) {
                IFile f = EclipseResourceUtil.getFile((String)this.projectFile.getAbsolutePath());
                if (f != null && f.exists()) {
                    try {
                        f.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        JSFModelPlugin.getPluginLog().logError((Throwable)e);
                        this.projectFile.delete();
                    }
                } else {
                    this.projectFile.delete();
                }
            }
            this.projectFile = null;
        }
        this.model.getProperties().put(XModelConstants.AUTOLOAD, new JSFAutoLoad());
        try {
            WebModelPlugin.addNatureToProjectWithValidationSupport((IProject)this.getProject(), (String)KbBuilder.BUILDER_ID, (String)"org.jboss.tools.jst.web.kb.kbnature");
        }
        catch (CoreException e) {
            JSFModelPlugin.getPluginLog().logError((Throwable)e);
        }
    }
}

