/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.editor.model.impl;

import java.beans.PropertyVetoException;
import org.jboss.tools.jsf.ui.JsfUiPlugin;
import org.jboss.tools.jsf.ui.editor.model.ILink;
import org.jboss.tools.jsf.ui.editor.model.ISegment;
import org.jboss.tools.jsf.ui.editor.model.impl.JSFElement;
import org.w3c.dom.Element;

public class Segment
extends JSFElement
implements ISegment {
    int length;
    ISegment prevSegment;
    ISegment nextSegment;

    public Segment(ILink parent, Element segmentElement, ISegment prevSegment) {
        super(parent);
        try {
            this.setName("SEGMENT");
            String s = segmentElement.getAttribute("length");
            this.length = s == null || s.length() == 0 ? 0 : Integer.parseInt(s);
        }
        catch (PropertyVetoException propertyVetoException) {
            this.length = 0;
        }
        catch (NumberFormatException exception) {
            this.length = 0;
            JsfUiPlugin.getPluginLog().logError((Throwable)exception);
        }
        this.prevSegment = prevSegment;
        if (prevSegment != null) {
            prevSegment.setNext(this);
        }
    }

    public Segment(ILink parent, int length, ISegment prevSegment) {
        super(parent);
        try {
            this.setName("SEGMENT");
            this.length = length;
        }
        catch (PropertyVetoException propertyVetoException) {
            length = 0;
        }
        this.length = length;
        this.prevSegment = (Segment)prevSegment;
        if (prevSegment != null) {
            prevSegment.setNext(this);
        }
    }

    @Override
    public ISegment getNext() {
        return this.nextSegment;
    }

    @Override
    public ISegment getPrev() {
        return this.prevSegment;
    }

    @Override
    public void setPrev(ISegment segment) {
        ISegment oldPrev = this.prevSegment;
        this.prevSegment = (Segment)segment;
        this.propertyChangeSupport.firePropertyChange("prev", oldPrev, segment);
    }

    @Override
    public void setNext(ISegment segment) {
        ISegment oldNext = this.nextSegment;
        this.nextSegment = (Segment)segment;
        this.propertyChangeSupport.firePropertyChange("next", oldNext, segment);
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public void setLength(int length) {
        int oldLength = this.length;
        this.length = length;
        this.propertyChangeSupport.firePropertyChange("length", oldLength, length);
    }

    @Override
    public String getName() {
        return "" + this.getLength();
    }
}

