/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.editor;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.action.XModelObjectActionList;
import org.jboss.tools.jsf.ui.editor.edit.JSFDiagramEditPart;
import org.jboss.tools.jsf.ui.editor.edit.JSFEditPart;
import org.jboss.tools.jsf.ui.editor.edit.LinkEditPart;
import org.jboss.tools.jsf.ui.editor.model.IJSFElement;

public class JSFContextMenuProvider
extends ContextMenuProvider {
    private ActionRegistry actionRegistry;
    private MouseEvent lastDownEvent = null;
    private Point lastPoint = null;

    public JSFContextMenuProvider(EditPartViewer viewer, ActionRegistry registry) {
        super(viewer);
        viewer.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                JSFContextMenuProvider.this.lastDownEvent = e;
            }
        });
        this.setActionRegistry(registry);
    }

    public void buildContextMenu(IMenuManager manager) {
        GEFActionConstants.addStandardActionGroups((IMenuManager)manager);
    }

    ActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    private void setActionRegistry(ActionRegistry registry) {
        this.actionRegistry = registry;
    }

    protected void update(boolean force, boolean recursive) {
        if (!this.isDirty() && !force) {
            return;
        }
        if (!this.menuExist()) {
            return;
        }
        MenuItem[] is = this.getMenu().getItems();
        int i = 0;
        while (i < is.length) {
            if (!is[i].isDisposed()) {
                is[i].dispose();
            }
            ++i;
        }
        ISelection s = this.getViewer().getSelection();
        if (s.isEmpty() || !(s instanceof StructuredSelection)) {
            return;
        }
        StructuredSelection ss = (StructuredSelection)s;
        XModelObject object = this.getTarget(ss.getFirstElement());
        if (object != null) {
            Properties p = new Properties();
            if (this.lastDownEvent != null) {
                this.lastPoint = new Point(this.lastDownEvent.x, this.lastDownEvent.y);
                ((JSFDiagramEditPart)this.getViewer().getRootEditPart().getChildren().get(0)).getFigure().translateToRelative((Translatable)this.lastPoint);
                this.lastDownEvent = null;
            }
            if (this.lastPoint != null) {
                p.setProperty("process.mouse.x", "" + this.lastPoint.x);
                p.setProperty("process.mouse.y", "" + this.lastPoint.y);
            }
            XModelObjectActionList list = new XModelObjectActionList(object.getModelEntity().getActionList(), object, this.getTargets(ss), (Object)new Object[]{object, p});
            Menu menu = this.getMenu();
            list.createMenu(menu);
            list.removeLastSeparator(menu);
        }
    }

    private XModelObject[] getTargets(StructuredSelection ss) {
        if (ss.size() < 2) {
            return null;
        }
        Iterator it = ss.iterator();
        ArrayList<XModelObject> l = new ArrayList<XModelObject>();
        while (it.hasNext()) {
            XModelObject o = this.getTarget(it.next());
            if (o == null) continue;
            l.add(o);
        }
        return l.toArray(new XModelObject[0]);
    }

    private XModelObject getTarget(Object selected) {
        PropertyChangeListener part;
        Object partModel;
        if (selected instanceof JSFEditPart && (partModel = (part = (JSFEditPart)selected).getModel()) instanceof IJSFElement) {
            return (XModelObject)((IJSFElement)partModel).getSource();
        }
        if (selected instanceof LinkEditPart && (partModel = (part = (LinkEditPart)selected).getModel()) instanceof IJSFElement) {
            return (XModelObject)((IJSFElement)partModel).getSource();
        }
        return null;
    }
}

