/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.internal.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.misc.ContainerSelectionGroup;
import org.eclipse.ui.internal.ide.misc.ResourceAndContainerGroup;
import org.eclipse.ui.internal.wizards.newresource.ResourceMessages;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.jboss.tools.batch.core.BatchCorePlugin;
import org.jboss.tools.batch.internal.core.impl.BatchProject;
import org.jboss.tools.batch.internal.core.impl.BatchUtil;
import org.jboss.tools.batch.internal.core.impl.definition.BatchJobDefinition;
import org.jboss.tools.batch.ui.JobImages;
import org.jboss.tools.batch.ui.internal.wizard.WizardMessages;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.ui.widget.editor.SwtFieldEditorFactory;
import org.jboss.tools.common.util.FileUtil;

public class NewJobXMLCreationWizard
extends BasicNewResourceWizard {
    public static final String WIZARD_ID = "org.jboss.tools.batch.ui.internal.wizard.NewJobXMLCreationWizard";
    public static final String PAGE_NAME = "newJobFilePage";
    private WizardNewBeansXMLFileCreationPage mainPage;
    private boolean fOpenEditorOnFinish = true;

    public void setVersion(String version) {
        if (this.mainPage.versionEditor != null) {
            this.mainPage.versionEditor.setValue((Object)version.toString());
        }
    }

    public void setID(String id) {
        if (this.mainPage.idEditor != null) {
            this.mainPage.idEditor.setValue((Object)id);
        }
    }

    public String getVersion() {
        return this.mainPage.versionEditor != null ? this.mainPage.versionEditor.getValueAsString() : this.mainPage.getInitialJobVersion();
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardNewBeansXMLFileCreationPage(PAGE_NAME, this.getSelection());
        this.mainPage.setTitle(WizardMessages.NEW_JOB_XML_WIZARD_TITLE);
        this.mainPage.setDescription(WizardMessages.NEW_JOB_XML_WIZARD_DESCRIPTION);
        this.mainPage.setImageDescriptor(JobImages.getImageDescriptor("BatchXMLWizBan.png"));
        this.mainPage.setFileName("job.xml");
        this.addPage((IWizardPage)this.mainPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setWindowTitle(WizardMessages.NEW_JOB_XML_WIZARD_TITLE);
        this.setNeedsProgressMonitor(true);
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = IDEWorkbenchPlugin.getIDEImageDescriptor((String)"wizban/newfile_wiz.png");
        this.setDefaultPageImageDescriptor(desc);
    }

    public boolean isOpenEditorAfterFinish() {
        return this.fOpenEditorOnFinish;
    }

    public void setOpenEditorAfterFinish(boolean set) {
        this.fOpenEditorOnFinish = set;
    }

    public boolean performFinish() {
        IFile file = this.mainPage.createNewFile();
        if (file == null) {
            return false;
        }
        this.selectAndReveal((IResource)file);
        if (this.fOpenEditorOnFinish) {
            IWorkbenchWindow dw = this.getWorkbench().getActiveWorkbenchWindow();
            try {
                IWorkbenchPage page;
                if (dw != null && (page = dw.getActivePage()) != null) {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
            }
            catch (PartInitException e) {
                DialogUtil.openError((Shell)dw.getShell(), (String)ResourceMessages.FileResource_errorMessage, (String)e.getMessage(), (PartInitException)e);
            }
        }
        return true;
    }

    public static IPath getBatchJobsContainer(IProject p) {
        IResource[] iResourceArray = EclipseUtil.getJavaSourceRoots((IProject)p);
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder fm;
            IFolder bj;
            IResource f = iResourceArray[n2];
            if (f instanceof IFolder && (bj = (fm = ((IFolder)f).getFolder("META-INF")).getFolder("batch-jobs")).exists()) {
                return bj.getFullPath();
            }
            ++n2;
        }
        return null;
    }

    class WizardNewBeansXMLFileCreationPage
    extends WizardNewFileCreationPage {
        IFieldEditor versionEditor;
        IFieldEditor idEditor;
        String JOB_ID_VAR;
        String DEFAULT_FILE_NAME;
        String DEFAULT_JOB_ID;
        Set<String> ids;
        IPath lastPath;
        boolean isJobIdDefault;
        boolean isSettingDefaultJobId;

        public WizardNewBeansXMLFileCreationPage(String pageName, IStructuredSelection selection) {
            super(pageName, selection);
            this.versionEditor = null;
            this.idEditor = null;
            this.JOB_ID_VAR = "%job-id%";
            this.DEFAULT_FILE_NAME = "job.xml";
            this.DEFAULT_JOB_ID = "job";
            this.ids = new HashSet<String>();
            this.lastPath = null;
            this.isJobIdDefault = true;
            this.isSettingDefaultJobId = false;
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            this.validatePage();
        }

        protected void initialPopulateContainerNameField() {
            super.initialPopulateContainerNameField();
            if (!NewJobXMLCreationWizard.this.selection.isEmpty() && NewJobXMLCreationWizard.this.selection instanceof IStructuredSelection) {
                Object o = NewJobXMLCreationWizard.this.selection.getFirstElement();
                IResource r = null;
                if (o instanceof IResource) {
                    r = (IResource)o;
                } else if (o instanceof IAdaptable) {
                    r = (IResource)((IAdaptable)o).getAdapter(IResource.class);
                }
                if (r != null) {
                    boolean needMetaInf = false;
                    boolean needBatchJobs = false;
                    IPath current = this.getContainerFullPath();
                    IProject p = r.getProject();
                    IPath path = NewJobXMLCreationWizard.getBatchJobsContainer(p);
                    if (current != null && current.equals((Object)path)) {
                        return;
                    }
                    if (path == null) {
                        IResource[] iResourceArray = EclipseUtil.getJavaSourceRoots((IProject)p);
                        int n = iResourceArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IResource f = iResourceArray[n2];
                            if (f instanceof IFolder) {
                                IPath pth;
                                IFolder fm = ((IFolder)f).getFolder("META-INF");
                                IFolder bj = fm.getFolder("batch-jobs");
                                if (!bj.exists()) {
                                    needBatchJobs = true;
                                    if (fm.exists()) {
                                        bj = fm;
                                    } else {
                                        needMetaInf = true;
                                        bj = (IFolder)f;
                                    }
                                }
                                if ((pth = bj.getFullPath()).equals((Object)current) && !needMetaInf) {
                                    return;
                                }
                                if (path == null || pth.equals((Object)current)) {
                                    path = pth;
                                }
                            }
                            ++n2;
                        }
                    }
                    if (path != null) {
                        this.setContainerFullPath(path);
                        if (needMetaInf) {
                            String value = needBatchJobs ? path.append("META-INF").append("batch-jobs").toString() : path.append("META-INF").toString();
                            try {
                                this.setContainerValue(value);
                            }
                            catch (NoSuchFieldException e) {
                                BatchCorePlugin.pluginLog().logError((Throwable)e);
                            }
                            catch (IllegalAccessException e) {
                                BatchCorePlugin.pluginLog().logError((Throwable)e);
                            }
                        }
                    }
                }
            }
        }

        void setContainerValue(String value) throws NoSuchFieldException, IllegalAccessException {
            Field f = WizardNewFileCreationPage.class.getDeclaredField("resourceGroup");
            f.setAccessible(true);
            ResourceAndContainerGroup resourceGroup = (ResourceAndContainerGroup)f.get((Object)this);
            Field f2 = ResourceAndContainerGroup.class.getDeclaredField("containerGroup");
            f2.setAccessible(true);
            ContainerSelectionGroup containerGroup = (ContainerSelectionGroup)f2.get(resourceGroup);
            Field f3 = ContainerSelectionGroup.class.getDeclaredField("containerNameField");
            f3.setAccessible(true);
            Text text = (Text)f3.get(containerGroup);
            text.setText(value);
        }

        protected InputStream getInitialContents() {
            File f = null;
            try {
                f = new File(BatchUtil.getTemplatesFolder(), this.DEFAULT_FILE_NAME);
            }
            catch (IOException e) {
                BatchCorePlugin.pluginLog().logError((Throwable)e);
                return new ByteArrayInputStream(new byte[0]);
            }
            String text = FileUtil.readFile((File)f);
            String id = ((NewJobXMLCreationWizard)NewJobXMLCreationWizard.this).mainPage.idEditor.getValueAsString().trim();
            int i = text.indexOf(this.JOB_ID_VAR);
            if (i > 0) {
                text = String.valueOf(text.substring(0, i)) + id + text.substring(i + this.JOB_ID_VAR.length());
            }
            return new ByteArrayInputStream(text.getBytes());
        }

        protected IStatus validateLinkedResource() {
            return Status.OK_STATUS;
        }

        protected void createLinkTarget() {
        }

        protected void createAdvancedControls(Composite parent) {
            Label separator = new Label(parent, 258);
            GridData sd = new GridData(768);
            separator.setLayoutData((Object)sd);
            List<String> versions = this.getVersions();
            if (versions.size() > 1) {
                this.versionEditor = SwtFieldEditorFactory.INSTANCE.createComboEditor("version", WizardMessages.versionLabel, versions, (Object)this.getInitialJobVersion(), false, "");
                this.versionEditor.doFillIntoGrid((Object)this.createComposite(parent));
            }
            this.idEditor = SwtFieldEditorFactory.INSTANCE.createTextEditor("id", WizardMessages.idLabel, this.DEFAULT_JOB_ID);
            this.idEditor.doFillIntoGrid((Object)this.createComposite(parent));
            this.idEditor.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!WizardNewBeansXMLFileCreationPage.this.isSettingDefaultJobId) {
                        WizardNewBeansXMLFileCreationPage.this.isJobIdDefault = false;
                        WizardNewBeansXMLFileCreationPage.this.setPageComplete(WizardNewBeansXMLFileCreationPage.this.validatePage());
                    }
                }
            });
        }

        private Composite createComposite(Composite parent) {
            Composite c = new Composite(parent, 0);
            c.setLayoutData((Object)new GridData(768));
            GridLayout gl = new GridLayout(3, false);
            gl.marginWidth = 5;
            gl.marginHeight = 5;
            gl.verticalSpacing = 0;
            gl.horizontalSpacing = 5;
            c.setLayout((Layout)gl);
            return c;
        }

        String getInitialJobVersion() {
            return "1.0";
        }

        List<String> getVersions() {
            ArrayList<String> versions = new ArrayList<String>();
            versions.add(this.getInitialJobVersion());
            return versions;
        }

        protected boolean validatePage() {
            boolean valid = super.validatePage();
            if (this.idEditor == null) {
                return valid;
            }
            if (this.isJobIdDefault) {
                String id;
                String fn = this.getFileName();
                if (fn.endsWith(".xml")) {
                    fn = fn.substring(0, fn.length() - 4).trim();
                }
                if (!(id = this.idEditor.getValueAsString().trim()).equals(fn)) {
                    this.isSettingDefaultJobId = true;
                    this.idEditor.setValue((Object)fn);
                    this.isSettingDefaultJobId = false;
                }
            }
            if (valid) {
                BatchProject bp;
                IProject project;
                String id = this.idEditor.getValueAsString().trim();
                if (id.length() == 0) {
                    this.setErrorMessage(WizardMessages.errorIdIsRequired);
                    return false;
                }
                IPath p = this.getContainerFullPath();
                if (!p.equals((Object)this.lastPath) && p.segmentCount() > 0 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(p.segment(0))) != null && (bp = (BatchProject)BatchCorePlugin.getBatchProject((IProject)project, (boolean)true)) != null) {
                    this.ids = new HashSet<String>();
                    for (BatchJobDefinition def : bp.getDeclaredBatchJobDefinitions()) {
                        this.ids.add(def.getJobID());
                    }
                }
                if (this.ids.contains(id)) {
                    this.setMessage(WizardMessages.errorJobIdIsNotUnique, 2);
                }
            }
            return valid;
        }
    }
}

