/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.internal.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.batch.core.BatchArtifactType;
import org.jboss.tools.batch.core.BatchCorePlugin;
import org.jboss.tools.batch.core.IBatchProject;
import org.jboss.tools.batch.ui.JobImages;
import org.jboss.tools.batch.ui.internal.wizard.BatchFieldEditorFactory;
import org.jboss.tools.batch.ui.internal.wizard.NewBatchArtifactWizard;
import org.jboss.tools.batch.ui.internal.wizard.WizardMessages;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.util.BeanUtil;

public class NewBatchArtifactWizardPage
extends NewClassWizardPage
implements PropertyChangeListener {
    protected String defaultTypeName = null;
    IFieldEditor artifacts;
    IFieldEditor derivedFrom;
    IFieldEditor nameOptions;
    IFieldEditor name;
    boolean canNameBeModified = true;
    IFieldEditor properties;
    protected StatusInfo artifactNameStatus = new StatusInfo();
    protected StatusInfo propertiesStatus = new StatusInfo();
    boolean isArtifactNameDefault = true;

    public NewBatchArtifactWizardPage() {
        this.setTitle(WizardMessages.NEW_BATCH_ARTIFACT_WIZARD_PAGE_NAME);
        this.setDescription(WizardMessages.NEW_BATCH_ARTIFACT_WIZARD_DESCRIPTION);
        this.setImageDescriptor(JobImages.getImageDescriptor("BatchArtifactWizBan.png"));
    }

    public void setProperties(List<String> propertyNames) {
        this.properties.setValue(propertyNames);
    }

    public void setArtifact(BatchArtifactType type, boolean canBeModified) {
        String label = BatchFieldEditorFactory.getArtifactLabel(type);
        if (label != null) {
            this.setArtifactByLabel(label);
            this.setArtifactCanBeModified(canBeModified);
        }
    }

    public void setArtifactName(String artifactName) {
        this.name.setValue((Object)artifactName);
    }

    public void setArtifactName(String artifactName, boolean canBeModified) {
        this.name.setValue((Object)artifactName);
        this.canNameBeModified = canBeModified;
        this.name.setEnabled(canBeModified);
    }

    public String getArtifactName() {
        return this.name.getValueAsString();
    }

    void setArtifactByLabel(String label) {
        this.artifacts.setValue((Object)label);
    }

    public void setDeriveFromAbstractClass() {
        String artifactName = this.artifacts.getValueAsString();
        BatchArtifactType type = BatchFieldEditorFactory.ARTIFACTS.get(artifactName);
        if (type.getClassName() != null) {
            this.derivedFrom.setValue((Object)"class");
        }
    }

    public void setDeriveFromInterface() {
        this.derivedFrom.setValue((Object)"interface");
    }

    public void setArtifactCanBeModified(boolean canBeModified) {
        this.artifacts.setEnabled(canBeModified);
    }

    public void init(IStructuredSelection selection) {
        super.init(selection);
        this.defaultTypeName = null;
        this.setSuperClass("javax.batch.api.AbstractBatchlet", false);
        List<BatchArtifactType> types = ((NewBatchArtifactWizard)this.getWizard()).getTypes();
        this.artifacts = types != null && types.size() > 1 ? BatchFieldEditorFactory.createArtifactEditor(this.getDefaultArtifact(), types) : BatchFieldEditorFactory.createArtifactEditor(this.getDefaultArtifact());
        this.derivedFrom = BatchFieldEditorFactory.createDerivedFromEditor();
        this.nameOptions = BatchFieldEditorFactory.createNameOptionsEditor();
        this.name = BatchFieldEditorFactory.createArtifactNameEditor();
        this.properties = BatchFieldEditorFactory.createPropertiesEditor();
        this.doStatusUpdate();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.artifacts.doFillIntoGrid((Object)composite);
        this.derivedFrom.doFillIntoGrid((Object)composite);
        this.createSeparator(composite, nColumns);
        this.nameOptions.doFillIntoGrid((Object)composite);
        this.name.doFillIntoGrid((Object)composite);
        Control c = (Control)this.name.getEditorControls()[1];
        GridData d = (GridData)c.getLayoutData();
        --d.horizontalSpan;
        c.setLayoutData((Object)d);
        this.artifacts.addPropertyChangeListener((PropertyChangeListener)this);
        this.derivedFrom.addPropertyChangeListener((PropertyChangeListener)this);
        this.nameOptions.addPropertyChangeListener((PropertyChangeListener)this);
        this.name.addPropertyChangeListener((PropertyChangeListener)this);
        this.createSeparator(composite, nColumns);
        this.properties.doFillIntoGrid((Object)composite);
        this.properties.addPropertyChangeListener((PropertyChangeListener)this);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.new_class_wizard_page_context");
        this.onArtifactKindChange();
        this.doStatusUpdate();
    }

    protected BatchArtifactType getDefaultArtifact() {
        return BatchArtifactType.BATCHLET;
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.isEnclosingTypeSelected() ? this.fEnclosingTypeStatus : this.fPackageStatus, this.fTypeNameStatus, this.fModifierStatus, this.fSuperClassStatus, this.fSuperInterfacesStatus};
        this.updateStatus(status);
    }

    protected void updateStatus(IStatus[] status) {
        IStatus[] ns = new IStatus[status.length + 2];
        System.arraycopy(status, 0, ns, 0, status.length);
        ns[status.length] = this.artifactNameStatus;
        ns[status.length + 1] = this.propertiesStatus;
        status = ns;
        super.updateStatus(status);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("artifact".equals(name)) {
            this.onArtifactKindChange();
        } else if ("derive-from".equals(name)) {
            this.onDerivedFromChange();
        } else if ("loader-options".equals(name)) {
            this.onNameOptionChange();
        } else if ("name".equals(name)) {
            this.onNameChange();
        } else if ("properties".equals(name)) {
            this.onFieldNameChange();
        }
        this.doStatusUpdate();
    }

    void onArtifactKindChange() {
        String artifactName = this.artifacts.getValueAsString();
        BatchArtifactType type = BatchFieldEditorFactory.ARTIFACTS.get(artifactName);
        if (type != null) {
            boolean hasNoClass;
            boolean bl = hasNoClass = type.getClassName() == null;
            if (hasNoClass && "class".equals(this.derivedFrom.getValueAsString())) {
                this.derivedFrom.setValue((Object)"interface");
            }
            if (this.getControl() != null) {
                Composite p = (Composite)this.derivedFrom.getEditorControls()[1];
                p.getChildren()[1].setEnabled(!hasNoClass);
            }
            this.onDerivedFromChange();
        }
    }

    void onDerivedFromChange() {
        String artifactName = this.artifacts.getValueAsString();
        BatchArtifactType type = BatchFieldEditorFactory.ARTIFACTS.get(artifactName);
        if (type != null) {
            if ("class".equals(this.derivedFrom.getValueAsString())) {
                this.setSuperClass(type.getClassName(), false);
                this.setSuperInterfaces(new ArrayList(), false);
            } else {
                this.setSuperClass("", false);
                this.setSuperInterfaces(Arrays.asList(type.getInterfaceName()), false);
            }
        }
    }

    void onNameOptionChange() {
        this.name.setEnabled(!this.isArtifactNameQualified());
        if (this.isArtifactNameQualified()) {
            this.name.setValue((Object)this.getQualifiedName());
        } else {
            this.name.setValue((Object)BeanUtil.getDefaultBeanName((String)this.getTypeName()));
        }
    }

    void onNameChange() {
        this.artifactNameStatus = new StatusInfo();
        if (this.getJavaProject() == null) {
            return;
        }
        IBatchProject bp = BatchCorePlugin.getBatchProject((IProject)this.getJavaProject().getProject(), (boolean)true);
        if (bp != null) {
            String v = this.name.getValueAsString();
            if (v.length() == 0) {
                this.artifactNameStatus.setError(WizardMessages.errorArtifactNameIsEmpty);
            } else if (!bp.getArtifacts(v).isEmpty()) {
                this.artifactNameStatus.setError(WizardMessages.errorArtifactNameIsNotUnique);
            }
        }
    }

    void onFieldNameChange() {
        this.propertiesStatus = new StatusInfo();
        HashSet<String> fields = new HashSet<String>();
        for (String n : (List)this.properties.getValue()) {
            if (n == null || n.length() == 0) continue;
            IStatus val = JavaConventionsUtil.validateFieldName((String)n, null);
            if (val != null && val.getSeverity() == 4) {
                this.propertiesStatus.setError(NLS.bind((String)WizardMessages.errorFieldNameIsNotValid, (Object)val.getMessage()));
                return;
            }
            if (fields.contains(n)) {
                this.propertiesStatus.setError(NLS.bind((String)WizardMessages.errorFieldNameIsNotUnique, (Object)n));
                return;
            }
            fields.add(n);
        }
    }

    boolean isArtifactNameQualified() {
        String nameOption = this.nameOptions.getValueAsString();
        return "qualified".equals(nameOption);
    }

    String getQualifiedName() {
        return String.valueOf(this.getPackageText()) + "." + this.getTypeName();
    }

    protected IStatus typeNameChanged() {
        IStatus result = super.typeNameChanged();
        if (this.name != null && this.canNameBeModified && this.isArtifactNameDefault) {
            if (!this.isArtifactNameQualified()) {
                this.name.setValue((Object)BeanUtil.getDefaultBeanName((String)this.getTypeName()));
            } else {
                this.name.setValue((Object)(String.valueOf(this.getPackageText()) + "." + this.getTypeName()));
            }
        }
        return result;
    }

    protected void createTypeMembers(IType newType, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        this.createInheritedMethods(newType, true, true, imports, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        ISourceRange range = newType.getSourceRange();
        IBuffer buf = newType.getCompilationUnit().getBuffer();
        String lineDelimiter = StubUtility.getLineDelimiterUsed((IJavaProject)newType.getJavaProject());
        StringBuffer sb = new StringBuffer();
        this.addAnnotations(imports, sb, lineDelimiter);
        buf.replace(range.getOffset(), 0, sb.toString());
        this.createFields(newType, imports, monitor, lineDelimiter);
    }

    void addAnnotations(NewTypeWizardPage.ImportsManager imports, StringBuffer sb, String lineDelimiter) {
        if ("annotation".equals(this.nameOptions.getValueAsString())) {
            this.addNamedAnnotation(imports, sb, lineDelimiter);
        }
    }

    protected void addNamedAnnotation(NewTypeWizardPage.ImportsManager imports, StringBuffer sb, String lineDelimiter) {
        String annotationValue = this.name.getValueAsString();
        if (BeanUtil.getDefaultBeanName((String)this.getTypeName()).equals(annotationValue)) {
            annotationValue = "";
        }
        NewBatchArtifactWizardPage.addAnnotation("javax.inject.Named", annotationValue, imports, sb, lineDelimiter);
    }

    static void addAnnotation(String typeName, String value, NewTypeWizardPage.ImportsManager imports, StringBuffer sb, String lineDelimiter) {
        int i = typeName.lastIndexOf(46);
        String name = typeName.substring(i + 1);
        imports.addImport(typeName);
        sb.append("@").append(name);
        if (value != null && value.length() > 0) {
            sb.append("(\"").append(value).append("\")");
        }
        sb.append(lineDelimiter);
    }

    protected void createFields(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor, String lineDelimiter) throws CoreException {
        imports.addImport("javax.inject.Inject");
        imports.addImport("javax.batch.api.BatchProperty");
        ICompilationUnit cu = type.getCompilationUnit();
        JavaModelUtil.reconcile((ICompilationUnit)cu);
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings((IJavaProject)type.getJavaProject());
        settings.createComments = this.isAddComments();
        String access = "protected";
        String javatype = "String";
        IJavaElement[] cs = type.getChildren();
        IJavaElement sibling = cs == null || cs.length == 0 ? null : cs[0];
        for (String fieldName : (List)this.properties.getValue()) {
            String fieldHeader = "@Inject @BatchProperty " + access + " " + javatype + " " + fieldName + ";" + lineDelimiter;
            IField m = type.createField(fieldHeader, sibling, true, null);
            this.editField(cu, m, javatype, fieldHeader, lineDelimiter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void editField(ICompilationUnit cu, IField m, String javatype, String fieldHeader, String lineDelimiter) throws CoreException {
        ICompilationUnit iCompilationUnit = cu;
        synchronized (iCompilationUnit) {
            cu.reconcile(0, true, null, null);
        }
        ISourceRange range = m.getSourceRange();
        IBuffer buf = cu.getBuffer();
        StringBuffer sb = new StringBuffer(lineDelimiter);
        if (this.isAddComments()) {
            String fieldComment = CodeGeneration.getFieldComment((ICompilationUnit)cu, (String)javatype, (String)m.getElementName(), (String)lineDelimiter);
            sb.append(fieldComment).append(lineDelimiter);
        }
        sb.append(fieldHeader);
        String formattedContent = NewBatchArtifactWizardPage.codeFormat2(4, sb.toString(), 1, lineDelimiter, cu.getJavaProject());
        if (formattedContent != null && formattedContent.startsWith("\t")) {
            formattedContent = formattedContent.substring(1);
        }
        buf.replace(range.getOffset(), range.getLength(), formattedContent);
    }

    static String codeFormat2(int kind, String sourceString, int indentationLevel, String lineSeparator, IJavaProject project) {
        TextEdit edit = ToolFactory.createCodeFormatter((Map)project.getOptions(true)).format(kind, sourceString, 0, sourceString.length(), indentationLevel, lineSeparator);
        Document doc = new Document(sourceString);
        try {
            edit.apply((IDocument)doc, 0);
            return doc.get();
        }
        catch (BadLocationException badLocationException) {
            return sourceString;
        }
    }
}

