/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.internal.wizard;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.jboss.tools.batch.core.BatchArtifactType;
import org.jboss.tools.batch.core.BatchConstants;
import org.jboss.tools.batch.core.BatchCorePlugin;
import org.jboss.tools.batch.internal.core.impl.BatchUtil;
import org.jboss.tools.batch.ui.internal.wizard.NewBatchArtifactWizardPage;
import org.jboss.tools.batch.ui.internal.wizard.WizardMessages;
import org.jboss.tools.common.util.FileUtil;

public class NewBatchArtifactWizard
extends NewElementWizard
implements BatchConstants {
    public static final String WIZARD_ID = "org.jboss.tools.batch.ui.internal.wizard.NewBatchArtifactWizard";
    protected boolean fOpenEditorOnFinish = true;
    protected NewBatchArtifactWizardPage fPage;
    protected List<BatchArtifactType> types = null;

    public NewBatchArtifactWizard() {
        this.setWindowTitle(WizardMessages.NEW_BATCH_ARTIFACT_WIZARD_TITLE);
    }

    public void setTypes(List<BatchArtifactType> types) {
        this.types = types;
    }

    public List<BatchArtifactType> getTypes() {
        return this.types;
    }

    public void addPages() {
        if (this.fPage == null) {
            this.fPage = new NewBatchArtifactWizardPage();
            this.fPage.setWizard((IWizard)this);
            this.fPage.init(this.getSelection());
        } else {
            this.fPage.setWizard((IWizard)this);
        }
        this.addPage((IWizardPage)this.fPage);
    }

    public NewBatchArtifactWizardPage getPage() {
        return this.fPage;
    }

    public boolean isOpenEditorAfterFinish() {
        return this.fOpenEditorOnFinish;
    }

    public void setOpenEditorAfterFinish(boolean set) {
        this.fOpenEditorOnFinish = set;
    }

    public String getQualifiedClassName() {
        IType type = this.fPage.getCreatedType();
        return type == null ? "" : type.getFullyQualifiedName();
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.fPage.createType(monitor);
    }

    public IJavaElement getCreatedElement() {
        return this.fPage.getCreatedType();
    }

    public boolean performFinish() {
        this.warnAboutTypeCommentDeprecation();
        boolean res = super.performFinish();
        if (res) {
            this.registerInBatchXML();
            IResource resource = this.fPage.getModifiedResource();
            if (resource != null) {
                this.selectAndReveal(resource);
                if (this.fOpenEditorOnFinish) {
                    this.openResource((IFile)resource);
                }
            }
        }
        return res;
    }

    private void registerInBatchXML() {
        if ("xml".equals(this.fPage.nameOptions.getValueAsString())) {
            IPath path = BatchUtil.getBatchXMLPath((IProject)this.fPage.getJavaProject().getProject());
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            String insert = "\t<ref class=\"" + this.fPage.getQualifiedName() + "\" " + "id" + "=\"" + this.fPage.name.getValueAsString() + "\"/>" + "\n";
            try {
                IContainer c = file.getParent();
                while (!c.exists()) {
                    c = c.getParent();
                }
                File f = null;
                f = !file.exists() ? new File(BatchUtil.getTemplatesFolder(), "batch.xml") : file.getLocation().toFile();
                String text = FileUtil.readFile((File)f);
                int i = text.indexOf("</batch-artifacts>");
                text = String.valueOf(text.substring(0, i)) + insert + text.substring(i);
                FileUtil.writeFile((File)file.getLocation().toFile(), (String)text);
                c.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (IOException e) {
                BatchCorePlugin.pluginLog().logError((Throwable)e);
            }
            catch (CoreException e) {
                BatchCorePlugin.pluginLog().logError((Throwable)e);
            }
        }
    }
}

