/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.editor.internal.services.diagram.connection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.def.PartDef;
import org.eclipse.sapphire.ui.diagram.ConnectionAddEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionDeleteEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionEndpointsEvent;
import org.eclipse.sapphire.ui.diagram.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.StandardConnectionService;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.jboss.tools.batch.ui.editor.internal.model.FlowElement;
import org.jboss.tools.batch.ui.editor.internal.model.FlowElementsContainer;
import org.jboss.tools.batch.ui.editor.internal.model.NextAttributeElement;
import org.jboss.tools.batch.ui.editor.internal.services.diagram.connection.BatchDiagramConnectionEventHandler;
import org.jboss.tools.batch.ui.editor.internal.services.diagram.connection.NextAttributeConnectionPart;

public class BatchDiagramConnectionService
extends StandardConnectionService {
    private List<DiagramConnectionPart> connections;
    private Set<NextAttributeElement> nextAttributeElements = new HashSet<NextAttributeElement>();
    private Map<NextAttributeElement, FlowElement> nodesConnectionsMap = new HashMap<NextAttributeElement, FlowElement>();
    private SapphireDiagramEditorPagePart diagramPart;
    private EventHandler eventHandler = new EventHandler();

    protected void init() {
        super.init();
        this.diagramPart = (SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class);
    }

    public boolean valid(DiagramNodePart node1, DiagramNodePart node2, String connectionType) {
        FlowElement f;
        if ("NextAttributeConnection".equals(connectionType)) {
            return this.valid(node1, node2);
        }
        Element target = node2.getLocalModelElement();
        if (target instanceof FlowElement && ((f = (FlowElement)target).getId() == null || f.getId().content() == null)) {
            return false;
        }
        return super.valid(node1, node2, connectionType);
    }

    public DiagramConnectionPart connect(DiagramNodePart node1, DiagramNodePart node2, String connectionType) {
        if ("NextAttributeConnection".equals(connectionType)) {
            return this.connect(node1, node2);
        }
        return super.connect(node1, node2, connectionType);
    }

    public List<DiagramConnectionPart> list() {
        ArrayList<DiagramConnectionPart> allConnections = new ArrayList<DiagramConnectionPart>();
        if (this.connections == null) {
            this.initConnections();
        }
        allConnections.addAll(this.connections);
        allConnections.addAll(super.list());
        return allConnections;
    }

    private boolean valid(DiagramNodePart node1, DiagramNodePart node2) {
        Element src = node1.getLocalModelElement();
        if (!(src instanceof NextAttributeElement)) {
            return false;
        }
        FlowElement target = (FlowElement)node2.getLocalModelElement();
        if (target.getId().empty()) {
            return false;
        }
        if (src.equals(target)) {
            return false;
        }
        FlowElement existingConnectionTarget = this.nodesConnectionsMap.get(src);
        return existingConnectionTarget == null || !existingConnectionTarget.equals(target);
    }

    private DiagramConnectionPart connect(DiagramNodePart node1, DiagramNodePart node2) {
        FlowElement target = (FlowElement)node2.getLocalModelElement();
        String nextId = (String)target.getId().content();
        NextAttributeElement src = (NextAttributeElement)node1.getLocalModelElement();
        src.setNext(nextId);
        FlowElement existingEndpoint = this.nodesConnectionsMap.get(node1.getLocalModelElement());
        if (existingEndpoint == null) {
            return this.addConnectionPart(src, target);
        }
        return null;
    }

    private void initConnections() {
        this.connections = new ArrayList<DiagramConnectionPart>();
        if (this.diagramPart == null) {
            return;
        }
        FlowElementsContainer currentModelRoot = (FlowElementsContainer)this.diagramPart.getLocalModelElement();
        this.attachListenerForNewNodes(currentModelRoot.getFlowElements());
        for (FlowElement src : currentModelRoot.getFlowElements()) {
            if (src instanceof NextAttributeElement) {
                this.initializeNextAttributeElement((NextAttributeElement)((Object)src));
            }
            this.initializeTargetElement(src);
        }
    }

    private void initializeTargetElement(final FlowElement target) {
        target.getId().attach((Listener)new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                BatchDiagramConnectionService.this.connectIfIsTarget(target);
            }
        });
    }

    private void connectIfIsTarget(FlowElement target) {
        for (NextAttributeElement src : this.nextAttributeElements) {
            String next = (String)src.getNext().content();
            if (next == null || !next.equals(target.getId().content()) || this.nodesConnectionsMap.containsKey(src)) continue;
            this.addConnectionPart(src, target);
        }
    }

    private void initializeNextAttributeElement(NextAttributeElement src) {
        ReferenceValue<String, FlowElement> next = src.getNext();
        if (next.target() != null) {
            this.addConnectionPart(src, (FlowElement)next.target());
        }
        this.nextAttributeElements.add(src);
        this.attachListenerForNewConnection(src);
    }

    private void attachListenerForNewNodes(final ElementList<FlowElement> flowElements) {
        flowElements.attach((Listener)new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                Iterator nextIt = BatchDiagramConnectionService.this.nextAttributeElements.iterator();
                while (nextIt.hasNext()) {
                    NextAttributeElement next = (NextAttributeElement)nextIt.next();
                    if (flowElements.contains((Object)next)) continue;
                    nextIt.remove();
                    Iterator connIt = BatchDiagramConnectionService.this.connections.iterator();
                    while (connIt.hasNext()) {
                        DiagramConnectionPart c = (DiagramConnectionPart)connIt.next();
                        if (!c.getEndpoint1().equals(next)) continue;
                        connIt.remove();
                        BatchDiagramConnectionService.this.nodesConnectionsMap.remove(c.getEndpoint1());
                        BatchDiagramConnectionService.this.broadcast((Event)new ConnectionDeleteEvent(c));
                    }
                }
                for (FlowElement element : flowElements) {
                    if (element instanceof NextAttributeElement && !BatchDiagramConnectionService.this.nextAttributeElements.contains(element)) {
                        BatchDiagramConnectionService.this.initializeNextAttributeElement((NextAttributeElement)((Object)element));
                    }
                    BatchDiagramConnectionService.this.initializeTargetElement(element);
                    BatchDiagramConnectionService.this.connectIfIsTarget(element);
                }
            }
        });
    }

    private void attachListenerForNewConnection(final NextAttributeElement element) {
        element.attach((Listener)new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                if (!BatchDiagramConnectionService.this.nodesConnectionsMap.containsKey(element)) {
                    BatchDiagramConnectionService.this.addConnectionPart(element, (FlowElement)element.getNext().target());
                }
            }
        }, NextAttributeElement.PROP_NEXT.name());
    }

    private DiagramConnectionPart addConnectionPart(NextAttributeElement src, FlowElement target) {
        this.nodesConnectionsMap.put(src, target);
        NextAttributeConnectionPart connectionPart = new NextAttributeConnectionPart(src, target, this, this.eventHandler);
        connectionPart.init((ISapphirePart)this.diagramPart, src, (PartDef)this.diagramPart.getDiagramConnectionDef("NextAttributeConnection"), Collections.emptyMap());
        connectionPart.initialize();
        this.connections.add(connectionPart);
        return connectionPart;
    }

    private final class EventHandler
    implements BatchDiagramConnectionEventHandler {
        private EventHandler() {
        }

        @Override
        public void onConnectionEndpointsEvent(ConnectionEndpointsEvent event) {
            BatchDiagramConnectionService.this.nodesConnectionsMap.put((NextAttributeElement)event.part().getEndpoint1(), (FlowElement)event.part().getEndpoint2());
            BatchDiagramConnectionService.this.broadcast((Event)event);
        }

        @Override
        public void onConnectionAddEvent(ConnectionAddEvent event) {
            BatchDiagramConnectionService.this.broadcast((Event)event);
        }

        @Override
        public void onConnectionDeleteEvent(ConnectionDeleteEvent event) {
            BatchDiagramConnectionService.this.connections.remove(event.part());
            BatchDiagramConnectionService.this.nodesConnectionsMap.remove(event.part().getEndpoint1());
            BatchDiagramConnectionService.this.broadcast((Event)event);
        }
    }
}

