/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.editor.internal.model;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.ui.SapphireEditor;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.def.EditorPageDef;
import org.eclipse.sapphire.ui.forms.swt.MasterDetailsEditorPage;
import org.eclipse.sapphire.ui.swt.gef.SapphireDiagramEditor;
import org.eclipse.sapphire.ui.swt.xml.editor.XmlEditorResourceStore;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.jboss.tools.batch.ui.editor.internal.model.FlowElementsContainer;
import org.jboss.tools.batch.ui.editor.internal.model.Job;
import org.jboss.tools.common.text.ext.IMultiPageEditor;

public class JobXMLEditor
extends SapphireEditor
implements IMultiPageEditor {
    public static final int DESIGN_PAGE_INDEX = 0;
    public static final int DIAGRAM_PAGE_INDEX = 1;
    private Job model;
    private FlowElementsContainer currentDiagramModel;
    private StructuredTextEditor schemaSourceEditor;
    private JSapphireDiagramEditor schemaDiagram;
    private MasterDetailsEditorPage design;

    protected void createSourcePages() throws PartInitException {
        this.schemaSourceEditor = new StructuredTextEditor();
        this.schemaSourceEditor.setEditorPart((IEditorPart)this);
        int index = this.addPage((IEditorPart)this.schemaSourceEditor, this.getEditorInput());
        this.setPageText(index, "Source");
    }

    protected Element createModel() {
        this.model = (Job)Job.TYPE.instantiate((Resource)new RootXmlResource((XmlResourceStore)new XmlEditorResourceStore((SapphireEditor)this, this.schemaSourceEditor)));
        this.currentDiagramModel = this.model;
        return this.model;
    }

    public FlowElementsContainer getCurrentDiagramModel() {
        return this.currentDiagramModel;
    }

    protected void createDiagramPages() throws PartInitException {
        JSapphireDiagramEditor oldDiagram = this.schemaDiagram;
        this.schemaDiagram = new JSapphireDiagramEditor(this, this, this.currentDiagramModel, DefinitionLoader.sdef(((Object)((Object)this)).getClass()).page("DiagramPage")){};
        this.addEditorPage(1, (IEditorPart)this.schemaDiagram);
        if (oldDiagram != null) {
            oldDiagram.rehook(this.schemaDiagram);
        }
    }

    protected void createFormPages() throws PartInitException {
        this.createModel();
        this.design = new MasterDetailsEditorPage((SapphireEditor)this, (Element)this.model, DefinitionLoader.sdef(((Object)((Object)this)).getClass()).page("design"));
        this.addPage(0, (IFormPage)this.design);
    }

    public Job getSchema() {
        return this.model;
    }

    public void doSave(IProgressMonitor monitor) {
        this.schemaDiagram.doSave(monitor);
        super.doSave(monitor);
    }

    public StructuredTextEditor getSourceEditor() {
        return this.schemaSourceEditor;
    }

    public MasterDetailsEditorPage getFormEditor() {
        return this.design;
    }

    public void changeDiagramContent(FlowElementsContainer newRoot) {
        this.currentDiagramModel = newRoot;
        try {
            this.createDiagramPages();
        }
        catch (PartInitException e) {
            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
        }
        this.removePage(2);
        this.setActiveEditor((IEditorPart)this.schemaDiagram);
    }

    public void switchToSourceTab() {
        this.setActiveEditor((IEditorPart)this.schemaSourceEditor);
    }

    class JSapphireDiagramEditor
    extends SapphireDiagramEditor {
        GraphicalEditorWithFlyoutPalette.CustomPalettePage palettePage;

        public JSapphireDiagramEditor(SapphireEditor editor, Element element, DefinitionLoader.Reference<EditorPageDef> definition) {
            super(editor, element, definition);
            this.palettePage = null;
        }

        protected GraphicalEditorWithFlyoutPalette.CustomPalettePage createPalettePage() {
            this.palettePage = super.createPalettePage();
            return this.palettePage;
        }

        void rehook(JSapphireDiagramEditor schemaDiagram) {
            schemaDiagram.palettePage = this.palettePage;
            if (this.palettePage != null) {
                PaletteViewer viewer = this.palettePage.getPaletteViewer();
                schemaDiagram.getEditDomain().setPaletteViewer(viewer);
            }
        }
    }
}

