/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.editor.internal.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.jboss.tools.batch.core.BatchArtifactType;
import org.jboss.tools.batch.core.BatchCorePlugin;
import org.jboss.tools.batch.core.IBatchArtifact;
import org.jboss.tools.batch.core.IBatchProject;
import org.jboss.tools.batch.ui.BatchUIPlugin;
import org.jboss.tools.batch.ui.editor.internal.model.Batchlet;
import org.jboss.tools.batch.ui.editor.internal.model.BatchletOrChunk;
import org.jboss.tools.batch.ui.editor.internal.model.RefAttributeElement;
import org.jboss.tools.batch.ui.editor.internal.model.Step;
import org.jboss.tools.batch.ui.editor.internal.util.ModelToBatchArtifactsMapping;
import org.jboss.tools.batch.ui.internal.wizard.BatchFieldEditorFactory;
import org.jboss.tools.batch.ui.internal.wizard.NewBatchArtifactWizard;
import org.jboss.tools.batch.ui.internal.wizard.WizardMessages;
import org.jboss.tools.common.EclipseUtil;

public class OpenOrCreateArtifactActionDelegate
implements Runnable {
    static String qualifiedNamePrefix = "create.artifact.package.";
    private IBatchProject batchProject;
    private RefAttributeElement refElement;
    private String ref;
    private List<BatchArtifactType> types;
    private String artifactTypeName = null;

    public OpenOrCreateArtifactActionDelegate(SapphirePart part) {
        Step e;
        ElementList<BatchletOrChunk> ch;
        Element element = part.getLocalModelElement();
        IProject project = (IProject)element.resource().adapt(IProject.class);
        if (!(element instanceof RefAttributeElement) || project == null) {
            return;
        }
        this.batchProject = BatchCorePlugin.getBatchProject((IProject)project, (boolean)true);
        if (this.batchProject == null) {
            return;
        }
        this.refElement = (RefAttributeElement)element;
        this.ref = (String)this.refElement.getRef().content();
        this.types = ModelToBatchArtifactsMapping.getBatchArtifactTypes(((Element)this.refElement).type().getModelElementClass());
        if (this.types.size() > 1 && !(ch = (e = (Step)((Element)this.refElement).parent().element()).getBatchletOrChunk()).isEmpty() && ch.get(0) instanceof Batchlet) {
            this.types = new ArrayList<BatchArtifactType>();
            this.types.add(BatchArtifactType.STEP_LISTENER);
        }
        this.artifactTypeName = this.types.size() == 1 ? BatchFieldEditorFactory.getArtifactLabel(this.types.get(0)) : WizardMessages.aChunkStepListenerLabel;
        if (this.artifactTypeName != null) {
            this.artifactTypeName = this.artifactTypeName.toLowerCase();
        }
    }

    public IBatchProject getBatchProject() {
        return this.batchProject;
    }

    public String getActionLabel() {
        if (this.batchProject == null) {
            return "";
        }
        Collection artifacts = this.batchProject.getArtifacts(this.ref);
        return artifacts.isEmpty() ? NLS.bind((String)WizardMessages.actionCreateArtifact, (Object)this.artifactTypeName) : NLS.bind((String)WizardMessages.actionOpenArtifact, (Object)this.artifactTypeName);
    }

    @Override
    public void run() {
        Collection artifacts = this.batchProject.getArtifacts(this.ref);
        if (artifacts.isEmpty()) {
            int result;
            IResource[] rs;
            NewBatchArtifactWizard wizard = new NewBatchArtifactWizard();
            if (this.types.size() > 0) {
                wizard.setTypes(this.types);
            }
            if ((rs = EclipseUtil.getJavaSourceRoots((IProject)this.batchProject.getProject())).length == 0) {
                return;
            }
            StructuredSelection selection = new StructuredSelection((Object)rs[0]);
            IWorkbench workbench = BatchUIPlugin.getDefault().getWorkbench();
            wizard.init(workbench, (IStructuredSelection)selection);
            WizardDialog dialog = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
            dialog.create();
            if (this.ref != null) {
                wizard.getPage().setArtifactName(this.ref, this.ref.length() == 0);
                if (this.ref.length() > 0 && Character.isJavaIdentifierStart(this.ref.charAt(0))) {
                    String typeName = String.valueOf(this.ref.substring(0, 1).toUpperCase()) + this.ref.substring(1);
                    wizard.getPage().setTypeName(typeName, true);
                }
            }
            wizard.getPage().setArtifact(this.types.get(0), this.types.size() > 1);
            IPackageFragment pack = this.getPackage(this.types);
            if (pack != null) {
                wizard.getPage().setPackageFragment(pack, true);
            }
            if ((result = dialog.open()) == 0) {
                String newRef = wizard.getPage().getArtifactName();
                if (this.ref != null && !this.ref.equals(newRef)) {
                    this.refElement.setRef(newRef);
                } else {
                    this.refElement.setRef("");
                    this.refElement.setRef(newRef);
                }
                String packName = wizard.getPage().getPackageFragment().getPath().toString();
                QualifiedName qn = new QualifiedName("", String.valueOf(qualifiedNamePrefix) + this.types.get(0).toString());
                try {
                    this.batchProject.getProject().setPersistentProperty(qn, packName);
                }
                catch (CoreException e) {
                    BatchCorePlugin.pluginLog().logError((Throwable)e);
                }
            }
        } else {
            IBatchArtifact a = (IBatchArtifact)artifacts.iterator().next();
            try {
                JavaUI.openInEditor((IJavaElement)a.getType());
            }
            catch (PartInitException e) {
                BatchCorePlugin.pluginLog().logError((Throwable)e);
            }
            catch (JavaModelException e) {
                BatchCorePlugin.pluginLog().logError((Throwable)e);
            }
        }
    }

    private IPackageFragment getPackage(List<BatchArtifactType> types) {
        IProject p = this.batchProject.getProject();
        QualifiedName qn = new QualifiedName("", String.valueOf(qualifiedNamePrefix) + types.get(0).toString());
        try {
            IPackageFragment result;
            IJavaProject jp;
            String packPath = this.batchProject.getProject().getPersistentProperty(qn);
            if (packPath != null && packPath.length() > 0 && (jp = EclipseUtil.getJavaProject((IProject)p)) != null && (result = jp.findPackageFragment((IPath)new Path(packPath))) != null && result.exists()) {
                return result;
            }
        }
        catch (CoreException e) {
            BatchCorePlugin.pluginLog().logError((Throwable)e);
        }
        return this.findPackage(types);
    }

    private IPackageFragment findPackage(List<BatchArtifactType> types) {
        for (BatchArtifactType type : types) {
            Iterator iterator = this.batchProject.getArtifacts(type).iterator();
            if (!iterator.hasNext()) continue;
            IBatchArtifact a = (IBatchArtifact)iterator.next();
            return a.getType().getPackageFragment();
        }
        return null;
    }
}

