/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.batch.core.BatchArtifactType;
import org.jboss.tools.batch.ui.BatchUIPlugin;
import org.jboss.tools.batch.ui.editor.internal.model.Job;
import org.jboss.tools.common.ui.CommonUIImages;

public class JobImages {
    public static final String ANALYZER_IMAGE = "partition.png";
    public static final String BATCHLET_IMAGE = "batchlet.png";
    public static final String CHECKPOINT_ALGORITHM_IMAGE = "checkpoint-algorithm.png";
    public static final String COLLECTOR_IMAGE = "partition.png";
    public static final String DECISION_IMAGE = "decision.png";
    public static final String FLOW_IMAGE = "flow.png";
    public static final String JOB_LISTENER_IMAGE = "listener.png";
    public static final String JOB_IMAGE = "job.png";
    public static final String MAPPER_IMAGE = "partition.png";
    public static final String PROCESSOR_IMAGE = "processor.png";
    public static final String PROPERTY_IMAGE = "property.png";
    public static final String READER_IMAGE = "reader.png";
    public static final String REDUCER_IMAGE = "partition.png";
    public static final String STEP_LISTENER_IMAGE = "listener.png";
    public static final String WRITER_IMAGE = "writer.png";
    public static final String NEW_JOB_XML_IMAGE = "BatchXMLWizBan.png";
    public static final String NEW_ARTIFACT_IMAGE = "BatchArtifactWizBan.png";

    private JobImages() {
    }

    public static Image getImage(String key) {
        return JobImages.getImage(JobImages.getImageDescriptor(key));
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor descriptor = JobImages.getImageRegistry().getDescriptor(key);
        if (descriptor == null) {
            descriptor = ImageDescriptor.createFromFile(Job.class, (String)key);
            JobImages.getImageRegistry().put(key, descriptor);
        }
        return descriptor;
    }

    static ImageRegistry getImageRegistry() {
        return BatchUIPlugin.getDefault().getImageRegistry();
    }

    static Image getImage(ImageDescriptor descriptor) {
        return CommonUIImages.getImage((ImageDescriptor)descriptor);
    }

    public static Image getImageByElement(BatchArtifactType element) {
        return JobImages.getImage(JobImages.getImageDescriptorByElement(element));
    }

    public static ImageDescriptor getImageDescriptorByElement(BatchArtifactType element) {
        if (element == BatchArtifactType.BATCHLET) {
            return JobImages.getImageDescriptor(BATCHLET_IMAGE);
        }
        if (element == BatchArtifactType.CHECKPOINT_ALGORITHM) {
            return JobImages.getImageDescriptor(CHECKPOINT_ALGORITHM_IMAGE);
        }
        if (element == BatchArtifactType.DECIDER) {
            return JobImages.getImageDescriptor(DECISION_IMAGE);
        }
        if (element == BatchArtifactType.ITEM_READER) {
            return JobImages.getImageDescriptor(READER_IMAGE);
        }
        if (element == BatchArtifactType.ITEM_WRITER) {
            return JobImages.getImageDescriptor(WRITER_IMAGE);
        }
        if (element == BatchArtifactType.ITEM_PROCESSOR) {
            return JobImages.getImageDescriptor(PROCESSOR_IMAGE);
        }
        if (element == BatchArtifactType.PARTITION_MAPPER) {
            return JobImages.getImageDescriptor("partition.png");
        }
        if (element == BatchArtifactType.PARTITION_COLLECTOR) {
            return JobImages.getImageDescriptor("partition.png");
        }
        if (element == BatchArtifactType.PARTITION_ANALYZER) {
            return JobImages.getImageDescriptor("partition.png");
        }
        if (element == BatchArtifactType.PARTITION_REDUCER) {
            return JobImages.getImageDescriptor("partition.png");
        }
        if (element == BatchArtifactType.JOB_LISTENER) {
            return JobImages.getImageDescriptor("listener.png");
        }
        if (element.getTag().equals("step")) {
            return JobImages.getImageDescriptor("listener.png");
        }
        return null;
    }
}

