/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.core.connection;

import com.openshift.restclient.model.IResource;
import java.util.Collection;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionNotFoundException;

public class ConnectionsRegistryUtil {
    private ConnectionsRegistryUtil() {
    }

    public static Connection getConnectionFor(IResource resource) {
        Connection connection = ConnectionsRegistryUtil.safeGetConnectionFor(resource);
        if (connection == null) {
            throw new ConnectionNotFoundException(resource);
        }
        return connection;
    }

    public static Connection safeGetConnectionFor(IResource resource) {
        Collection all = ConnectionsRegistrySingleton.getInstance().getAll(Connection.class);
        for (Connection connection : all) {
            if (!connection.ownsResource(resource)) continue;
            return connection;
        }
        return null;
    }
}

